/*
 * Decompiled with CFR 0.152.
 */
package org.altbeacon.beacon.logging;

import android.util.Log;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.MissingFormatArgumentException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.altbeacon.beacon.logging.Logger;
import org.altbeacon.beacon.logging.VerboseAndroidLogger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0002\b\u000b\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\t\u001a\u00020\nJ9\u0010\u000b\u001a\u00020\n2\b\u0010\f\u001a\u0004\u0018\u00010\u00052\b\u0010\r\u001a\u0004\u0018\u00010\u00052\u0016\u0010\u000e\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00100\u000f\"\u0004\u0018\u00010\u0010H\u0016\u00a2\u0006\u0002\u0010\u0011JC\u0010\u000b\u001a\u00020\n2\b\u0010\u0012\u001a\u0004\u0018\u00010\u00132\b\u0010\f\u001a\u0004\u0018\u00010\u00052\b\u0010\r\u001a\u0004\u0018\u00010\u00052\u0016\u0010\u000e\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00100\u000f\"\u0004\u0018\u00010\u0010H\u0016\u00a2\u0006\u0002\u0010\u0014J9\u0010\u0015\u001a\u00020\n2\b\u0010\f\u001a\u0004\u0018\u00010\u00052\b\u0010\r\u001a\u0004\u0018\u00010\u00052\u0016\u0010\u000e\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00100\u000f\"\u0004\u0018\u00010\u0010H\u0016\u00a2\u0006\u0002\u0010\u0011JC\u0010\u0015\u001a\u00020\n2\b\u0010\u0012\u001a\u0004\u0018\u00010\u00132\b\u0010\f\u001a\u0004\u0018\u00010\u00052\b\u0010\r\u001a\u0004\u0018\u00010\u00052\u0016\u0010\u000e\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00100\u000f\"\u0004\u0018\u00010\u0010H\u0016\u00a2\u0006\u0002\u0010\u0014J/\u0010\u0016\u001a\u00020\u00052\b\u0010\r\u001a\u0004\u0018\u00010\u00052\u0016\u0010\u000e\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00100\u000f\"\u0004\u0018\u00010\u0010H\u0004\u00a2\u0006\u0002\u0010\u0017J\u0011\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00050\u000f\u00a2\u0006\u0002\u0010\u0019J9\u0010\u001a\u001a\u00020\n2\b\u0010\f\u001a\u0004\u0018\u00010\u00052\b\u0010\r\u001a\u0004\u0018\u00010\u00052\u0016\u0010\u000e\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00100\u000f\"\u0004\u0018\u00010\u0010H\u0016\u00a2\u0006\u0002\u0010\u0011JC\u0010\u001a\u001a\u00020\n2\b\u0010\u0012\u001a\u0004\u0018\u00010\u00132\b\u0010\f\u001a\u0004\u0018\u00010\u00052\b\u0010\r\u001a\u0004\u0018\u00010\u00052\u0016\u0010\u000e\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00100\u000f\"\u0004\u0018\u00010\u0010H\u0016\u00a2\u0006\u0002\u0010\u0014J\u0012\u0010\u001b\u001a\u00020\n2\b\u0010\r\u001a\u0004\u0018\u00010\u0005H\u0002J9\u0010\u001c\u001a\u00020\n2\b\u0010\f\u001a\u0004\u0018\u00010\u00052\b\u0010\r\u001a\u0004\u0018\u00010\u00052\u0016\u0010\u000e\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00100\u000f\"\u0004\u0018\u00010\u0010H\u0016\u00a2\u0006\u0002\u0010\u0011JC\u0010\u001c\u001a\u00020\n2\b\u0010\u0012\u001a\u0004\u0018\u00010\u00132\b\u0010\f\u001a\u0004\u0018\u00010\u00052\b\u0010\r\u001a\u0004\u0018\u00010\u00052\u0016\u0010\u000e\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00100\u000f\"\u0004\u0018\u00010\u0010H\u0016\u00a2\u0006\u0002\u0010\u0014J9\u0010\u001d\u001a\u00020\n2\b\u0010\f\u001a\u0004\u0018\u00010\u00052\b\u0010\r\u001a\u0004\u0018\u00010\u00052\u0016\u0010\u000e\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00100\u000f\"\u0004\u0018\u00010\u0010H\u0016\u00a2\u0006\u0002\u0010\u0011JC\u0010\u001d\u001a\u00020\n2\b\u0010\u0012\u001a\u0004\u0018\u00010\u00132\b\u0010\f\u001a\u0004\u0018\u00010\u00052\b\u0010\r\u001a\u0004\u0018\u00010\u00052\u0016\u0010\u000e\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00100\u000f\"\u0004\u0018\u00010\u0010H\u0016\u00a2\u0006\u0002\u0010\u0014R\u001e\u0010\u0003\u001a\u0012\u0012\u0004\u0012\u00020\u00050\u0004j\b\u0012\u0004\u0012\u00020\u0005`\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lorg/altbeacon/beacon/logging/ApiTrackingLogger;", "Lorg/altbeacon/beacon/logging/Logger;", "()V", "apiCalls", "Ljava/util/ArrayList;", "", "Lkotlin/collections/ArrayList;", "dateformat", "Ljava/text/SimpleDateFormat;", "clearApiCalls", "", "d", "tag", "message", "args", "", "", "(Ljava/lang/String;Ljava/lang/String;[Ljava/lang/Object;)V", "t", "", "(Ljava/lang/Throwable;Ljava/lang/String;Ljava/lang/String;[Ljava/lang/Object;)V", "e", "formatString", "(Ljava/lang/String;[Ljava/lang/Object;)Ljava/lang/String;", "getApiCalls", "()[Ljava/lang/String;", "i", "trackApiLogs", "v", "w", "android-beacon-library_release"})
@SourceDebugExtension(value={"SMAP\nApiTrackingLogger.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ApiTrackingLogger.kt\norg/altbeacon/beacon/logging/ApiTrackingLogger\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,86:1\n37#2,2:87\n*S KotlinDebug\n*F\n+ 1 ApiTrackingLogger.kt\norg/altbeacon/beacon/logging/ApiTrackingLogger\n*L\n80#1:87,2\n*E\n"})
public final class ApiTrackingLogger
implements Logger {
    @NotNull
    private ArrayList<String> apiCalls = new ArrayList();
    @NotNull
    private final SimpleDateFormat dateformat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");

    @NotNull
    protected final String formatString(@Nullable String message, Object ... args) {
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        try {
            String string;
            if (args.length == 0 || message == null) {
                String string2 = message;
                string = string2;
                Intrinsics.checkNotNull((Object)string2);
            } else {
                String string3 = message;
                Object[] objectArray = Arrays.copyOf(args, args.length);
                String string4 = String.format(string3, Arrays.copyOf(objectArray, objectArray.length));
                string = string4;
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"format(format, *args)");
            }
            return string;
        }
        catch (MissingFormatArgumentException e) {
            String string = message;
            Intrinsics.checkNotNull((Object)string);
            return string;
        }
    }

    @Override
    public void v(@Nullable String tag, @Nullable String message, Object ... args) {
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        this.trackApiLogs(message);
        Log.v((String)tag, (String)new VerboseAndroidLogger().formatString(message, Arrays.copyOf(args, args.length)));
    }

    @Override
    public void v(@Nullable Throwable t, @Nullable String tag, @Nullable String message, Object ... args) {
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        this.trackApiLogs(message);
        Log.v((String)tag, (String)this.formatString(message, Arrays.copyOf(args, args.length)), (Throwable)t);
    }

    @Override
    public void d(@Nullable String tag, @Nullable String message, Object ... args) {
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        this.trackApiLogs(message);
        Log.d((String)tag, (String)this.formatString(message, Arrays.copyOf(args, args.length)));
    }

    @Override
    public void d(@Nullable Throwable t, @Nullable String tag, @Nullable String message, Object ... args) {
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        this.trackApiLogs(message);
        Log.d((String)tag, (String)this.formatString(message, Arrays.copyOf(args, args.length)), (Throwable)t);
    }

    @Override
    public void i(@Nullable String tag, @Nullable String message, Object ... args) {
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        this.trackApiLogs(message);
        Log.i((String)tag, (String)this.formatString(message, Arrays.copyOf(args, args.length)));
    }

    @Override
    public void i(@Nullable Throwable t, @Nullable String tag, @Nullable String message, Object ... args) {
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        this.trackApiLogs(message);
        Log.i((String)tag, (String)this.formatString(message, Arrays.copyOf(args, args.length)), (Throwable)t);
    }

    @Override
    public void w(@Nullable String tag, @Nullable String message, Object ... args) {
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        this.trackApiLogs(message);
        Log.w((String)tag, (String)this.formatString(message, Arrays.copyOf(args, args.length)));
    }

    @Override
    public void w(@Nullable Throwable t, @Nullable String tag, @Nullable String message, Object ... args) {
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        this.trackApiLogs(message);
        Log.w((String)tag, (String)this.formatString(message, Arrays.copyOf(args, args.length)), (Throwable)t);
    }

    @Override
    public void e(@Nullable String tag, @Nullable String message, Object ... args) {
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        this.trackApiLogs(message);
        Log.e((String)tag, (String)this.formatString(message, Arrays.copyOf(args, args.length)));
    }

    @Override
    public void e(@Nullable Throwable t, @Nullable String tag, @Nullable String message, Object ... args) {
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        this.trackApiLogs(message);
        Log.e((String)tag, (String)this.formatString(message, Arrays.copyOf(args, args.length)), (Throwable)t);
    }

    private final void trackApiLogs(String message) {
        if (message != null && StringsKt.indexOf$default((CharSequence)message, (String)"API", (int)0, (boolean)false, (int)6, null) == 0) {
            StringBuilder sb = new StringBuilder();
            sb.append(this.dateformat.format(new Date()));
            sb.append(" ");
            sb.append(message);
            this.apiCalls.add(sb.toString());
        }
    }

    @NotNull
    public final String[] getApiCalls() {
        Collection $this$toTypedArray$iv = this.apiCalls;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        return thisCollection$iv.toArray(new String[0]);
    }

    public final void clearApiCalls() {
        this.apiCalls.clear();
    }
}

