/*
 * Decompiled with CFR 0.152.
 */
package org.altbeacon.beacon.service;

import android.os.SystemClock;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import org.altbeacon.beacon.Beacon;
import org.altbeacon.beacon.BeaconManager;
import org.altbeacon.beacon.logging.LogManager;
import org.altbeacon.beacon.service.RssiFilter;
import org.altbeacon.beacon.service.RunningAverageRssiFilter;

public class RangedBeacon
implements Serializable {
    private static final String TAG = "RangedBeacon";
    public static final long DEFAULT_MAX_TRACKING_AGE = 5000L;
    public static long maxTrackingAge = 5000L;
    public static final long DEFAULT_SAMPLE_EXPIRATION_MILLISECONDS = 20000L;
    private static long sampleExpirationMilliseconds = 20000L;
    private boolean mTracked = true;
    protected long lastTrackedTimeMillis = 0L;
    Beacon mBeacon;
    protected transient RssiFilter mFilter = null;
    private int packetCount = 0;
    private long firstCycleDetectionTimestamp = 0L;
    private long lastCycleDetectionTimestamp = 0L;

    public RangedBeacon(Beacon beacon) {
        this.updateBeacon(beacon);
    }

    public void updateBeacon(Beacon beacon) {
        ++this.packetCount;
        this.mBeacon = beacon;
        if (this.firstCycleDetectionTimestamp == 0L) {
            this.firstCycleDetectionTimestamp = beacon.getFirstCycleDetectionTimestamp();
        }
        this.lastCycleDetectionTimestamp = beacon.getLastCycleDetectionTimestamp();
        this.addMeasurement(this.mBeacon.getRssi());
    }

    public boolean isTracked() {
        return this.mTracked;
    }

    public void setTracked(boolean tracked) {
        this.mTracked = tracked;
    }

    public Beacon getBeacon() {
        return this.mBeacon;
    }

    public void commitMeasurements() {
        if (!this.getFilter().noMeasurementsAvailable()) {
            double runningAverage = this.getFilter().calculateRssi();
            this.mBeacon.setRunningAverageRssi(runningAverage);
            this.mBeacon.setRssiMeasurementCount(this.getFilter().getMeasurementCount());
            LogManager.d(TAG, "calculated new runningAverageRssi: %s", runningAverage);
        } else {
            LogManager.d(TAG, "No measurements available to calculate running average", new Object[0]);
        }
        this.mBeacon.setPacketCount(this.packetCount);
        this.mBeacon.setFirstCycleDetectionTimestamp(this.firstCycleDetectionTimestamp);
        this.mBeacon.setLastCycleDetectionTimestamp(this.lastCycleDetectionTimestamp);
        this.packetCount = 0;
        this.firstCycleDetectionTimestamp = 0L;
        this.lastCycleDetectionTimestamp = 0L;
    }

    public void addMeasurement(Integer rssi) {
        if (rssi != 127) {
            this.mTracked = true;
            this.lastTrackedTimeMillis = SystemClock.elapsedRealtime();
            this.getFilter().addMeasurement(rssi);
        }
    }

    public static void setSampleExpirationMilliseconds(long milliseconds) {
        sampleExpirationMilliseconds = milliseconds;
        RunningAverageRssiFilter.setSampleExpirationMilliseconds(sampleExpirationMilliseconds);
    }

    public static void setMaxTrackinAge(int maxTrackinAge) {
        maxTrackingAge = maxTrackinAge;
    }

    public boolean noMeasurementsAvailable() {
        return this.getFilter().noMeasurementsAvailable();
    }

    public long getTrackingAge() {
        return SystemClock.elapsedRealtime() - this.lastTrackedTimeMillis;
    }

    public boolean isExpired() {
        return this.getTrackingAge() > maxTrackingAge;
    }

    private RssiFilter getFilter() {
        if (this.mFilter == null) {
            try {
                Constructor<?> cons = BeaconManager.getRssiFilterImplClass().getConstructors()[0];
                this.mFilter = (RssiFilter)cons.newInstance(new Object[0]);
            }
            catch (Exception e) {
                LogManager.e(TAG, "Could not construct RssiFilterImplClass %s", BeaconManager.getRssiFilterImplClass().getName());
            }
        }
        return this.mFilter;
    }
}

