/*
 * Decompiled with CFR 0.152.
 */
package org.altbeacon.beacon;

import android.annotation.TargetApi;
import android.bluetooth.BluetoothDevice;
import android.util.Log;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.altbeacon.beacon.Beacon;
import org.altbeacon.beacon.Identifier;
import org.altbeacon.beacon.logging.LogManager;
import org.altbeacon.bluetooth.BleAdvertisement;
import org.altbeacon.bluetooth.Pdu;

public class BeaconParser
implements Serializable {
    private static final String TAG = "BeaconParser";
    public static final String ALTBEACON_LAYOUT = "m:2-3=beac,i:4-19,i:20-21,i:22-23,p:24-24,d:25-25";
    public static final String EDDYSTONE_TLM_LAYOUT = "x,s:0-1=feaa,m:2-2=20,d:3-3,d:4-5,d:6-7,d:8-11,d:12-15";
    public static final String EDDYSTONE_UID_LAYOUT = "s:0-1=feaa,m:2-2=00,p:3-3:-41,i:4-13,i:14-19";
    public static final String EDDYSTONE_URL_LAYOUT = "s:0-1=feaa,m:2-2=10,p:3-3:-41,i:4-21v";
    public static final String URI_BEACON_LAYOUT = "s:0-1=fed8,m:2-2=00,p:3-3:-41,i:4-21v";
    private static final Pattern I_PATTERN = Pattern.compile("i\\:(\\d+)\\-(\\d+)([blv]*)?");
    private static final Pattern M_PATTERN = Pattern.compile("m\\:(\\d+)-(\\d+)\\=([0-9A-Fa-f]+)");
    private static final Pattern S_PATTERN = Pattern.compile("s\\:(\\d+)-(\\d+)\\=([0-9A-Fa-f\\-]+)");
    private static final Pattern D_PATTERN = Pattern.compile("d\\:(\\d+)\\-(\\d+)([bl]*)?");
    private static final Pattern P_PATTERN = Pattern.compile("p\\:(\\d+)?\\-(\\d+)?\\:?([\\-\\d]+)?");
    private static final Pattern X_PATTERN = Pattern.compile("x");
    private static final char[] HEX_ARRAY = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    private static final String LITTLE_ENDIAN_SUFFIX = "l";
    private static final String VARIABLE_LENGTH_SUFFIX = "v";
    protected String mBeaconLayout;
    private Long mMatchingBeaconTypeCode;
    protected final List<Integer> mIdentifierStartOffsets = new ArrayList<Integer>();
    protected final List<Integer> mIdentifierEndOffsets = new ArrayList<Integer>();
    protected final List<Boolean> mIdentifierLittleEndianFlags = new ArrayList<Boolean>();
    protected final List<Integer> mDataStartOffsets = new ArrayList<Integer>();
    protected final List<Integer> mDataEndOffsets = new ArrayList<Integer>();
    protected final List<Boolean> mDataLittleEndianFlags = new ArrayList<Boolean>();
    protected final List<Boolean> mIdentifierVariableLengthFlags = new ArrayList<Boolean>();
    protected Integer mMatchingBeaconTypeCodeStartOffset;
    protected Integer mMatchingBeaconTypeCodeEndOffset;
    protected Integer mServiceUuidStartOffset;
    protected Integer mServiceUuidEndOffset;
    protected Long mServiceUuid;
    protected byte[] mServiceUuid128Bit = new byte[0];
    protected Boolean mExtraFrame;
    protected Integer mPowerStartOffset;
    protected Integer mPowerEndOffset;
    protected Integer mDBmCorrection;
    protected Integer mLayoutSize;
    protected Boolean mAllowPduOverflow = true;
    protected String mIdentifier;
    protected int[] mHardwareAssistManufacturers = new int[]{76};
    protected List<BeaconParser> extraParsers = new ArrayList<BeaconParser>();

    public BeaconParser() {
    }

    public BeaconParser(String identifier) {
        this.mIdentifier = identifier;
    }

    public BeaconParser setBeaconLayout(String beaconLayout) {
        this.mBeaconLayout = beaconLayout;
        Log.d((String)TAG, (String)("Parsing beacon layout: " + beaconLayout));
        String[] terms = beaconLayout.split(",");
        this.mExtraFrame = false;
        for (String term : terms) {
            Boolean littleEndian;
            int endOffset;
            int startOffset;
            boolean found = false;
            Matcher matcher = I_PATTERN.matcher(term);
            while (matcher.find()) {
                found = true;
                try {
                    startOffset = Integer.parseInt(matcher.group(1));
                    endOffset = Integer.parseInt(matcher.group(2));
                    littleEndian = matcher.group(3).contains(LITTLE_ENDIAN_SUFFIX);
                    this.mIdentifierLittleEndianFlags.add(littleEndian);
                    Boolean variableLength = matcher.group(3).contains(VARIABLE_LENGTH_SUFFIX);
                    this.mIdentifierVariableLengthFlags.add(variableLength);
                    this.mIdentifierStartOffsets.add(startOffset);
                    this.mIdentifierEndOffsets.add(endOffset);
                }
                catch (NumberFormatException e) {
                    throw new BeaconLayoutException("Cannot parse integer byte offset in term: " + term);
                }
            }
            matcher = D_PATTERN.matcher(term);
            while (matcher.find()) {
                found = true;
                try {
                    startOffset = Integer.parseInt(matcher.group(1));
                    endOffset = Integer.parseInt(matcher.group(2));
                    littleEndian = matcher.group(3).contains(LITTLE_ENDIAN_SUFFIX);
                    this.mDataLittleEndianFlags.add(littleEndian);
                    this.mDataStartOffsets.add(startOffset);
                    this.mDataEndOffsets.add(endOffset);
                }
                catch (NumberFormatException e) {
                    throw new BeaconLayoutException("Cannot parse integer byte offset in term: " + term);
                }
            }
            matcher = P_PATTERN.matcher(term);
            while (matcher.find()) {
                found = true;
                String correctionString = "none";
                try {
                    if (matcher.group(1) != null && matcher.group(2) != null) {
                        int startOffset2 = Integer.parseInt(matcher.group(1));
                        int endOffset2 = Integer.parseInt(matcher.group(2));
                        this.mPowerStartOffset = startOffset2;
                        this.mPowerEndOffset = endOffset2;
                    }
                    int dBmCorrection = 0;
                    if (matcher.group(3) != null) {
                        correctionString = matcher.group(3);
                        dBmCorrection = Integer.parseInt(correctionString);
                    }
                    this.mDBmCorrection = dBmCorrection;
                }
                catch (NumberFormatException e) {
                    throw new BeaconLayoutException("Cannot parse integer power byte offset (" + correctionString + ") in term: " + term);
                }
            }
            matcher = M_PATTERN.matcher(term);
            while (matcher.find()) {
                found = true;
                try {
                    int startOffset3 = Integer.parseInt(matcher.group(1));
                    endOffset = Integer.parseInt(matcher.group(2));
                    this.mMatchingBeaconTypeCodeStartOffset = startOffset3;
                    this.mMatchingBeaconTypeCodeEndOffset = endOffset;
                }
                catch (NumberFormatException e) {
                    throw new BeaconLayoutException("Cannot parse integer byte offset in term: " + term);
                }
                String hexString = matcher.group(3);
                try {
                    this.mMatchingBeaconTypeCode = Long.decode("0x" + hexString);
                }
                catch (NumberFormatException e) {
                    throw new BeaconLayoutException("Cannot parse beacon type code: " + hexString + " in term: " + term);
                }
            }
            matcher = S_PATTERN.matcher(term);
            while (matcher.find()) {
                found = true;
                try {
                    int startOffset4 = Integer.parseInt(matcher.group(1));
                    int endOffset3 = Integer.parseInt(matcher.group(2));
                    this.mServiceUuidStartOffset = startOffset4;
                    this.mServiceUuidEndOffset = endOffset3;
                }
                catch (NumberFormatException e) {
                    throw new BeaconLayoutException("Cannot parse integer byte offset in term: " + term);
                }
                String hexString = matcher.group(3);
                if (this.mServiceUuidEndOffset - this.mServiceUuidStartOffset + 1 == 2) {
                    try {
                        this.mServiceUuid = Long.decode("0x" + hexString);
                        continue;
                    }
                    catch (NumberFormatException e) {
                        throw new BeaconLayoutException("Cannot parse serviceUuid: " + hexString + " in term: " + term);
                    }
                }
                if (this.mServiceUuidEndOffset - this.mServiceUuidStartOffset + 1 == 16) {
                    String bytesString = hexString.replace("-", "");
                    if (bytesString.length() != 32) {
                        throw new BeaconLayoutException("128-bit ServiceUuid must be 16 bytes long: " + hexString + " in term: " + term);
                    }
                    this.mServiceUuid128Bit = new byte[16];
                    for (int i = 0; i < 16; ++i) {
                        String byteString = bytesString.substring(i * 2, i * 2 + 2);
                        try {
                            this.mServiceUuid128Bit[15 - i] = (byte)Integer.parseInt(byteString, 16);
                            continue;
                        }
                        catch (NumberFormatException e) {
                            throw new BeaconLayoutException("Cannot parse serviceUuid byte " + byteString + " in term: " + term);
                        }
                    }
                    continue;
                }
                throw new BeaconLayoutException("Cannot parse serviceUuid -- it must be 2 bytes or 16 bytes long: " + hexString + " in term: " + term);
            }
            matcher = X_PATTERN.matcher(term);
            while (matcher.find()) {
                found = true;
                this.mExtraFrame = true;
            }
            if (found) continue;
            LogManager.d(TAG, "cannot parse term %s", term);
            throw new BeaconLayoutException("Cannot parse beacon layout term: " + term);
        }
        this.mLayoutSize = this.calculateLayoutSize();
        return this;
    }

    public boolean addExtraDataParser(BeaconParser extraDataParser) {
        return extraDataParser != null && extraDataParser.mExtraFrame != false && this.extraParsers.add(extraDataParser);
    }

    public List<BeaconParser> getExtraDataParsers() {
        return new ArrayList<BeaconParser>(this.extraParsers);
    }

    public String getIdentifier() {
        return this.mIdentifier;
    }

    public int[] getHardwareAssistManufacturers() {
        return this.mHardwareAssistManufacturers;
    }

    public void setHardwareAssistManufacturerCodes(int[] manufacturers) {
        this.mHardwareAssistManufacturers = manufacturers;
    }

    public void setAllowPduOverflow(Boolean enabled) {
        this.mAllowPduOverflow = enabled;
    }

    public Long getMatchingBeaconTypeCode() {
        if (this.mMatchingBeaconTypeCode == null) {
            return -1L;
        }
        return this.mMatchingBeaconTypeCode;
    }

    public int getMatchingBeaconTypeCodeStartOffset() {
        if (this.mMatchingBeaconTypeCodeStartOffset == null) {
            return -1;
        }
        return this.mMatchingBeaconTypeCodeStartOffset;
    }

    public int getMatchingBeaconTypeCodeEndOffset() {
        if (this.mMatchingBeaconTypeCodeEndOffset == null) {
            return -1;
        }
        return this.mMatchingBeaconTypeCodeEndOffset;
    }

    public Long getServiceUuid() {
        return this.mServiceUuid;
    }

    public byte[] getServiceUuid128Bit() {
        return this.mServiceUuid128Bit;
    }

    public int getMServiceUuidStartOffset() {
        return this.mServiceUuidStartOffset;
    }

    public int getServiceUuidEndOffset() {
        return this.mServiceUuidEndOffset;
    }

    public Beacon fromScanData(byte[] scanData, int rssi, BluetoothDevice device, long timestampMs) {
        return this.fromScanData(scanData, rssi, device, timestampMs, new Beacon());
    }

    protected Beacon fromScanData(byte[] bytesToProcess, int rssi, BluetoothDevice device, long timestampMs, Beacon beacon) {
        int txPower;
        ArrayList<Long> dataFields;
        ArrayList<Identifier> identifiers;
        int startByte;
        boolean parseSucceeded;
        block50: {
            ArrayList<Pdu> pdusToParse;
            block49: {
                BleAdvertisement advert = new BleAdvertisement(bytesToProcess);
                parseSucceeded = false;
                pdusToParse = new ArrayList<Pdu>();
                startByte = 0;
                identifiers = new ArrayList<Identifier>();
                dataFields = new ArrayList<Long>();
                txPower = 0;
                for (Pdu pdu : advert.getPdus()) {
                    if (pdu.getType() == 22 && this.mServiceUuid != null || pdu.getType() == 33 && this.mServiceUuid128Bit.length != 0 || pdu.getType() == -1) {
                        pdusToParse.add(pdu);
                        if (!LogManager.isVerboseLoggingEnabled()) continue;
                        LogManager.d(TAG, "Processing pdu type %02X: %s with startIndex: %d, endIndex: %d", pdu.getType(), BeaconParser.bytesToHex(bytesToProcess), pdu.getStartIndex(), pdu.getEndIndex());
                        continue;
                    }
                    if (!LogManager.isVerboseLoggingEnabled()) continue;
                    LogManager.d(TAG, "Ignoring pdu type %02X", pdu.getType());
                }
                if (pdusToParse.size() != 0) break block49;
                if (!LogManager.isVerboseLoggingEnabled()) break block50;
                LogManager.d(TAG, "No PDUs to process in this packet.", new Object[0]);
                break block50;
            }
            boolean parseFailed = false;
            for (Pdu pdu : pdusToParse) {
                int endIndex;
                int i;
                byte[] serviceUuidBytes = null;
                byte[] typeCodeBytes = new byte[]{};
                if (this.mMatchingBeaconTypeCodeEndOffset != null && this.mMatchingBeaconTypeCodeStartOffset >= 0) {
                    typeCodeBytes = BeaconParser.longToByteArray(this.getMatchingBeaconTypeCode(), this.mMatchingBeaconTypeCodeEndOffset - this.mMatchingBeaconTypeCodeStartOffset + 1);
                }
                serviceUuidBytes = this.getServiceUuid128Bit();
                if (this.getServiceUuid() != null) {
                    serviceUuidBytes = BeaconParser.longToByteArray(this.getServiceUuid(), this.mServiceUuidEndOffset - this.mServiceUuidStartOffset + 1, false);
                }
                startByte = pdu.getStartIndex();
                boolean patternFound = false;
                if (serviceUuidBytes.length == 0) {
                    if (this.mMatchingBeaconTypeCodeEndOffset != null && this.byteArraysMatch(bytesToProcess, startByte + this.mMatchingBeaconTypeCodeStartOffset, typeCodeBytes)) {
                        patternFound = true;
                    }
                } else {
                    boolean lengthIsExpected = false;
                    if (pdu.getType() == 33 && serviceUuidBytes.length == 16) {
                        lengthIsExpected = true;
                    }
                    if (pdu.getType() == 22 && serviceUuidBytes.length == 2) {
                        lengthIsExpected = true;
                    }
                    if (lengthIsExpected && this.byteArraysMatch(bytesToProcess, startByte + this.mServiceUuidStartOffset, serviceUuidBytes)) {
                        if (this.mMatchingBeaconTypeCodeEndOffset != null) {
                            if (this.byteArraysMatch(bytesToProcess, startByte + this.mMatchingBeaconTypeCodeStartOffset, typeCodeBytes)) {
                                patternFound = true;
                            }
                        } else if (pdu.getType() == 22 || pdu.getType() == 33) {
                            patternFound = true;
                        }
                    }
                }
                if (!patternFound) {
                    if (this.getServiceUuid() != null || this.getServiceUuid128Bit().length != 0) {
                        if (LogManager.isVerboseLoggingEnabled()) {
                            int offset = 0;
                            if (this.mMatchingBeaconTypeCodeStartOffset != null) {
                                offset = this.mMatchingBeaconTypeCodeStartOffset;
                            }
                            LogManager.d(TAG, "This is not a matching Beacon advertisement. Was expecting %s at offset %d and %s at offset %d.  The bytes I see are: %s", this.byteArrayToString(serviceUuidBytes), startByte + this.mServiceUuidStartOffset, this.byteArrayToString(typeCodeBytes), startByte + offset, BeaconParser.bytesToHex(bytesToProcess));
                        }
                    } else if (LogManager.isVerboseLoggingEnabled()) {
                        LogManager.d(TAG, "This is not a matching Beacon advertisement. (Was expecting %s.  The bytes I see are: %s", this.byteArrayToString(typeCodeBytes), BeaconParser.bytesToHex(bytesToProcess));
                    }
                } else if (LogManager.isVerboseLoggingEnabled()) {
                    LogManager.d(TAG, "This is a recognized beacon advertisement -- %s seen", this.byteArrayToString(typeCodeBytes));
                    LogManager.d(TAG, "Bytes are: %s", BeaconParser.bytesToHex(bytesToProcess));
                }
                if (!patternFound) continue;
                if (bytesToProcess.length <= startByte + this.mLayoutSize && this.mAllowPduOverflow.booleanValue()) {
                    if (LogManager.isVerboseLoggingEnabled()) {
                        LogManager.d(TAG, "Expanding buffer because it is too short to parse: " + bytesToProcess.length + ", needed: " + (startByte + this.mLayoutSize), new Object[0]);
                    }
                    bytesToProcess = this.ensureMaxSize(bytesToProcess, startByte + this.mLayoutSize);
                }
                for (i = 0; i < this.mIdentifierEndOffsets.size(); ++i) {
                    endIndex = this.mIdentifierEndOffsets.get(i) + startByte;
                    if (endIndex > pdu.getEndIndex() && this.mIdentifierVariableLengthFlags.get(i).booleanValue()) {
                        if (LogManager.isVerboseLoggingEnabled()) {
                            LogManager.d(TAG, "Need to truncate identifier by " + (endIndex - pdu.getEndIndex()), new Object[0]);
                        }
                        int start = this.mIdentifierStartOffsets.get(i) + startByte;
                        int end = pdu.getEndIndex() + 1;
                        if (end <= start) {
                            LogManager.d(TAG, "PDU is too short for identifer.  Packet is malformed", new Object[0]);
                            return null;
                        }
                        Identifier identifier = Identifier.fromBytes(bytesToProcess, start, end, this.mIdentifierLittleEndianFlags.get(i));
                        identifiers.add(identifier);
                        continue;
                    }
                    if (endIndex > pdu.getEndIndex() && !this.mAllowPduOverflow.booleanValue()) {
                        parseFailed = true;
                        if (!LogManager.isVerboseLoggingEnabled()) continue;
                        LogManager.d(TAG, "Cannot parse identifier " + i + " because PDU is too short.  endIndex: " + endIndex + " PDU endIndex: " + pdu.getEndIndex(), new Object[0]);
                        continue;
                    }
                    Identifier identifier = Identifier.fromBytes(bytesToProcess, this.mIdentifierStartOffsets.get(i) + startByte, endIndex + 1, this.mIdentifierLittleEndianFlags.get(i));
                    identifiers.add(identifier);
                }
                for (i = 0; i < this.mDataEndOffsets.size(); ++i) {
                    endIndex = this.mDataEndOffsets.get(i) + startByte;
                    if (endIndex > pdu.getEndIndex() && !this.mAllowPduOverflow.booleanValue()) {
                        if (LogManager.isVerboseLoggingEnabled()) {
                            LogManager.d(TAG, "Cannot parse data field " + i + " because PDU is too short.  endIndex: " + endIndex + " PDU endIndex: " + pdu.getEndIndex() + ".  Setting value to 0", new Object[0]);
                        }
                        dataFields.add(new Long(0L));
                        continue;
                    }
                    String dataString = this.byteArrayToFormattedString(bytesToProcess, this.mDataStartOffsets.get(i) + startByte, endIndex, this.mDataLittleEndianFlags.get(i));
                    dataFields.add(Long.decode(dataString));
                }
                if (this.mPowerStartOffset != null) {
                    int endIndex2 = this.mPowerEndOffset + startByte;
                    try {
                        if (endIndex2 > pdu.getEndIndex() && !this.mAllowPduOverflow.booleanValue()) {
                            parseFailed = true;
                            if (LogManager.isVerboseLoggingEnabled()) {
                                LogManager.d(TAG, "Cannot parse power field because PDU is too short.  endIndex: " + endIndex2 + " PDU endIndex: " + pdu.getEndIndex(), new Object[0]);
                            }
                        } else {
                            String powerString = this.byteArrayToFormattedString(bytesToProcess, this.mPowerStartOffset + startByte, this.mPowerEndOffset + startByte, false);
                            txPower = Integer.parseInt(powerString) + this.mDBmCorrection;
                            if (txPower > 127) {
                                txPower -= 256;
                            }
                        }
                    }
                    catch (NumberFormatException numberFormatException) {
                    }
                    catch (NullPointerException nullPointerException) {}
                } else if (this.mDBmCorrection != null) {
                    txPower = this.mDBmCorrection;
                }
                if (parseFailed) continue;
                parseSucceeded = true;
                break;
            }
        }
        if (parseSucceeded) {
            int beaconTypeCode = -1;
            if (this.mMatchingBeaconTypeCodeEndOffset != null) {
                String string = this.byteArrayToFormattedString(bytesToProcess, this.mMatchingBeaconTypeCodeStartOffset + startByte, this.mMatchingBeaconTypeCodeEndOffset + startByte, false);
                beaconTypeCode = Integer.parseInt(string);
            }
            boolean bl = false;
            String string = this.byteArrayToFormattedString(bytesToProcess, startByte, startByte + 1, true);
            int n = Integer.parseInt(string);
            String macAddress = null;
            String name = null;
            if (device != null) {
                macAddress = device.getAddress();
                try {
                    name = device.getName();
                }
                catch (SecurityException e) {
                    Log.d((String)TAG, (String)"Cannot read device name without Manifest.permission.BLUETOOTH_CONNECT");
                }
            }
            beacon.mIdentifiers = identifiers;
            beacon.mDataFields = dataFields;
            beacon.mRssi = rssi;
            beacon.mBeaconTypeCode = beaconTypeCode;
            beacon.mServiceUuid = this.mServiceUuid != null ? (int)this.mServiceUuid.longValue() : -1;
            beacon.mBluetoothAddress = macAddress;
            beacon.mBluetoothName = name;
            beacon.mManufacturer = n;
            beacon.mParserIdentifier = this.mIdentifier;
            beacon.mMultiFrameBeacon = this.extraParsers.size() > 0 || this.mExtraFrame != false;
            beacon.mFirstCycleDetectionTimestamp = timestampMs;
            beacon.mLastCycleDetectionTimestamp = timestampMs;
            beacon.mTxPower = txPower;
            return beacon;
        }
        return null;
    }

    @TargetApi(value=9)
    public byte[] getBeaconAdvertisementData(Beacon beacon) {
        int index;
        int identifierNum;
        int identifierNum2;
        if (beacon.getIdentifiers().size() != this.getIdentifierCount()) {
            throw new IllegalArgumentException("Beacon has " + beacon.getIdentifiers().size() + " identifiers but format requires " + this.getIdentifierCount());
        }
        int lastIndex = -1;
        if (this.mMatchingBeaconTypeCodeEndOffset != null && this.mMatchingBeaconTypeCodeEndOffset > lastIndex) {
            lastIndex = this.mMatchingBeaconTypeCodeEndOffset;
        }
        if (this.mPowerEndOffset != null && this.mPowerEndOffset > lastIndex) {
            lastIndex = this.mPowerEndOffset;
        }
        for (identifierNum2 = 0; identifierNum2 < this.mIdentifierEndOffsets.size(); ++identifierNum2) {
            if (this.mIdentifierEndOffsets.get(identifierNum2) == null || this.mIdentifierEndOffsets.get(identifierNum2) <= lastIndex) continue;
            lastIndex = this.mIdentifierEndOffsets.get(identifierNum2);
        }
        for (identifierNum2 = 0; identifierNum2 < this.mDataEndOffsets.size(); ++identifierNum2) {
            if (this.mDataEndOffsets.get(identifierNum2) == null || this.mDataEndOffsets.get(identifierNum2) <= lastIndex) continue;
            lastIndex = this.mDataEndOffsets.get(identifierNum2);
        }
        int adjustedIdentifiersLength = 0;
        for (identifierNum = 0; identifierNum < this.mIdentifierStartOffsets.size(); ++identifierNum) {
            if (!this.mIdentifierVariableLengthFlags.get(identifierNum).booleanValue()) continue;
            int declaredIdentifierLength = this.mIdentifierEndOffsets.get(identifierNum) - this.mIdentifierStartOffsets.get(identifierNum) + 1;
            int actualIdentifierLength = beacon.getIdentifier(identifierNum).getByteCount();
            adjustedIdentifiersLength += actualIdentifierLength;
            adjustedIdentifiersLength -= declaredIdentifierLength;
        }
        byte[] advertisingBytes = new byte[(lastIndex += adjustedIdentifiersLength) + 1 - 2];
        if (this.mMatchingBeaconTypeCodeEndOffset != null) {
            long beaconTypeCode = this.getMatchingBeaconTypeCode();
            for (index = this.mMatchingBeaconTypeCodeStartOffset.intValue(); index <= this.mMatchingBeaconTypeCodeEndOffset; ++index) {
                byte value;
                advertisingBytes[index - 2] = value = (byte)(this.getMatchingBeaconTypeCode() >> 8 * (this.mMatchingBeaconTypeCodeEndOffset - index) & 0xFFL);
            }
        }
        for (identifierNum = 0; identifierNum < this.mIdentifierStartOffsets.size(); ++identifierNum) {
            byte[] identifierBytes = beacon.getIdentifier(identifierNum).toByteArrayOfSpecifiedEndianness(this.mIdentifierLittleEndianFlags.get(identifierNum) == false);
            if (identifierBytes.length < this.getIdentifierByteCount(identifierNum)) {
                if (!this.mIdentifierVariableLengthFlags.get(identifierNum).booleanValue()) {
                    if (this.mIdentifierLittleEndianFlags.get(identifierNum).booleanValue()) {
                        identifierBytes = Arrays.copyOf(identifierBytes, this.getIdentifierByteCount(identifierNum));
                    } else {
                        byte[] newIdentifierBytes = new byte[this.getIdentifierByteCount(identifierNum)];
                        System.arraycopy(identifierBytes, 0, newIdentifierBytes, this.getIdentifierByteCount(identifierNum) - identifierBytes.length, identifierBytes.length);
                        identifierBytes = newIdentifierBytes;
                    }
                }
                LogManager.d(TAG, "Expanded identifier because it is too short.  It is now: " + this.byteArrayToString(identifierBytes), new Object[0]);
            } else if (identifierBytes.length > this.getIdentifierByteCount(identifierNum)) {
                identifierBytes = this.mIdentifierLittleEndianFlags.get(identifierNum) != false ? Arrays.copyOfRange(identifierBytes, this.getIdentifierByteCount(identifierNum) - identifierBytes.length, this.getIdentifierByteCount(identifierNum)) : Arrays.copyOf(identifierBytes, this.getIdentifierByteCount(identifierNum));
                LogManager.d(TAG, "Truncated identifier because it is too long.  It is now: " + this.byteArrayToString(identifierBytes), new Object[0]);
            } else {
                LogManager.d(TAG, "Identifier size is just right: " + this.byteArrayToString(identifierBytes), new Object[0]);
            }
            for (index = this.mIdentifierStartOffsets.get(identifierNum).intValue(); index <= this.mIdentifierStartOffsets.get(identifierNum) + identifierBytes.length - 1; ++index) {
                advertisingBytes[index - 2] = identifierBytes[index - this.mIdentifierStartOffsets.get(identifierNum)];
            }
        }
        if (this.mPowerStartOffset != null && this.mPowerEndOffset != null && this.mPowerStartOffset >= 2) {
            for (int index2 = this.mPowerStartOffset.intValue(); index2 <= this.mPowerEndOffset; ++index2) {
                advertisingBytes[index2 - 2] = (byte)(beacon.getTxPower() >> 8 * (index2 - this.mPowerStartOffset) & 0xFF);
            }
        }
        for (int dataFieldNum = 0; dataFieldNum < this.mDataStartOffsets.size(); ++dataFieldNum) {
            long dataField = beacon.getDataFields().get(dataFieldNum);
            int dataFieldLength = this.mDataEndOffsets.get(dataFieldNum) - this.mDataStartOffsets.get(dataFieldNum);
            for (int index3 = 0; index3 <= dataFieldLength; ++index3) {
                int endianCorrectedIndex = index3;
                if (!this.mDataLittleEndianFlags.get(dataFieldNum).booleanValue()) {
                    endianCorrectedIndex = dataFieldLength - index3;
                }
                advertisingBytes[this.mDataStartOffsets.get((int)dataFieldNum).intValue() - 2 + endianCorrectedIndex] = (byte)(dataField >> 8 * index3 & 0xFFL);
            }
        }
        return advertisingBytes;
    }

    public BeaconParser setMatchingBeaconTypeCode(Long typeCode) {
        this.mMatchingBeaconTypeCode = typeCode;
        return this;
    }

    public int getIdentifierByteCount(int identifierNum) {
        return this.mIdentifierEndOffsets.get(identifierNum) - this.mIdentifierStartOffsets.get(identifierNum) + 1;
    }

    public int getIdentifierCount() {
        return this.mIdentifierStartOffsets.size();
    }

    public int getDataFieldCount() {
        return this.mDataStartOffsets.size();
    }

    public String getLayout() {
        return this.mBeaconLayout;
    }

    public int getPowerCorrection() {
        return this.mDBmCorrection;
    }

    protected static String bytesToHex(byte[] bytes) {
        char[] hexChars = new char[bytes.length * 2];
        for (int j = 0; j < bytes.length; ++j) {
            int v = bytes[j] & 0xFF;
            hexChars[j * 2] = HEX_ARRAY[v >>> 4];
            hexChars[j * 2 + 1] = HEX_ARRAY[v & 0xF];
        }
        return new String(hexChars);
    }

    public static byte[] longToByteArray(long longValue, int length) {
        return BeaconParser.longToByteArray(longValue, length, true);
    }

    public static byte[] longToByteArray(long longValue, int length, boolean bigEndian) {
        byte[] array = new byte[length];
        for (int i = 0; i < length; ++i) {
            int adjustedI = bigEndian ? i : length - i - 1;
            long mask = 255L << (length - adjustedI - 1) * 8;
            long shift = (length - adjustedI - 1) * 8;
            long value = (longValue & mask) >> (int)shift;
            array[i] = (byte)value;
        }
        return array;
    }

    private int calculateLayoutSize() {
        int lastEndOffset = 0;
        if (this.mIdentifierEndOffsets != null) {
            for (int endOffset : this.mIdentifierEndOffsets) {
                if (endOffset <= lastEndOffset) continue;
                lastEndOffset = endOffset;
            }
        }
        if (this.mDataEndOffsets != null) {
            for (int endOffset : this.mDataEndOffsets) {
                if (endOffset <= lastEndOffset) continue;
                lastEndOffset = endOffset;
            }
        }
        if (this.mPowerEndOffset != null && this.mPowerEndOffset > lastEndOffset) {
            lastEndOffset = this.mPowerEndOffset;
        }
        if (this.mServiceUuidEndOffset != null && this.mServiceUuidEndOffset > lastEndOffset) {
            lastEndOffset = this.mServiceUuidEndOffset;
        }
        return lastEndOffset + 1;
    }

    private boolean byteArraysMatch(byte[] source, int offset, byte[] expected) {
        int length = expected.length;
        if (source.length - offset < length) {
            return false;
        }
        for (int i = 0; i < length; ++i) {
            if (source[offset + i] == expected[i]) continue;
            return false;
        }
        return true;
    }

    private String byteArrayToString(byte[] bytes) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < bytes.length; ++i) {
            sb.append(String.format("%02x", bytes[i]));
            sb.append(" ");
        }
        return sb.toString().trim();
    }

    private String byteArrayToFormattedString(byte[] byteBuffer, int startIndex, int endIndex, boolean littleEndian) {
        int length;
        int i;
        byte[] bytes = new byte[endIndex - startIndex + 1];
        if (littleEndian) {
            for (i = 0; i <= endIndex - startIndex; ++i) {
                bytes[i] = byteBuffer[startIndex + bytes.length - 1 - i];
            }
        } else {
            for (i = 0; i <= endIndex - startIndex; ++i) {
                bytes[i] = byteBuffer[startIndex + i];
            }
        }
        if ((length = endIndex - startIndex + 1) < 5) {
            long number = 0L;
            for (int i2 = 0; i2 < bytes.length; ++i2) {
                long byteValue = bytes[bytes.length - i2 - 1] & 0xFF;
                long positionValue = (long)Math.pow(256.0, (double)i2 * 1.0);
                long calculatedValue = byteValue * positionValue;
                number += calculatedValue;
            }
            return Long.toString(number);
        }
        String hexString = BeaconParser.bytesToHex(bytes);
        if (bytes.length == 16) {
            StringBuilder sb = new StringBuilder();
            sb.append(hexString.substring(0, 8));
            sb.append("-");
            sb.append(hexString.substring(8, 12));
            sb.append("-");
            sb.append(hexString.substring(12, 16));
            sb.append("-");
            sb.append(hexString.substring(16, 20));
            sb.append("-");
            sb.append(hexString.substring(20, 32));
            return sb.toString();
        }
        return "0x" + hexString;
    }

    @TargetApi(value=9)
    private byte[] ensureMaxSize(byte[] array, int requiredLength) {
        if (array.length >= requiredLength) {
            return array;
        }
        return Arrays.copyOf(array, requiredLength);
    }

    public int hashCode() {
        return Arrays.hashCode(new Object[]{this.mMatchingBeaconTypeCode, this.mIdentifierStartOffsets, this.mIdentifierEndOffsets, this.mIdentifierLittleEndianFlags, this.mDataStartOffsets, this.mDataEndOffsets, this.mDataLittleEndianFlags, this.mIdentifierVariableLengthFlags, this.mMatchingBeaconTypeCodeStartOffset, this.mMatchingBeaconTypeCodeEndOffset, this.mServiceUuidStartOffset, this.mServiceUuidEndOffset, this.mServiceUuid, this.mServiceUuid128Bit, this.mExtraFrame, this.mPowerStartOffset, this.mPowerEndOffset, this.mDBmCorrection, this.mLayoutSize, this.mAllowPduOverflow, this.mIdentifier, this.mHardwareAssistManufacturers, this.extraParsers});
    }

    public boolean equals(Object o) {
        BeaconParser that = null;
        try {
            that = (BeaconParser)o;
            if (that.mBeaconLayout != null && that.mBeaconLayout.equals(this.mBeaconLayout) && that.mIdentifier != null && that.mIdentifier.equals(this.mIdentifier)) {
                return true;
            }
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        return false;
    }

    public static class BeaconLayoutException
    extends RuntimeException {
        public BeaconLayoutException(String s) {
            super(s);
        }
    }
}

