/*
 * Decompiled with CFR 0.152.
 */
package org.altbeacon.beacon;

import android.os.Parcel;
import android.os.Parcelable;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.altbeacon.beacon.Beacon;
import org.altbeacon.beacon.Identifier;

public class Region
implements Parcelable,
Serializable {
    private static final String TAG = "Region";
    private static final Pattern MAC_PATTERN = Pattern.compile("^[0-9A-Fa-f]{2}\\:[0-9A-Fa-f]{2}\\:[0-9A-Fa-f]{2}\\:[0-9A-Fa-f]{2}\\:[0-9A-Fa-f]{2}\\:[0-9A-Fa-f]{2}$");
    public static final Parcelable.Creator<Region> CREATOR = new Parcelable.Creator<Region>(){

        public Region createFromParcel(Parcel in) {
            return new Region(in);
        }

        public Region[] newArray(int size) {
            return new Region[size];
        }
    };
    protected final List<Identifier> mIdentifiers;
    protected final String mBluetoothAddress;
    protected final String mUniqueId;

    public Region(String uniqueId, Identifier id1, Identifier id2, Identifier id3) {
        this.mIdentifiers = new ArrayList<Identifier>(3);
        this.mIdentifiers.add(id1);
        this.mIdentifiers.add(id2);
        this.mIdentifiers.add(id3);
        this.mUniqueId = uniqueId;
        this.mBluetoothAddress = null;
        if (uniqueId == null) {
            throw new NullPointerException("uniqueId may not be null");
        }
    }

    public Region(String uniqueId, List<Identifier> identifiers) {
        this(uniqueId, identifiers, null);
    }

    public Region(String uniqueId, List<Identifier> identifiers, String bluetoothAddress) {
        this.validateMac(bluetoothAddress);
        this.mIdentifiers = new ArrayList<Identifier>(identifiers);
        this.mUniqueId = uniqueId;
        this.mBluetoothAddress = bluetoothAddress;
        if (uniqueId == null) {
            throw new NullPointerException("uniqueId may not be null");
        }
    }

    public Region(String uniqueId, String bluetoothAddress) {
        this.validateMac(bluetoothAddress);
        this.mBluetoothAddress = bluetoothAddress;
        this.mUniqueId = uniqueId;
        this.mIdentifiers = new ArrayList<Identifier>();
        if (uniqueId == null) {
            throw new NullPointerException("uniqueId may not be null");
        }
    }

    public Identifier getId1() {
        return this.getIdentifier(0);
    }

    public Identifier getId2() {
        return this.getIdentifier(1);
    }

    public Identifier getId3() {
        return this.getIdentifier(2);
    }

    public Identifier getIdentifier(int i) {
        return this.mIdentifiers.size() > i ? this.mIdentifiers.get(i) : null;
    }

    public List<Identifier> getIdentifiers() {
        return new ArrayList<Identifier>(this.mIdentifiers);
    }

    public String getUniqueId() {
        return this.mUniqueId;
    }

    public String getBluetoothAddress() {
        return this.mBluetoothAddress;
    }

    public boolean matchesBeacon(Beacon beacon) {
        int i = this.mIdentifiers.size();
        while (--i >= 0) {
            Identifier identifier = this.mIdentifiers.get(i);
            Identifier beaconIdentifier = null;
            if (i < beacon.mIdentifiers.size()) {
                beaconIdentifier = beacon.getIdentifier(i);
            }
            if ((beaconIdentifier != null || identifier == null) && (beaconIdentifier == null || identifier == null || identifier.equals(beaconIdentifier))) continue;
            return false;
        }
        return this.mBluetoothAddress == null || this.mBluetoothAddress.equalsIgnoreCase(beacon.mBluetoothAddress);
    }

    public int hashCode() {
        return this.mUniqueId.hashCode();
    }

    public boolean equals(Object other) {
        if (other instanceof Region) {
            return ((Region)other).mUniqueId.equals(this.mUniqueId);
        }
        return false;
    }

    public boolean hasSameIdentifiers(Region region) {
        if (region.mIdentifiers.size() == this.mIdentifiers.size()) {
            for (int i = 0; i < region.mIdentifiers.size(); ++i) {
                if (region.getIdentifier(i) == null && this.getIdentifier(i) != null) {
                    return false;
                }
                if (region.getIdentifier(i) != null && this.getIdentifier(i) == null) {
                    return false;
                }
                if (region.getIdentifier(i) == null && this.getIdentifier(i) == null || region.getIdentifier(i).equals(this.getIdentifier(i))) continue;
                return false;
            }
        } else {
            return false;
        }
        return true;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        int i = 1;
        for (Identifier identifier : this.mIdentifiers) {
            if (i > 1) {
                sb.append(" ");
            }
            sb.append("id");
            sb.append(i);
            sb.append(": ");
            sb.append(identifier == null ? "null" : identifier.toString());
            ++i;
        }
        return sb.toString();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel out, int flags) {
        out.writeString(this.mUniqueId);
        out.writeString(this.mBluetoothAddress);
        out.writeInt(this.mIdentifiers.size());
        for (Identifier identifier : this.mIdentifiers) {
            if (identifier != null) {
                out.writeString(identifier.toString());
                continue;
            }
            out.writeString(null);
        }
    }

    protected Region(Parcel in) {
        this.mUniqueId = in.readString();
        this.mBluetoothAddress = in.readString();
        int size = in.readInt();
        this.mIdentifiers = new ArrayList<Identifier>(size);
        for (int i = 0; i < size; ++i) {
            String identifierString = in.readString();
            if (identifierString == null) {
                this.mIdentifiers.add(null);
                continue;
            }
            Identifier identifier = Identifier.parse(identifierString);
            this.mIdentifiers.add(identifier);
        }
    }

    private void validateMac(String mac) throws IllegalArgumentException {
        if (mac != null && !MAC_PATTERN.matcher(mac).matches()) {
            throw new IllegalArgumentException("Invalid mac address: '" + mac + "' Must be 6 hex bytes separated by colons.");
        }
    }

    @Deprecated
    public Region clone() {
        return new Region(this.mUniqueId, this.mIdentifiers, this.mBluetoothAddress);
    }
}

