/*
 * Decompiled with CFR 0.152.
 */
package org.altbeacon.beacon.service.scanner;

import android.annotation.TargetApi;
import android.bluetooth.le.ScanFilter;
import android.os.ParcelUuid;
import java.util.ArrayList;
import java.util.List;
import org.altbeacon.beacon.BeaconParser;
import org.altbeacon.beacon.logging.LogManager;

@TargetApi(value=21)
public class ScanFilterUtils {
    public static final String TAG = "ScanFilterUtils";

    public List<ScanFilter> createWildcardScanFilters() {
        ArrayList<ScanFilter> scanFilters = new ArrayList<ScanFilter>();
        ScanFilter.Builder builder = new ScanFilter.Builder();
        scanFilters.add(builder.build());
        return scanFilters;
    }

    public List<ScanFilterData> createScanFilterDataForBeaconParser(BeaconParser beaconParser) {
        ArrayList<ScanFilterData> scanFilters = new ArrayList<ScanFilterData>();
        for (int manufacturer : beaconParser.getHardwareAssistManufacturers()) {
            Long serviceUuid = beaconParser.getServiceUuid();
            long typeCode = beaconParser.getMatchingBeaconTypeCode();
            int startOffset = beaconParser.getMatchingBeaconTypeCodeStartOffset();
            int endOffset = beaconParser.getMatchingBeaconTypeCodeEndOffset();
            int length = endOffset + 1 - 2;
            byte[] filter = new byte[]{};
            byte[] mask = new byte[]{};
            if (length > 0) {
                filter = new byte[length];
                mask = new byte[length];
                byte[] typeCodeBytes = BeaconParser.longToByteArray(typeCode, endOffset - startOffset + 1);
                for (int layoutIndex = 2; layoutIndex <= endOffset; ++layoutIndex) {
                    int filterIndex = layoutIndex - 2;
                    if (layoutIndex < startOffset) {
                        filter[filterIndex] = 0;
                        mask[filterIndex] = 0;
                        continue;
                    }
                    filter[filterIndex] = typeCodeBytes[layoutIndex - startOffset];
                    mask[filterIndex] = -1;
                }
            }
            ScanFilterData sfd = new ScanFilterData();
            sfd.manufacturer = manufacturer;
            sfd.filter = filter;
            sfd.mask = mask;
            sfd.serviceUuid = serviceUuid;
            scanFilters.add(sfd);
        }
        return scanFilters;
    }

    public List<ScanFilter> createScanFiltersForBeaconParsers(List<BeaconParser> beaconParsers) {
        ArrayList<ScanFilter> scanFilters = new ArrayList<ScanFilter>();
        for (BeaconParser beaconParser : beaconParsers) {
            List<ScanFilterData> sfds = this.createScanFilterDataForBeaconParser(beaconParser);
            for (ScanFilterData sfd : sfds) {
                ScanFilter.Builder builder = new ScanFilter.Builder();
                if (sfd.serviceUuid != null) {
                    String serviceUuidString = String.format("0000%04X-0000-1000-8000-00805f9b34fb", sfd.serviceUuid);
                    String serviceUuidMaskString = "FFFFFFFF-FFFF-FFFF-FFFF-FFFFFFFFFFFF";
                    ParcelUuid parcelUuid = ParcelUuid.fromString((String)serviceUuidString);
                    ParcelUuid parcelUuidMask = ParcelUuid.fromString((String)serviceUuidMaskString);
                    if (LogManager.isVerboseLoggingEnabled()) {
                        LogManager.d(TAG, "making scan filter for service: " + serviceUuidString + " " + parcelUuid, new Object[0]);
                        LogManager.d(TAG, "making scan filter with service mask: " + serviceUuidMaskString + " " + parcelUuidMask, new Object[0]);
                    }
                    builder.setServiceUuid(parcelUuid, parcelUuidMask);
                } else {
                    builder.setServiceUuid(null);
                    builder.setManufacturerData(sfd.manufacturer, sfd.filter, sfd.mask);
                }
                ScanFilter scanFilter = builder.build();
                if (LogManager.isVerboseLoggingEnabled()) {
                    LogManager.d(TAG, "Set up a scan filter: " + scanFilter, new Object[0]);
                }
                scanFilters.add(scanFilter);
            }
        }
        return scanFilters;
    }

    class ScanFilterData {
        public Long serviceUuid = null;
        public int manufacturer;
        public byte[] filter;
        public byte[] mask;

        ScanFilterData() {
        }
    }
}

