/*
 * Decompiled with CFR 0.152.
 */
package org.altbeacon.bluetooth;

import android.app.job.JobParameters;
import android.app.job.JobService;
import android.content.ComponentName;
import android.content.Context;
import android.content.pm.PackageManager;
import android.content.pm.ServiceInfo;
import android.os.Handler;
import android.os.HandlerThread;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import org.altbeacon.beacon.logging.LogManager;
import org.altbeacon.bluetooth.BluetoothMedic;

@RequiresApi(value=21)
public class BluetoothTestJob
extends JobService {
    private static final String TAG = BluetoothTestJob.class.getSimpleName();
    @Nullable
    private Handler mHandler = null;
    @Nullable
    private HandlerThread mHandlerThread = null;
    private static int sOverrideJobId = -1;

    public static void setOverrideJobId(int id) {
        sOverrideJobId = id;
    }

    public static int getJobId(Context context) {
        if (sOverrideJobId >= 0) {
            LogManager.i(TAG, "Using BluetoothTestJob JobId from static override: " + sOverrideJobId, new Object[0]);
            return sOverrideJobId;
        }
        ServiceInfo info = null;
        try {
            info = context.getPackageManager().getServiceInfo(new ComponentName(context, BluetoothTestJob.class), 128);
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            // empty catch block
        }
        if (info != null && info.metaData != null && info.metaData.get("jobId") != null) {
            int jobId = info.metaData.getInt("jobId");
            LogManager.i(TAG, "Using BluetoothTestJob JobId from manifest: " + jobId, new Object[0]);
            return jobId;
        }
        throw new RuntimeException("Cannot get job id from manifest.  Make sure that the BluetoothTestJob is configured in the manifest.");
    }

    public boolean onStartJob(final JobParameters params) {
        if (this.mHandlerThread == null) {
            this.mHandlerThread = new HandlerThread("BluetoothTestThread");
            this.mHandlerThread.start();
        }
        if (this.mHandler == null) {
            this.mHandler = new Handler(this.mHandlerThread.getLooper());
        }
        this.mHandler.post(new Runnable(){

            @Override
            public void run() {
                boolean found = false;
                LogManager.i(TAG, "Bluetooth Test Job running", new Object[0]);
                int testType = params.getExtras().getInt("test_type");
                if (testType == 0) {
                    found = true;
                    LogManager.d(TAG, "No test specified.  Done with job.", new Object[0]);
                }
                if ((testType & 1) == 1) {
                    LogManager.d(TAG, "Scan test specified.", new Object[0]);
                    found = true;
                    if (!BluetoothMedic.getInstance().runScanTest((Context)BluetoothTestJob.this)) {
                        LogManager.d(TAG, "scan test failed", new Object[0]);
                    }
                }
                if ((testType & 2) == 2) {
                    if (found) {
                        try {
                            Thread.sleep(10000L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                    LogManager.d(TAG, "Transmit test specified.", new Object[0]);
                    found = true;
                    if (!BluetoothMedic.getInstance().runTransmitterTest((Context)BluetoothTestJob.this)) {
                        LogManager.d(TAG, "transmit test failed", new Object[0]);
                    }
                }
                if (!found) {
                    LogManager.w(TAG, "Unknown test type:" + testType + "  Exiting.", new Object[0]);
                }
                BluetoothTestJob.this.jobFinished(params, false);
            }
        });
        return true;
    }

    public boolean onStopJob(JobParameters params) {
        return true;
    }
}

