/*
 * Decompiled with CFR 0.152.
 */
package org.altbeacon.beacon.utils;

import android.app.ActivityManager;
import android.content.Context;
import android.os.Process;
import android.support.annotation.NonNull;
import java.util.List;

public class ProcessUtils {
    Context mContext;

    public ProcessUtils(@NonNull Context context) {
        this.mContext = context;
    }

    public String getProcessName() {
        ActivityManager manager = (ActivityManager)this.mContext.getSystemService("activity");
        List processes = manager.getRunningAppProcesses();
        if (processes != null) {
            for (ActivityManager.RunningAppProcessInfo processInfo : processes) {
                if (processInfo.pid != this.getPid()) continue;
                return processInfo.processName;
            }
        }
        return null;
    }

    public String getPackageName() {
        return this.mContext.getApplicationContext().getPackageName();
    }

    public int getPid() {
        return Process.myPid();
    }

    public boolean isMainProcess() {
        return this.getPackageName().equals(this.getProcessName());
    }
}

