/*
 * Decompiled with CFR 0.152.
 */
package org.altbeacon.beacon.service.scanner;

import android.annotation.TargetApi;
import android.bluetooth.BluetoothAdapter;
import android.bluetooth.le.BluetoothLeScanner;
import android.bluetooth.le.ScanCallback;
import android.bluetooth.le.ScanFilter;
import android.bluetooth.le.ScanResult;
import android.bluetooth.le.ScanSettings;
import android.content.Context;
import android.os.ParcelUuid;
import android.os.SystemClock;
import android.support.annotation.MainThread;
import android.support.annotation.WorkerThread;
import java.util.ArrayList;
import java.util.List;
import org.altbeacon.beacon.BeaconManager;
import org.altbeacon.beacon.logging.LogManager;
import org.altbeacon.beacon.service.DetectionTracker;
import org.altbeacon.beacon.service.scanner.CycledLeScanCallback;
import org.altbeacon.beacon.service.scanner.CycledLeScanner;
import org.altbeacon.beacon.service.scanner.ScanFilterUtils;
import org.altbeacon.bluetooth.BluetoothCrashResolver;

@TargetApi(value=21)
public class CycledLeScannerForLollipop
extends CycledLeScanner {
    private static final String TAG = "CycledLeScannerForLollipop";
    private static final long BACKGROUND_L_SCAN_DETECTION_PERIOD_MILLIS = 10000L;
    private BluetoothLeScanner mScanner;
    private ScanCallback leScanCallback;
    private long mBackgroundLScanStartTime = 0L;
    private long mBackgroundLScanFirstDetectionTime = 0L;
    private boolean mMainScanCycleActive = false;
    private final BeaconManager mBeaconManager = BeaconManager.getInstanceForApplication(this.mContext);

    public CycledLeScannerForLollipop(Context context, long scanPeriod, long betweenScanPeriod, boolean backgroundFlag, CycledLeScanCallback cycledLeScanCallback, BluetoothCrashResolver crashResolver) {
        super(context, scanPeriod, betweenScanPeriod, backgroundFlag, cycledLeScanCallback, crashResolver);
    }

    @Override
    protected void stopScan() {
        this.postStopLeScan();
    }

    @Override
    protected boolean deferScanIfNeeded() {
        long millisecondsUntilStart = this.mNextScanCycleStartTime - SystemClock.elapsedRealtime();
        boolean deferScan = millisecondsUntilStart > 0L;
        boolean scanActiveBefore = this.mMainScanCycleActive;
        boolean bl = this.mMainScanCycleActive = !deferScan;
        if (deferScan) {
            long secsSinceLastDetection = SystemClock.elapsedRealtime() - DetectionTracker.getInstance().getLastDetectionTime();
            if (scanActiveBefore) {
                if (secsSinceLastDetection > 10000L) {
                    this.mBackgroundLScanStartTime = SystemClock.elapsedRealtime();
                    this.mBackgroundLScanFirstDetectionTime = 0L;
                    LogManager.d(TAG, "This is Android L. Preparing to do a filtered scan for the background.", new Object[0]);
                    if (this.mBetweenScanPeriod > 6000L) {
                        this.startScan();
                    } else {
                        LogManager.d(TAG, "Suppressing scan between cycles because the between scan cycle is too short.", new Object[0]);
                    }
                } else {
                    LogManager.d(TAG, "This is Android L, but we last saw a beacon only %s ago, so we will not keep scanning in background.", secsSinceLastDetection);
                }
            }
            if (this.mBackgroundLScanStartTime > 0L && DetectionTracker.getInstance().getLastDetectionTime() > this.mBackgroundLScanStartTime) {
                if (this.mBackgroundLScanFirstDetectionTime == 0L) {
                    this.mBackgroundLScanFirstDetectionTime = DetectionTracker.getInstance().getLastDetectionTime();
                }
                if (SystemClock.elapsedRealtime() - this.mBackgroundLScanFirstDetectionTime >= 10000L) {
                    LogManager.d(TAG, "We've been detecting for a bit.  Stopping Android L background scanning", new Object[0]);
                    this.stopScan();
                    this.mBackgroundLScanStartTime = 0L;
                } else {
                    LogManager.d(TAG, "Delivering Android L background scanning results", new Object[0]);
                    this.mCycledLeScanCallback.onCycleEnd();
                }
            }
            LogManager.d(TAG, "Waiting to start full Bluetooth scan for another %s milliseconds", millisecondsUntilStart);
            if (scanActiveBefore && this.mBackgroundFlag) {
                this.setWakeUpAlarm();
            }
            this.mHandler.postDelayed(new Runnable(){

                @Override
                @MainThread
                public void run() {
                    CycledLeScannerForLollipop.this.scanLeDevice(true);
                }
            }, millisecondsUntilStart > 1000L ? 1000L : millisecondsUntilStart);
        } else if (this.mBackgroundLScanStartTime > 0L) {
            this.stopScan();
            this.mBackgroundLScanStartTime = 0L;
        }
        return deferScan;
    }

    @Override
    protected void startScan() {
        if (!this.isBluetoothOn()) {
            LogManager.d(TAG, "Not starting scan because bluetooth is off", new Object[0]);
            return;
        }
        List<ScanFilter> filters = new ArrayList<ScanFilter>();
        ScanSettings settings = null;
        if (!this.mMainScanCycleActive) {
            LogManager.d(TAG, "starting filtered scan in SCAN_MODE_LOW_POWER", new Object[0]);
            settings = new ScanSettings.Builder().setScanMode(0).build();
            filters = new ScanFilterUtils().createScanFiltersForBeaconParsers(this.mBeaconManager.getBeaconParsers());
        } else {
            LogManager.d(TAG, "starting non-filtered scan in SCAN_MODE_LOW_LATENCY", new Object[0]);
            settings = new ScanSettings.Builder().setScanMode(2).build();
        }
        if (settings != null) {
            this.postStartLeScan(filters, settings);
        }
    }

    @Override
    protected void finishScan() {
        LogManager.d(TAG, "Stopping scan", new Object[0]);
        this.stopScan();
        this.mScanningPaused = true;
    }

    private void postStartLeScan(final List<ScanFilter> filters, final ScanSettings settings) {
        final BluetoothLeScanner scanner = this.getScanner();
        if (scanner == null) {
            return;
        }
        final ScanCallback scanCallback = this.getNewLeScanCallback();
        this.mScanHandler.removeCallbacksAndMessages(null);
        this.mScanHandler.post(new Runnable(){

            @Override
            @WorkerThread
            public void run() {
                try {
                    scanner.startScan(filters, settings, scanCallback);
                }
                catch (IllegalStateException e) {
                    LogManager.w(CycledLeScannerForLollipop.TAG, "Cannot start scan. Bluetooth may be turned off.", new Object[0]);
                }
                catch (NullPointerException npe) {
                    LogManager.e(npe, CycledLeScannerForLollipop.TAG, "Cannot start scan. Unexpected NPE.", new Object[0]);
                }
                catch (SecurityException e) {
                    LogManager.e(CycledLeScannerForLollipop.TAG, "Cannot start scan.  Security Exception", new Object[0]);
                }
            }
        });
    }

    private void postStopLeScan() {
        if (!this.isBluetoothOn()) {
            LogManager.d(TAG, "Not stopping scan because bluetooth is off", new Object[0]);
            return;
        }
        final BluetoothLeScanner scanner = this.getScanner();
        if (scanner == null) {
            return;
        }
        final ScanCallback scanCallback = this.getNewLeScanCallback();
        this.mScanHandler.removeCallbacksAndMessages(null);
        this.mScanHandler.post(new Runnable(){

            @Override
            @WorkerThread
            public void run() {
                try {
                    LogManager.d(CycledLeScannerForLollipop.TAG, "Stopping LE scan on scan handler", new Object[0]);
                    scanner.stopScan(scanCallback);
                }
                catch (IllegalStateException e) {
                    LogManager.w(CycledLeScannerForLollipop.TAG, "Cannot stop scan. Bluetooth may be turned off.", new Object[0]);
                }
                catch (NullPointerException npe) {
                    LogManager.e(npe, CycledLeScannerForLollipop.TAG, "Cannot stop scan. Unexpected NPE.", new Object[0]);
                }
                catch (SecurityException e) {
                    LogManager.e(CycledLeScannerForLollipop.TAG, "Cannot stop scan.  Security Exception", new Object[0]);
                }
            }
        });
    }

    private boolean isBluetoothOn() {
        try {
            BluetoothAdapter bluetoothAdapter = this.getBluetoothAdapter();
            if (bluetoothAdapter != null) {
                return bluetoothAdapter.getState() == 12;
            }
            LogManager.w(TAG, "Cannot get bluetooth adapter", new Object[0]);
        }
        catch (SecurityException e) {
            LogManager.w(TAG, "SecurityException checking if bluetooth is on", new Object[0]);
        }
        return false;
    }

    private BluetoothLeScanner getScanner() {
        try {
            if (this.mScanner == null) {
                LogManager.d(TAG, "Making new Android L scanner", new Object[0]);
                BluetoothAdapter bluetoothAdapter = this.getBluetoothAdapter();
                if (bluetoothAdapter != null) {
                    this.mScanner = this.getBluetoothAdapter().getBluetoothLeScanner();
                }
                if (this.mScanner == null) {
                    LogManager.w(TAG, "Failed to make new Android L scanner", new Object[0]);
                }
            }
        }
        catch (SecurityException e) {
            LogManager.w(TAG, "SecurityException making new Android L scanner", new Object[0]);
        }
        return this.mScanner;
    }

    private ScanCallback getNewLeScanCallback() {
        if (this.leScanCallback == null) {
            this.leScanCallback = new ScanCallback(){

                @MainThread
                public void onScanResult(int callbackType, ScanResult scanResult) {
                    if (LogManager.isVerboseLoggingEnabled()) {
                        LogManager.d(CycledLeScannerForLollipop.TAG, "got record", new Object[0]);
                        List uuids = scanResult.getScanRecord().getServiceUuids();
                        if (uuids != null) {
                            for (ParcelUuid uuid : uuids) {
                                LogManager.d(CycledLeScannerForLollipop.TAG, "with service uuid: " + uuid, new Object[0]);
                            }
                        }
                    }
                    CycledLeScannerForLollipop.this.mCycledLeScanCallback.onLeScan(scanResult.getDevice(), scanResult.getRssi(), scanResult.getScanRecord().getBytes());
                    if (CycledLeScannerForLollipop.this.mBackgroundLScanStartTime > 0L) {
                        LogManager.d(CycledLeScannerForLollipop.TAG, "got a filtered scan result in the background.", new Object[0]);
                    }
                }

                @MainThread
                public void onBatchScanResults(List<ScanResult> results) {
                    LogManager.d(CycledLeScannerForLollipop.TAG, "got batch records", new Object[0]);
                    for (ScanResult scanResult : results) {
                        CycledLeScannerForLollipop.this.mCycledLeScanCallback.onLeScan(scanResult.getDevice(), scanResult.getRssi(), scanResult.getScanRecord().getBytes());
                    }
                    if (CycledLeScannerForLollipop.this.mBackgroundLScanStartTime > 0L) {
                        LogManager.d(CycledLeScannerForLollipop.TAG, "got a filtered batch scan result in the background.", new Object[0]);
                    }
                }

                @MainThread
                public void onScanFailed(int errorCode) {
                    switch (errorCode) {
                        case 1: {
                            LogManager.e(CycledLeScannerForLollipop.TAG, "Scan failed: a BLE scan with the same settings is already started by the app", new Object[0]);
                            break;
                        }
                        case 2: {
                            LogManager.e(CycledLeScannerForLollipop.TAG, "Scan failed: app cannot be registered", new Object[0]);
                            break;
                        }
                        case 4: {
                            LogManager.e(CycledLeScannerForLollipop.TAG, "Scan failed: power optimized scan feature is not supported", new Object[0]);
                            break;
                        }
                        case 3: {
                            LogManager.e(CycledLeScannerForLollipop.TAG, "Scan failed: internal error", new Object[0]);
                            break;
                        }
                        default: {
                            LogManager.e(CycledLeScannerForLollipop.TAG, "Scan failed with unknown error (errorCode=" + errorCode + ")", new Object[0]);
                        }
                    }
                }
            };
        }
        return this.leScanCallback;
    }
}

