/*
 * Decompiled with CFR 0.152.
 */
package org.altbeacon.beacon.service;

import android.annotation.TargetApi;
import android.app.AlarmManager;
import android.app.PendingIntent;
import android.app.Service;
import android.bluetooth.BluetoothDevice;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.content.pm.ServiceInfo;
import android.os.AsyncTask;
import android.os.Binder;
import android.os.Build;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.os.Message;
import android.os.Messenger;
import android.support.annotation.MainThread;
import android.support.annotation.NonNull;
import android.support.annotation.WorkerThread;
import java.lang.ref.WeakReference;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionException;
import org.altbeacon.beacon.Beacon;
import org.altbeacon.beacon.BeaconManager;
import org.altbeacon.beacon.BeaconParser;
import org.altbeacon.beacon.Region;
import org.altbeacon.beacon.distance.DistanceCalculator;
import org.altbeacon.beacon.distance.ModelSpecificDistanceCalculator;
import org.altbeacon.beacon.logging.LogManager;
import org.altbeacon.beacon.service.Callback;
import org.altbeacon.beacon.service.DetectionTracker;
import org.altbeacon.beacon.service.ExtraDataBeaconTracker;
import org.altbeacon.beacon.service.MonitoringStatus;
import org.altbeacon.beacon.service.RangeState;
import org.altbeacon.beacon.service.RangingData;
import org.altbeacon.beacon.service.SettingsData;
import org.altbeacon.beacon.service.StartRMData;
import org.altbeacon.beacon.service.Stats;
import org.altbeacon.beacon.service.scanner.CycledLeScanCallback;
import org.altbeacon.beacon.service.scanner.CycledLeScanner;
import org.altbeacon.beacon.service.scanner.DistinctPacketDetector;
import org.altbeacon.beacon.service.scanner.NonBeaconLeScanCallback;
import org.altbeacon.beacon.startup.StartupBroadcastReceiver;
import org.altbeacon.beacon.utils.ProcessUtils;
import org.altbeacon.bluetooth.BluetoothCrashResolver;

public class BeaconService
extends Service {
    public static final String TAG = "BeaconService";
    private final Map<Region, RangeState> rangedRegionState = new HashMap<Region, RangeState>();
    private MonitoringStatus monitoringStatus;
    int trackedBeaconsPacketCount;
    private final Handler handler = new Handler();
    private BluetoothCrashResolver bluetoothCrashResolver;
    private DistanceCalculator defaultDistanceCalculator = null;
    private BeaconManager beaconManager;
    private Set<BeaconParser> beaconParsers = new HashSet<BeaconParser>();
    private CycledLeScanner mCycledScanner;
    private boolean mBackgroundFlag = false;
    private ExtraDataBeaconTracker mExtraDataBeaconTracker;
    private ExecutorService mExecutor;
    private final DistinctPacketDetector mDistinctPacketDetector = new DistinctPacketDetector();
    private List<Beacon> simulatedScanData = null;
    public static final int MSG_START_RANGING = 2;
    public static final int MSG_STOP_RANGING = 3;
    public static final int MSG_START_MONITORING = 4;
    public static final int MSG_STOP_MONITORING = 5;
    public static final int MSG_SET_SCAN_PERIODS = 6;
    public static final int MSG_SYNC_SETTINGS = 7;
    final Messenger mMessenger = new Messenger((Handler)new IncomingHandler(this));
    protected final CycledLeScanCallback mCycledLeScanCallback = new CycledLeScanCallback(){

        @Override
        @MainThread
        @TargetApi(value=11)
        public void onLeScan(BluetoothDevice device, int rssi, byte[] scanRecord) {
            NonBeaconLeScanCallback nonBeaconLeScanCallback = BeaconService.this.beaconManager.getNonBeaconLeScanCallback();
            try {
                new ScanProcessor(nonBeaconLeScanCallback).executeOnExecutor(BeaconService.this.mExecutor, new ScanData[]{new ScanData(device, rssi, scanRecord)});
            }
            catch (RejectedExecutionException e) {
                LogManager.w(BeaconService.TAG, "Ignoring scan result because we cannot keep up.", new Object[0]);
            }
        }

        @Override
        @MainThread
        public void onCycleEnd() {
            BeaconService.this.mDistinctPacketDetector.clearDetections();
            BeaconService.this.monitoringStatus.updateNewlyOutside();
            BeaconService.this.processRangeData();
            if (BeaconService.this.simulatedScanData != null) {
                LogManager.w(BeaconService.TAG, "Simulated scan data is deprecated and will be removed in a future release. Please use the new BeaconSimulator interface instead.", new Object[0]);
                if (0 != (BeaconService.this.getApplicationInfo().flags &= 2)) {
                    for (Beacon beacon : BeaconService.this.simulatedScanData) {
                        BeaconService.this.processBeaconFromScan(beacon);
                    }
                } else {
                    LogManager.w(BeaconService.TAG, "Simulated scan data provided, but ignored because we are not running in debug mode.  Please remove simulated scan data for production.", new Object[0]);
                }
            }
            if (BeaconManager.getBeaconSimulator() != null) {
                if (BeaconManager.getBeaconSimulator().getBeacons() != null) {
                    if (0 != (BeaconService.this.getApplicationInfo().flags &= 2)) {
                        for (Beacon beacon : BeaconManager.getBeaconSimulator().getBeacons()) {
                            BeaconService.this.processBeaconFromScan(beacon);
                        }
                    } else {
                        LogManager.w(BeaconService.TAG, "Beacon simulations provided, but ignored because we are not running in debug mode.  Please remove beacon simulations for production.", new Object[0]);
                    }
                } else {
                    LogManager.w(BeaconService.TAG, "getBeacons is returning null. No simulated beacons to report.", new Object[0]);
                }
            }
        }
    };

    @MainThread
    public void onCreate() {
        this.bluetoothCrashResolver = new BluetoothCrashResolver((Context)this);
        this.bluetoothCrashResolver.start();
        this.mExecutor = Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors() + 1);
        this.mCycledScanner = CycledLeScanner.createScanner((Context)this, 1100L, 0L, this.mBackgroundFlag, this.mCycledLeScanCallback, this.bluetoothCrashResolver);
        this.beaconManager = BeaconManager.getInstanceForApplication(this.getApplicationContext());
        this.beaconManager.setScannerInSameProcess(true);
        if (this.beaconManager.isMainProcess()) {
            LogManager.i(TAG, "beaconService version %s is starting up on the main process", "2.11");
        } else {
            LogManager.i(TAG, "beaconService version %s is starting up on a separate process", "2.11");
            ProcessUtils processUtils = new ProcessUtils((Context)this);
            LogManager.i(TAG, "beaconService PID is " + processUtils.getPid() + " with process name " + processUtils.getProcessName(), new Object[0]);
        }
        try {
            ServiceInfo info = this.getPackageManager().getServiceInfo(new ComponentName((Context)this, BeaconService.class), 128);
            if (info != null && info.metaData != null && info.metaData.get("longScanForcingEnabled") != null && info.metaData.get("longScanForcingEnabled").toString().equals("true")) {
                LogManager.i(TAG, "longScanForcingEnabled to keep scans going on Android N for > 30 minutes", new Object[0]);
                this.mCycledScanner.setLongScanForcingEnabled(true);
            }
        }
        catch (PackageManager.NameNotFoundException info) {
            // empty catch block
        }
        this.reloadParsers();
        this.defaultDistanceCalculator = new ModelSpecificDistanceCalculator((Context)this, BeaconManager.getDistanceModelUpdateUrl());
        Beacon.setDistanceCalculator(this.defaultDistanceCalculator);
        this.monitoringStatus = MonitoringStatus.getInstanceForApplication(this.getApplicationContext());
        try {
            Class<?> klass = Class.forName("org.altbeacon.beacon.SimulatedScanData");
            Field f = klass.getField("beacons");
            this.simulatedScanData = (List)f.get(null);
        }
        catch (ClassNotFoundException e) {
            LogManager.d(TAG, "No org.altbeacon.beacon.SimulatedScanData class exists.", new Object[0]);
        }
        catch (Exception e) {
            LogManager.e(e, TAG, "Cannot get simulated Scan data.  Make sure your org.altbeacon.beacon.SimulatedScanData class defines a field with the signature 'public static List<Beacon> beacons'", new Object[0]);
        }
    }

    protected void reloadParsers() {
        HashSet<BeaconParser> newBeaconParsers = new HashSet<BeaconParser>();
        boolean matchBeaconsByServiceUUID = true;
        if (this.beaconManager.getBeaconParsers() != null) {
            newBeaconParsers.addAll(this.beaconManager.getBeaconParsers());
            for (BeaconParser beaconParser : this.beaconManager.getBeaconParsers()) {
                if (beaconParser.getExtraDataParsers().size() <= 0) continue;
                matchBeaconsByServiceUUID = false;
                newBeaconParsers.addAll(beaconParser.getExtraDataParsers());
            }
        }
        this.beaconParsers = newBeaconParsers;
        this.mExtraDataBeaconTracker = new ExtraDataBeaconTracker(matchBeaconsByServiceUUID);
    }

    public int onStartCommand(Intent intent, int flags, int startId) {
        LogManager.i(TAG, intent == null ? "starting with null intent" : "starting with intent " + intent.toString(), new Object[0]);
        return super.onStartCommand(intent, flags, startId);
    }

    public IBinder onBind(Intent intent) {
        LogManager.i(TAG, "binding", new Object[0]);
        return this.mMessenger.getBinder();
    }

    public boolean onUnbind(Intent intent) {
        LogManager.i(TAG, "unbinding", new Object[0]);
        return false;
    }

    @MainThread
    public void onDestroy() {
        LogManager.e(TAG, "onDestroy()", new Object[0]);
        if (Build.VERSION.SDK_INT < 18) {
            LogManager.w(TAG, "Not supported prior to API 18.", new Object[0]);
            return;
        }
        this.bluetoothCrashResolver.stop();
        LogManager.i(TAG, "onDestroy called.  stopping scanning", new Object[0]);
        this.handler.removeCallbacksAndMessages(null);
        this.mCycledScanner.stop();
        this.mCycledScanner.destroy();
        this.monitoringStatus.stopStatusPreservation();
    }

    public void onTaskRemoved(Intent rootIntent) {
        super.onTaskRemoved(rootIntent);
        LogManager.d(TAG, "task removed", new Object[0]);
        if (Build.VERSION.RELEASE.contains("4.4.1") || Build.VERSION.RELEASE.contains("4.4.2") || Build.VERSION.RELEASE.contains("4.4.3")) {
            AlarmManager alarmManager = (AlarmManager)this.getApplicationContext().getSystemService("alarm");
            alarmManager.set(0, System.currentTimeMillis() + 1000L, this.getRestartIntent());
            LogManager.d(TAG, "Setting a wakeup alarm to go off due to Android 4.4.2 service restarting bug.", new Object[0]);
        }
    }

    private PendingIntent getRestartIntent() {
        Intent restartIntent = new Intent(this.getApplicationContext(), StartupBroadcastReceiver.class);
        return PendingIntent.getBroadcast((Context)this.getApplicationContext(), (int)1, (Intent)restartIntent, (int)0x40000000);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @MainThread
    public void startRangingBeaconsInRegion(Region region, Callback callback) {
        Map<Region, RangeState> map = this.rangedRegionState;
        synchronized (map) {
            if (this.rangedRegionState.containsKey(region)) {
                LogManager.i(TAG, "Already ranging that region -- will replace existing region.", new Object[0]);
                this.rangedRegionState.remove(region);
            }
            this.rangedRegionState.put(region, new RangeState(callback));
            LogManager.d(TAG, "Currently ranging %s regions.", this.rangedRegionState.size());
        }
        this.mCycledScanner.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @MainThread
    public void stopRangingBeaconsInRegion(Region region) {
        int rangedRegionCount;
        Map<Region, RangeState> map = this.rangedRegionState;
        synchronized (map) {
            this.rangedRegionState.remove(region);
            rangedRegionCount = this.rangedRegionState.size();
            LogManager.d(TAG, "Currently ranging %s regions.", this.rangedRegionState.size());
        }
        if (rangedRegionCount == 0 && this.monitoringStatus.regionsCount() == 0) {
            this.mCycledScanner.stop();
        }
    }

    @MainThread
    public void startMonitoringBeaconsInRegion(Region region, Callback callback) {
        LogManager.d(TAG, "startMonitoring called", new Object[0]);
        this.monitoringStatus.addRegion(region, callback);
        LogManager.d(TAG, "Currently monitoring %s regions.", this.monitoringStatus.regionsCount());
        this.mCycledScanner.start();
    }

    @MainThread
    public void stopMonitoringBeaconsInRegion(Region region) {
        LogManager.d(TAG, "stopMonitoring called", new Object[0]);
        this.monitoringStatus.removeRegion(region);
        LogManager.d(TAG, "Currently monitoring %s regions.", this.monitoringStatus.regionsCount());
        if (this.monitoringStatus.regionsCount() == 0 && this.rangedRegionState.size() == 0) {
            this.mCycledScanner.stop();
        }
    }

    @MainThread
    public void setScanPeriods(long scanPeriod, long betweenScanPeriod, boolean backgroundFlag) {
        this.mCycledScanner.setScanPeriods(scanPeriod, betweenScanPeriod, backgroundFlag);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processRangeData() {
        Map<Region, RangeState> map = this.rangedRegionState;
        synchronized (map) {
            for (Region region : this.rangedRegionState.keySet()) {
                RangeState rangeState = this.rangedRegionState.get(region);
                LogManager.d(TAG, "Calling ranging callback", new Object[0]);
                rangeState.getCallback().call((Context)this, "rangingData", new RangingData(rangeState.finalizeBeacons(), region).toBundle());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    private void processBeaconFromScan(@NonNull Beacon beacon) {
        if (Stats.getInstance().isEnabled()) {
            Stats.getInstance().log(beacon);
        }
        if (LogManager.isVerboseLoggingEnabled()) {
            LogManager.d(TAG, "beacon detected : %s", beacon.toString());
        }
        if ((beacon = this.mExtraDataBeaconTracker.track(beacon)) == null) {
            if (LogManager.isVerboseLoggingEnabled()) {
                LogManager.d(TAG, "not processing detections for GATT extra data beacon", new Object[0]);
            }
        } else {
            this.monitoringStatus.updateNewlyInsideInRegionsContaining(beacon);
            List<Region> matchedRegions = null;
            LogManager.d(TAG, "looking for ranging region matches for this beacon", new Object[0]);
            Map<Region, RangeState> map = this.rangedRegionState;
            synchronized (map) {
                matchedRegions = this.matchingRegions(beacon, this.rangedRegionState.keySet());
                for (Region region : matchedRegions) {
                    LogManager.d(TAG, "matches ranging region: %s", region);
                    RangeState rangeState = this.rangedRegionState.get(region);
                    if (rangeState == null) continue;
                    rangeState.addBeacon(beacon);
                }
            }
        }
    }

    private List<Region> matchingRegions(Beacon beacon, Collection<Region> regions) {
        ArrayList<Region> matched = new ArrayList<Region>();
        for (Region region : regions) {
            if (region.matchesBeacon(beacon)) {
                matched.add(region);
                continue;
            }
            LogManager.d(TAG, "This region (%s) does not match beacon: %s", region, beacon);
        }
        return matched;
    }

    private class ScanProcessor
    extends AsyncTask<ScanData, Void, Void> {
        final DetectionTracker mDetectionTracker = DetectionTracker.getInstance();
        private final NonBeaconLeScanCallback mNonBeaconLeScanCallback;

        public ScanProcessor(NonBeaconLeScanCallback nonBeaconLeScanCallback) {
            this.mNonBeaconLeScanCallback = nonBeaconLeScanCallback;
        }

        @WorkerThread
        protected Void doInBackground(ScanData ... params) {
            BeaconParser parser;
            ScanData scanData = params[0];
            Beacon beacon = null;
            Iterator iterator = BeaconService.this.beaconParsers.iterator();
            while (iterator.hasNext() && (beacon = (parser = (BeaconParser)iterator.next()).fromScanData(scanData.scanRecord, scanData.rssi, scanData.device)) == null) {
            }
            if (beacon != null) {
                if (LogManager.isVerboseLoggingEnabled()) {
                    LogManager.d(BeaconService.TAG, "Beacon packet detected for: " + beacon + " with rssi " + beacon.getRssi(), new Object[0]);
                }
                this.mDetectionTracker.recordDetection();
                if (!BeaconService.this.mCycledScanner.getDistinctPacketsDetectedPerScan() && !BeaconService.this.mDistinctPacketDetector.isPacketDistinct(scanData.device.getAddress(), scanData.scanRecord)) {
                    LogManager.i(BeaconService.TAG, "Non-distinct packets detected in a single scan.  Restarting scans unnecessary.", new Object[0]);
                    BeaconService.this.mCycledScanner.setDistinctPacketsDetectedPerScan(true);
                }
                ++BeaconService.this.trackedBeaconsPacketCount;
                BeaconService.this.processBeaconFromScan(beacon);
            } else if (this.mNonBeaconLeScanCallback != null) {
                this.mNonBeaconLeScanCallback.onNonBeaconLeScan(scanData.device, scanData.rssi, scanData.scanRecord);
            }
            return null;
        }
    }

    private static class ScanData {
        final int rssi;
        @NonNull
        final BluetoothDevice device;
        @NonNull
        final byte[] scanRecord;

        ScanData(@NonNull BluetoothDevice device, int rssi, @NonNull byte[] scanRecord) {
            this.device = device;
            this.rssi = rssi;
            this.scanRecord = scanRecord;
        }
    }

    static class IncomingHandler
    extends Handler {
        private final WeakReference<BeaconService> mService;

        IncomingHandler(BeaconService service) {
            super(Looper.getMainLooper());
            this.mService = new WeakReference<BeaconService>(service);
        }

        @MainThread
        public void handleMessage(Message msg) {
            BeaconService service = (BeaconService)((Object)this.mService.get());
            if (service != null) {
                StartRMData startRMData = StartRMData.fromBundle(msg.getData());
                if (startRMData != null) {
                    switch (msg.what) {
                        case 2: {
                            LogManager.i(BeaconService.TAG, "start ranging received", new Object[0]);
                            service.startRangingBeaconsInRegion(startRMData.getRegionData(), new Callback(startRMData.getCallbackPackageName()));
                            service.setScanPeriods(startRMData.getScanPeriod(), startRMData.getBetweenScanPeriod(), startRMData.getBackgroundFlag());
                            break;
                        }
                        case 3: {
                            LogManager.i(BeaconService.TAG, "stop ranging received", new Object[0]);
                            service.stopRangingBeaconsInRegion(startRMData.getRegionData());
                            service.setScanPeriods(startRMData.getScanPeriod(), startRMData.getBetweenScanPeriod(), startRMData.getBackgroundFlag());
                            break;
                        }
                        case 4: {
                            LogManager.i(BeaconService.TAG, "start monitoring received", new Object[0]);
                            service.startMonitoringBeaconsInRegion(startRMData.getRegionData(), new Callback(startRMData.getCallbackPackageName()));
                            service.setScanPeriods(startRMData.getScanPeriod(), startRMData.getBetweenScanPeriod(), startRMData.getBackgroundFlag());
                            break;
                        }
                        case 5: {
                            LogManager.i(BeaconService.TAG, "stop monitoring received", new Object[0]);
                            service.stopMonitoringBeaconsInRegion(startRMData.getRegionData());
                            service.setScanPeriods(startRMData.getScanPeriod(), startRMData.getBetweenScanPeriod(), startRMData.getBackgroundFlag());
                            break;
                        }
                        case 6: {
                            LogManager.i(BeaconService.TAG, "set scan intervals received", new Object[0]);
                            service.setScanPeriods(startRMData.getScanPeriod(), startRMData.getBetweenScanPeriod(), startRMData.getBackgroundFlag());
                            break;
                        }
                        default: {
                            super.handleMessage(msg);
                            break;
                        }
                    }
                } else if (msg.what == 7) {
                    LogManager.i(BeaconService.TAG, "Received settings update from other process", new Object[0]);
                    SettingsData settingsData = SettingsData.fromBundle(msg.getData());
                    if (settingsData != null) {
                        settingsData.apply(service);
                    } else {
                        LogManager.w(BeaconService.TAG, "Settings data missing", new Object[0]);
                    }
                } else {
                    LogManager.i(BeaconService.TAG, "Received unknown message from other process : " + msg.what, new Object[0]);
                }
            }
        }
    }

    public class BeaconBinder
    extends Binder {
        public BeaconService getService() {
            LogManager.i(BeaconService.TAG, "getService of BeaconBinder called", new Object[0]);
            return BeaconService.this;
        }
    }
}

