/*
 * Decompiled with CFR 0.152.
 */
package org.altbeacon.beacon.service;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.os.Parcelable;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import org.altbeacon.beacon.logging.LogManager;

public class Callback
implements Serializable {
    private static final String TAG = "Callback";
    private transient Intent intent;
    private String intentPackageName;

    public Callback(String intentPackageName) {
        this.intentPackageName = intentPackageName;
        this.initializeIntent();
    }

    private void initializeIntent() {
        if (this.intentPackageName != null) {
            this.intent = new Intent();
            this.intent.setComponent(new ComponentName(this.intentPackageName, "org.altbeacon.beacon.BeaconIntentProcessor"));
        }
    }

    public Intent getIntent() {
        return this.intent;
    }

    public boolean call(Context context, String dataName, Parcelable data) {
        if (this.intent == null) {
            this.initializeIntent();
        }
        boolean success = false;
        if (this.intent != null) {
            LogManager.d(TAG, "attempting callback via intent: %s", this.intent.getComponent());
            this.intent.putExtra(dataName, data);
            try {
                context.startService(this.intent);
                success = true;
            }
            catch (Exception e) {
                LogManager.e(TAG, "Failed attempting to start service: " + this.intent.getComponent().flattenToString(), e);
            }
        }
        return success;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.initializeIntent();
    }
}

