/*
 * Decompiled with CFR 0.152.
 */
package org.altbeacon.beacon.powersave;

import android.annotation.TargetApi;
import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.os.Build;
import android.os.Bundle;
import org.altbeacon.beacon.BeaconManager;
import org.altbeacon.beacon.logging.LogManager;

@TargetApi(value=18)
public class BackgroundPowerSaver
implements Application.ActivityLifecycleCallbacks {
    private static final String TAG = "BackgroundPowerSaver";
    private BeaconManager beaconManager;
    private int activeActivityCount = 0;

    public BackgroundPowerSaver(Context context, boolean countActiveActivityStrategy) {
        this(context);
    }

    public BackgroundPowerSaver(Context context) {
        if (Build.VERSION.SDK_INT < 18) {
            LogManager.w(TAG, "BackgroundPowerSaver requires API 18 or higher.", new Object[0]);
            return;
        }
        this.beaconManager = BeaconManager.getInstanceForApplication(context);
        ((Application)context.getApplicationContext()).registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)this);
    }

    public void onActivityCreated(Activity activity, Bundle bundle) {
    }

    public void onActivityStarted(Activity activity) {
    }

    public void onActivityResumed(Activity activity) {
        ++this.activeActivityCount;
        if (this.activeActivityCount < 1) {
            LogManager.d(TAG, "reset active activity count on resume.  It was %s", this.activeActivityCount);
            this.activeActivityCount = 1;
        }
        this.beaconManager.setBackgroundMode(false);
        LogManager.d(TAG, "activity resumed: %s active activities: %s", activity, this.activeActivityCount);
    }

    public void onActivityPaused(Activity activity) {
        --this.activeActivityCount;
        LogManager.d(TAG, "activity paused: %s active activities: %s", activity, this.activeActivityCount);
        if (this.activeActivityCount < 1) {
            LogManager.d(TAG, "setting background mode", new Object[0]);
            this.beaconManager.setBackgroundMode(true);
        }
    }

    public void onActivityStopped(Activity activity) {
    }

    public void onActivitySaveInstanceState(Activity activity, Bundle bundle) {
    }

    public void onActivityDestroyed(Activity activity) {
    }
}

