/*
 * Decompiled with CFR 0.152.
 */
package org.altbeacon.beacon;

import android.annotation.TargetApi;
import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothManager;
import android.bluetooth.le.AdvertiseCallback;
import android.bluetooth.le.AdvertiseData;
import android.bluetooth.le.AdvertiseSettings;
import android.bluetooth.le.BluetoothLeAdvertiser;
import android.content.Context;
import android.os.Build;
import org.altbeacon.beacon.Beacon;
import org.altbeacon.beacon.BeaconParser;
import org.altbeacon.beacon.logging.LogManager;

@TargetApi(value=21)
public class BeaconTransmitter {
    public static final int SUPPORTED = 0;
    public static final int NOT_SUPPORTED_MIN_SDK = 1;
    public static final int NOT_SUPPORTED_BLE = 2;
    public static final int NOT_SUPPORTED_MULTIPLE_ADVERTISEMENTS = 3;
    public static final int NOT_SUPPORTED_CANNOT_GET_ADVERTISER = 4;
    private static final String TAG = "BeaconTransmitter";
    private BluetoothAdapter mBluetoothAdapter;
    private BluetoothLeAdvertiser mBluetoothLeAdvertiser;
    private int mAdvertiseMode = 0;
    private int mAdvertiseTxPowerLevel = 3;
    private Beacon mBeacon;
    private BeaconParser mBeaconParser;
    private AdvertiseCallback mAdvertisingClientCallback;
    private boolean mStarted;
    private AdvertiseCallback mAdvertiseCallback;

    public BeaconTransmitter(Context context, BeaconParser parser) {
        this.mBeaconParser = parser;
        BluetoothManager bluetoothManager = (BluetoothManager)context.getSystemService("bluetooth");
        if (bluetoothManager != null) {
            this.mBluetoothAdapter = bluetoothManager.getAdapter();
            this.mBluetoothLeAdvertiser = this.mBluetoothAdapter.getBluetoothLeAdvertiser();
            LogManager.d(TAG, "new BeaconTransmitter constructed.  mbluetoothLeAdvertiser is %s", this.mBluetoothLeAdvertiser);
        } else {
            LogManager.e(TAG, "Failed to get BluetoothManager", new Object[0]);
        }
    }

    public boolean isStarted() {
        return this.mStarted;
    }

    public void setBeacon(Beacon beacon) {
        this.mBeacon = beacon;
    }

    public void setBeaconParser(BeaconParser beaconParser) {
        this.mBeaconParser = beaconParser;
    }

    public int getAdvertiseMode() {
        return this.mAdvertiseMode;
    }

    public void setAdvertiseMode(int mAdvertiseMode) {
        this.mAdvertiseMode = mAdvertiseMode;
    }

    public int getAdvertiseTxPowerLevel() {
        return this.mAdvertiseTxPowerLevel;
    }

    public void setAdvertiseTxPowerLevel(int mAdvertiseTxPowerLevel) {
        this.mAdvertiseTxPowerLevel = mAdvertiseTxPowerLevel;
    }

    public void startAdvertising(Beacon beacon) {
        this.startAdvertising(beacon, null);
    }

    public void startAdvertising(Beacon beacon, AdvertiseCallback callback) {
        this.mBeacon = beacon;
        this.mAdvertisingClientCallback = callback;
        this.startAdvertising();
    }

    public void startAdvertising() {
        if (this.mBeacon == null) {
            throw new NullPointerException("Beacon cannot be null.  Set beacon before starting advertising");
        }
        int manufacturerCode = this.mBeacon.getManufacturer();
        if (this.mBeaconParser == null) {
            throw new NullPointerException("You must supply a BeaconParser instance to BeaconTransmitter.");
        }
        byte[] advertisingBytes = this.mBeaconParser.getBeaconAdvertisementData(this.mBeacon);
        String byteString = "";
        for (int i = 0; i < advertisingBytes.length; ++i) {
            byteString = byteString + String.format("%02X", advertisingBytes[i]);
            byteString = byteString + " ";
        }
        LogManager.d(TAG, "Starting advertising with ID1: %s ID2: %s ID3: %s and data: %s of size %s", this.mBeacon.getId1(), this.mBeacon.getId2(), this.mBeacon.getId3(), byteString, advertisingBytes.length);
        try {
            AdvertiseData.Builder dataBuilder = new AdvertiseData.Builder();
            dataBuilder.addManufacturerData(manufacturerCode, advertisingBytes);
            AdvertiseSettings.Builder settingsBuilder = new AdvertiseSettings.Builder();
            settingsBuilder.setAdvertiseMode(this.mAdvertiseMode);
            settingsBuilder.setTxPowerLevel(this.mAdvertiseTxPowerLevel);
            settingsBuilder.setConnectable(false);
            this.mBluetoothLeAdvertiser.startAdvertising(settingsBuilder.build(), dataBuilder.build(), this.getAdvertiseCallback());
            LogManager.d(TAG, "Started advertisement with callback: %s", this.getAdvertiseCallback());
        }
        catch (Exception e) {
            LogManager.e(e, TAG, "Cannot start advertising due to exception", new Object[0]);
        }
    }

    public void stopAdvertising() {
        if (!this.mStarted) {
            LogManager.d(TAG, "Skipping stop advertising -- not started", new Object[0]);
            return;
        }
        LogManager.d(TAG, "Stopping advertising with object %s", this.mBluetoothLeAdvertiser);
        this.mAdvertisingClientCallback = null;
        this.mBluetoothLeAdvertiser.stopAdvertising(this.getAdvertiseCallback());
        this.mStarted = false;
    }

    public static int checkTransmissionSupported(Context context) {
        if (Build.VERSION.SDK_INT < 21) {
            return 1;
        }
        if (!context.getApplicationContext().getPackageManager().hasSystemFeature("android.hardware.bluetooth_le")) {
            return 2;
        }
        if (!((BluetoothManager)context.getSystemService("bluetooth")).getAdapter().isMultipleAdvertisementSupported()) {
            return 3;
        }
        try {
            ((BluetoothManager)context.getSystemService("bluetooth")).getAdapter().getBluetoothLeAdvertiser();
        }
        catch (Exception e) {
            return 4;
        }
        return 0;
    }

    private AdvertiseCallback getAdvertiseCallback() {
        if (this.mAdvertiseCallback == null) {
            this.mAdvertiseCallback = new AdvertiseCallback(){

                public void onStartFailure(int errorCode) {
                    LogManager.e(BeaconTransmitter.TAG, "Advertisement start failed, code: %s", errorCode);
                    if (BeaconTransmitter.this.mAdvertisingClientCallback != null) {
                        BeaconTransmitter.this.mAdvertisingClientCallback.onStartFailure(errorCode);
                    }
                }

                public void onStartSuccess(AdvertiseSettings settingsInEffect) {
                    LogManager.i(BeaconTransmitter.TAG, "Advertisement start succeeded.", new Object[0]);
                    BeaconTransmitter.this.mStarted = true;
                    if (BeaconTransmitter.this.mAdvertisingClientCallback != null) {
                        BeaconTransmitter.this.mAdvertisingClientCallback.onStartSuccess(settingsInEffect);
                    }
                }
            };
        }
        return this.mAdvertiseCallback;
    }
}

