/*
 * Decompiled with CFR 0.152.
 */
package org.altbeacon.beacon.service;

import android.util.Log;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import org.altbeacon.beacon.Beacon;

public class Stats {
    private static final SimpleDateFormat sdf = new SimpleDateFormat("HH:mm:ss.SSS");
    private ArrayList<Sample> mSamples;
    private long mSampleIntervalMillis = 0L;
    private boolean mEnableLogging;
    private boolean mEnableHistoricalLogging;
    private boolean mEnabled;
    private Sample mSample;
    private static final String TAG = "Stats";
    private static Stats mInstance;

    public static Stats getInstance() {
        if (mInstance == null) {
            mInstance = new Stats();
        }
        return mInstance;
    }

    private Stats() {
        this.clearSamples();
    }

    public ArrayList<Sample> getSamples() {
        this.rollSampleIfNeeded();
        return this.mSamples;
    }

    public void setEnabled(boolean enabled) {
        this.mEnabled = enabled;
    }

    public boolean isEnabled() {
        return this.mEnabled;
    }

    public void setLoggingEnabled(boolean enabled) {
        this.mEnableLogging = enabled;
    }

    public void setHistoricalLoggingEnabled(boolean enabled) {
        this.mEnableHistoricalLogging = enabled;
    }

    public void setSampleIntervalMillis(long interval) {
        this.mSampleIntervalMillis = interval;
    }

    public void log(Beacon beacon) {
        long timeSinceLastDetection;
        this.rollSampleIfNeeded();
        ++this.mSample.detectionCount;
        if (this.mSample.firstDetectionTime == null) {
            this.mSample.firstDetectionTime = new Date();
        }
        if (this.mSample.lastDetectionTime != null && (timeSinceLastDetection = new Date().getTime() - this.mSample.lastDetectionTime.getTime()) > this.mSample.maxMillisBetweenDetections) {
            this.mSample.maxMillisBetweenDetections = timeSinceLastDetection;
        }
        this.mSample.lastDetectionTime = new Date();
    }

    public void clearSample() {
        this.mSample = null;
    }

    public void newSampleInterval() {
        Date boundaryTime = new Date();
        if (this.mSample != null) {
            this.mSample.sampleStopTime = boundaryTime = new Date(this.mSample.sampleStartTime.getTime() + this.mSampleIntervalMillis);
            if (!this.mEnableHistoricalLogging && this.mEnableLogging) {
                this.logSample(this.mSample, true);
            }
        }
        this.mSample = new Sample();
        this.mSample.sampleStartTime = boundaryTime;
        this.mSamples.add(this.mSample);
        if (this.mEnableHistoricalLogging) {
            this.logSamples();
        }
    }

    public void clearSamples() {
        this.mSamples = new ArrayList();
        this.newSampleInterval();
    }

    private void logSample(Sample sample, boolean showHeader) {
        if (showHeader) {
            Log.d((String)TAG, (String)"sample start time, sample stop time, first detection time, last detection time, max millis between detections, detection count");
        }
        Log.d((String)TAG, (String)(this.formattedDate(sample.sampleStartTime) + "," + this.formattedDate(sample.sampleStopTime) + ", " + this.formattedDate(sample.firstDetectionTime) + ", " + this.formattedDate(sample.lastDetectionTime) + ", " + sample.maxMillisBetweenDetections + ", " + sample.detectionCount));
    }

    private String formattedDate(Date d) {
        return d == null ? "" : sdf.format(d);
    }

    private void logSamples() {
        Log.d((String)TAG, (String)("--- Stats for " + this.mSamples.size() + " samples"));
        boolean firstPass = true;
        for (Sample sample : this.mSamples) {
            this.logSample(sample, firstPass);
            firstPass = false;
        }
    }

    private void rollSampleIfNeeded() {
        if (this.mSample == null || this.mSampleIntervalMillis > 0L && new Date().getTime() - this.mSample.sampleStartTime.getTime() >= this.mSampleIntervalMillis) {
            this.newSampleInterval();
        }
    }

    public static class Sample {
        public long detectionCount = 0L;
        public long maxMillisBetweenDetections;
        public Date firstDetectionTime;
        public Date lastDetectionTime;
        public Date sampleStartTime;
        public Date sampleStopTime;
    }
}

