/*
 * Decompiled with CFR 0.152.
 */
package org.altbeacon.beacon.service;

import android.os.Parcel;
import android.os.Parcelable;
import java.util.ArrayList;
import java.util.Collection;
import org.altbeacon.beacon.Beacon;
import org.altbeacon.beacon.BeaconManager;
import org.altbeacon.beacon.Region;

public class RangingData
implements Parcelable {
    private static final String TAG = "RangingData";
    private Collection<Beacon> beacons;
    private Region region;
    public static final Parcelable.Creator<RangingData> CREATOR = new Parcelable.Creator<RangingData>(){

        public RangingData createFromParcel(Parcel in) {
            return new RangingData(in);
        }

        public RangingData[] newArray(int size) {
            return new RangingData[size];
        }
    };

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RangingData(Collection<Beacon> beacons, Region region) {
        Collection<Beacon> collection = beacons;
        synchronized (collection) {
            this.beacons = beacons;
        }
        this.region = region;
    }

    public Collection<Beacon> getBeacons() {
        return this.beacons;
    }

    public Region getRegion() {
        return this.region;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel out, int flags) {
        BeaconManager.logDebug(TAG, "writing RangingData");
        out.writeParcelableArray(this.beacons.toArray(new Parcelable[0]), flags);
        out.writeParcelable((Parcelable)this.region, flags);
        BeaconManager.logDebug(TAG, "done writing RangingData");
    }

    private RangingData(Parcel in) {
        BeaconManager.logDebug(TAG, "parsing RangingData");
        Parcelable[] parcelables = in.readParcelableArray(this.getClass().getClassLoader());
        this.beacons = new ArrayList<Beacon>(parcelables.length);
        for (int i = 0; i < parcelables.length; ++i) {
            this.beacons.add((Beacon)parcelables[i]);
        }
        this.region = (Region)in.readParcelable(this.getClass().getClassLoader());
    }
}

