/*
 * Decompiled with CFR 0.152.
 */
package org.altbeacon.beacon.service;

import android.annotation.TargetApi;
import android.app.Service;
import android.bluetooth.BluetoothDevice;
import android.content.Context;
import android.content.Intent;
import android.os.AsyncTask;
import android.os.Binder;
import android.os.Build;
import android.os.Handler;
import android.os.IBinder;
import android.os.Message;
import android.os.Messenger;
import android.util.Log;
import java.lang.ref.WeakReference;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.altbeacon.beacon.Beacon;
import org.altbeacon.beacon.BeaconManager;
import org.altbeacon.beacon.BeaconParser;
import org.altbeacon.beacon.Region;
import org.altbeacon.beacon.distance.DistanceCalculator;
import org.altbeacon.beacon.distance.ModelSpecificDistanceCalculator;
import org.altbeacon.beacon.service.Callback;
import org.altbeacon.beacon.service.DetectionTracker;
import org.altbeacon.beacon.service.MonitorState;
import org.altbeacon.beacon.service.MonitoringData;
import org.altbeacon.beacon.service.RangeState;
import org.altbeacon.beacon.service.RangingData;
import org.altbeacon.beacon.service.StartRMData;
import org.altbeacon.beacon.service.Stats;
import org.altbeacon.beacon.service.scanner.CycledLeScanCallback;
import org.altbeacon.beacon.service.scanner.CycledLeScanner;
import org.altbeacon.bluetooth.BluetoothCrashResolver;

@TargetApi(value=5)
public class BeaconService
extends Service {
    public static final String TAG = "BeaconService";
    private Map<Region, RangeState> rangedRegionState = new HashMap<Region, RangeState>();
    private Map<Region, MonitorState> monitoredRegionState = new HashMap<Region, MonitorState>();
    private HashSet<Beacon> trackedBeacons;
    int trackedBeaconsPacketCount;
    private Handler handler = new Handler();
    private int bindCount = 0;
    private BluetoothCrashResolver bluetoothCrashResolver;
    private boolean scanningEnabled = false;
    private DistanceCalculator defaultDistanceCalculator = null;
    private List<BeaconParser> beaconParsers;
    private CycledLeScanner mCycledScanner;
    private boolean mBackgroundFlag = false;
    private List<Beacon> simulatedScanData = null;
    public static final int MSG_START_RANGING = 2;
    public static final int MSG_STOP_RANGING = 3;
    public static final int MSG_START_MONITORING = 4;
    public static final int MSG_STOP_MONITORING = 5;
    public static final int MSG_SET_SCAN_PERIODS = 6;
    final Messenger mMessenger = new Messenger((Handler)new IncomingHandler(this));
    private CycledLeScanCallback mCycledLeScanCallback = new CycledLeScanCallback(){

        @Override
        @TargetApi(value=11)
        public void onLeScan(BluetoothDevice device, int rssi, byte[] scanRecord) {
            new ScanProcessor().executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR, new ScanData[]{new ScanData(device, rssi, scanRecord)});
        }

        @Override
        public void onCycleEnd() {
            BeaconService.this.processExpiredMonitors();
            BeaconService.this.processRangeData();
            if (BeaconService.this.simulatedScanData != null) {
                Log.w((String)BeaconService.TAG, (String)"Simulated scan data is deprecated and will be removed in a future release. Please use the new BeaconSimulator interface instead.");
                if (0 != (BeaconService.this.getApplicationInfo().flags &= 2)) {
                    for (Beacon beacon : BeaconService.this.simulatedScanData) {
                        BeaconService.this.processBeaconFromScan(beacon);
                    }
                } else {
                    Log.w((String)BeaconService.TAG, (String)"Simulated scan data provided, but ignored because we are not running in debug mode.  Please remove simulated scan data for production.");
                }
            }
            if (BeaconManager.getBeaconSimulator() != null) {
                if (BeaconManager.getBeaconSimulator().getBeacons() != null) {
                    if (0 != (BeaconService.this.getApplicationInfo().flags &= 2)) {
                        for (Beacon beacon : BeaconManager.getBeaconSimulator().getBeacons()) {
                            BeaconService.this.processBeaconFromScan(beacon);
                        }
                    } else {
                        Log.w((String)BeaconService.TAG, (String)"Beacon simulations provided, but ignored because we are not running in debug mode.  Please remove beacon simulations for production.");
                    }
                } else {
                    Log.w((String)BeaconService.TAG, (String)"getBeacons is returning null. No simulated beacons to report.");
                }
            }
        }
    };

    public IBinder onBind(Intent intent) {
        Log.i((String)TAG, (String)"binding");
        ++this.bindCount;
        return this.mMessenger.getBinder();
    }

    public boolean onUnbind(Intent intent) {
        Log.i((String)TAG, (String)"unbinding");
        --this.bindCount;
        return false;
    }

    public void onCreate() {
        Log.i((String)TAG, (String)"beaconService version 2.1-beta-4 is starting up");
        this.bluetoothCrashResolver = new BluetoothCrashResolver((Context)this);
        this.bluetoothCrashResolver.start();
        this.mCycledScanner = CycledLeScanner.createScanner((Context)this, 1100L, 0L, this.mBackgroundFlag, this.mCycledLeScanCallback, this.bluetoothCrashResolver);
        this.beaconParsers = BeaconManager.getInstanceForApplication(this.getApplicationContext()).getBeaconParsers();
        this.defaultDistanceCalculator = new ModelSpecificDistanceCalculator((Context)this, BeaconManager.getDistanceModelUpdateUrl());
        Beacon.setDistanceCalculator(this.defaultDistanceCalculator);
        try {
            Class<?> klass = Class.forName("org.altbeacon.beacon.SimulatedScanData");
            Field f = klass.getField("beacons");
            this.simulatedScanData = (List)f.get(null);
        }
        catch (ClassNotFoundException e) {
            BeaconManager.logDebug(TAG, "No org.altbeacon.beacon.SimulatedScanData class exists.");
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)"Cannot get simulated Scan data.  Make sure your org.altbeacon.beacon.SimulatedScanData class defines a field with the signature 'public static List<Beacon> beacons'", (Throwable)e);
        }
    }

    @TargetApi(value=18)
    public void onDestroy() {
        if (Build.VERSION.SDK_INT < 18) {
            Log.w((String)TAG, (String)"Not supported prior to API 18.");
            return;
        }
        this.bluetoothCrashResolver.stop();
        Log.i((String)TAG, (String)"onDestroy called.  stopping scanning");
        this.handler.removeCallbacksAndMessages(null);
        this.mCycledScanner.stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startRangingBeaconsInRegion(Region region, Callback callback) {
        Map<Region, RangeState> map = this.rangedRegionState;
        synchronized (map) {
            if (this.rangedRegionState.containsKey(region)) {
                Log.i((String)TAG, (String)"Already ranging that region -- will replace existing region.");
                this.rangedRegionState.remove(region);
            }
            this.rangedRegionState.put(region, new RangeState(callback));
            BeaconManager.logDebug(TAG, "Currently ranging " + this.rangedRegionState.size() + " regions.");
        }
        if (!this.scanningEnabled) {
            this.mCycledScanner.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopRangingBeaconsInRegion(Region region) {
        int rangedRegionCount;
        Map<Region, RangeState> map = this.rangedRegionState;
        synchronized (map) {
            this.rangedRegionState.remove(region);
            rangedRegionCount = this.rangedRegionState.size();
            BeaconManager.logDebug(TAG, "Currently ranging " + this.rangedRegionState.size() + " regions.");
        }
        if (this.scanningEnabled && rangedRegionCount == 0 && this.monitoredRegionState.size() == 0) {
            this.mCycledScanner.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startMonitoringBeaconsInRegion(Region region, Callback callback) {
        BeaconManager.logDebug(TAG, "startMonitoring called");
        Map<Region, MonitorState> map = this.monitoredRegionState;
        synchronized (map) {
            if (this.monitoredRegionState.containsKey(region)) {
                Log.i((String)TAG, (String)"Already monitoring that region -- will replace existing region monitor.");
                this.monitoredRegionState.remove(region);
            }
            this.monitoredRegionState.put(region, new MonitorState(callback));
        }
        BeaconManager.logDebug(TAG, "Currently monitoring " + this.monitoredRegionState.size() + " regions.");
        if (!this.scanningEnabled) {
            this.mCycledScanner.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopMonitoringBeaconsInRegion(Region region) {
        int monitoredRegionCount;
        BeaconManager.logDebug(TAG, "stopMonitoring called");
        Map<Region, MonitorState> map = this.monitoredRegionState;
        synchronized (map) {
            this.monitoredRegionState.remove(region);
            monitoredRegionCount = this.monitoredRegionState.size();
        }
        BeaconManager.logDebug(TAG, "Currently monitoring " + this.monitoredRegionState.size() + " regions.");
        if (this.scanningEnabled && monitoredRegionCount == 0 && this.monitoredRegionState.size() == 0) {
            this.mCycledScanner.stop();
        }
    }

    public void setScanPeriods(long scanPeriod, long betweenScanPeriod, boolean backgroundFlag) {
        this.mCycledScanner.setScanPeriods(scanPeriod, betweenScanPeriod, backgroundFlag);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processRangeData() {
        Map<Region, RangeState> map = this.rangedRegionState;
        synchronized (map) {
            for (Region region : this.rangedRegionState.keySet()) {
                RangeState rangeState = this.rangedRegionState.get(region);
                BeaconManager.logDebug(TAG, "Calling ranging callback");
                rangeState.getCallback().call((Context)this, "rangingData", new RangingData(rangeState.finalizeBeacons(), region));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processExpiredMonitors() {
        Map<Region, MonitorState> map = this.monitoredRegionState;
        synchronized (map) {
            for (Region region : this.monitoredRegionState.keySet()) {
                MonitorState state = this.monitoredRegionState.get(region);
                if (!state.isNewlyOutside()) continue;
                BeaconManager.logDebug(TAG, "found a monitor that expired: " + region);
                state.getCallback().call((Context)this, "monitoringData", new MonitoringData(state.isInside(), region));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processBeaconFromScan(Beacon beacon) {
        if (this.trackedBeacons == null) {
            this.trackedBeacons = new HashSet();
        }
        if (Stats.getInstance().isEnabled()) {
            Stats.getInstance().log(beacon);
        }
        ++this.trackedBeaconsPacketCount;
        if (this.trackedBeacons.contains(beacon)) {
            BeaconManager.logDebug(TAG, "beacon detected multiple times in scan cycle :" + beacon.toString());
        }
        this.trackedBeacons.add(beacon);
        BeaconManager.logDebug(TAG, "beacon detected :" + beacon.toString());
        List<Region> matchedRegions = null;
        Map<Region, MonitorState> map = this.monitoredRegionState;
        synchronized (map) {
            matchedRegions = this.matchingRegions(beacon, this.monitoredRegionState.keySet());
        }
        for (Region region : matchedRegions) {
            MonitorState state = this.monitoredRegionState.get(region);
            if (!state.markInside()) continue;
            state.getCallback().call((Context)this, "monitoringData", new MonitoringData(state.isInside(), region));
        }
        BeaconManager.logDebug(TAG, "looking for ranging region matches for this beacon");
        Map<Region, RangeState> map2 = this.rangedRegionState;
        synchronized (map2) {
            matchedRegions = this.matchingRegions(beacon, this.rangedRegionState.keySet());
            for (Region region : matchedRegions) {
                BeaconManager.logDebug(TAG, "matches ranging region: " + region);
                RangeState rangeState = this.rangedRegionState.get(region);
                rangeState.addBeacon(beacon);
            }
        }
    }

    private List<Region> matchingRegions(Beacon beacon, Collection<Region> regions) {
        ArrayList<Region> matched = new ArrayList<Region>();
        for (Region region : regions) {
            if (region.matchesBeacon(beacon)) {
                matched.add(region);
                continue;
            }
            BeaconManager.logDebug(TAG, "This region (" + region + ") does not match beacon: " + beacon);
        }
        return matched;
    }

    private class ScanProcessor
    extends AsyncTask<ScanData, Void, Void> {
        DetectionTracker mDetectionTracker = DetectionTracker.getInstance();

        private ScanProcessor() {
        }

        protected Void doInBackground(ScanData ... params) {
            BeaconParser parser;
            ScanData scanData = params[0];
            Beacon beacon = null;
            Iterator i$ = BeaconService.this.beaconParsers.iterator();
            while (i$.hasNext() && (beacon = (parser = (BeaconParser)i$.next()).fromScanData(scanData.scanRecord, scanData.rssi, scanData.device)) == null) {
            }
            if (beacon != null) {
                this.mDetectionTracker.recordDetection();
                BeaconService.this.processBeaconFromScan(beacon);
            }
            return null;
        }

        protected void onPostExecute(Void result) {
        }

        protected void onPreExecute() {
        }

        protected void onProgressUpdate(Void ... values) {
        }
    }

    private class ScanData {
        int rssi;
        BluetoothDevice device;
        byte[] scanRecord;

        public ScanData(BluetoothDevice device, int rssi, byte[] scanRecord) {
            this.device = device;
            this.rssi = rssi;
            this.scanRecord = scanRecord;
        }
    }

    static class IncomingHandler
    extends Handler {
        private final WeakReference<BeaconService> mService;

        IncomingHandler(BeaconService service) {
            this.mService = new WeakReference<BeaconService>(service);
        }

        public void handleMessage(Message msg) {
            BeaconService service = (BeaconService)((Object)this.mService.get());
            StartRMData startRMData = (StartRMData)msg.obj;
            if (service != null) {
                switch (msg.what) {
                    case 2: {
                        Log.i((String)BeaconService.TAG, (String)"start ranging received");
                        service.startRangingBeaconsInRegion(startRMData.getRegionData(), new Callback(startRMData.getCallbackPackageName()));
                        service.setScanPeriods(startRMData.getScanPeriod(), startRMData.getBetweenScanPeriod(), startRMData.getBackgroundFlag());
                        break;
                    }
                    case 3: {
                        Log.i((String)BeaconService.TAG, (String)"stop ranging received");
                        service.stopRangingBeaconsInRegion(startRMData.getRegionData());
                        service.setScanPeriods(startRMData.getScanPeriod(), startRMData.getBetweenScanPeriod(), startRMData.getBackgroundFlag());
                        break;
                    }
                    case 4: {
                        Log.i((String)BeaconService.TAG, (String)"start monitoring received");
                        service.startMonitoringBeaconsInRegion(startRMData.getRegionData(), new Callback(startRMData.getCallbackPackageName()));
                        service.setScanPeriods(startRMData.getScanPeriod(), startRMData.getBetweenScanPeriod(), startRMData.getBackgroundFlag());
                        break;
                    }
                    case 5: {
                        Log.i((String)BeaconService.TAG, (String)"stop monitoring received");
                        service.stopMonitoringBeaconsInRegion(startRMData.getRegionData());
                        service.setScanPeriods(startRMData.getScanPeriod(), startRMData.getBetweenScanPeriod(), startRMData.getBackgroundFlag());
                        break;
                    }
                    case 6: {
                        Log.i((String)BeaconService.TAG, (String)"set scan intervals received");
                        service.setScanPeriods(startRMData.getScanPeriod(), startRMData.getBetweenScanPeriod(), startRMData.getBackgroundFlag());
                        break;
                    }
                    default: {
                        super.handleMessage(msg);
                    }
                }
            }
        }
    }

    public class BeaconBinder
    extends Binder {
        public BeaconService getService() {
            Log.i((String)BeaconService.TAG, (String)"getService of BeaconBinder called");
            return BeaconService.this;
        }
    }
}

