/*
 * Decompiled with CFR 0.152.
 */
package org.altbeacon.beacon.powersave;

import android.annotation.TargetApi;
import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.os.Build;
import android.os.Bundle;
import android.util.Log;
import org.altbeacon.beacon.BeaconManager;

@TargetApi(value=18)
public class BackgroundPowerSaver
implements Application.ActivityLifecycleCallbacks {
    private static final String TAG = "BackgroundPowerSaver";
    private BeaconManager beaconManager;
    private int activeActivityCount = 0;

    public BackgroundPowerSaver(Context context, boolean countActiveActivityStrategy) {
        if (Build.VERSION.SDK_INT < 18) {
            Log.w((String)TAG, (String)"BackgroundPowerSaver requires SDK 18 or higher.");
            return;
        }
        if (context instanceof Application) {
            ((Application)context).registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)this);
        } else {
            Log.e((String)TAG, (String)"Context is not an application instance, so we cannot use the BackgroundPowerSaver");
        }
        this.beaconManager = BeaconManager.getInstanceForApplication(context);
    }

    public BackgroundPowerSaver(Context context) {
        this(context, false);
    }

    public void onActivityCreated(Activity activity, Bundle bundle) {
    }

    public void onActivityStarted(Activity activity) {
    }

    public void onActivityResumed(Activity activity) {
        ++this.activeActivityCount;
        if (this.activeActivityCount < 1) {
            BeaconManager.logDebug(TAG, "reset active activity count on resume.  It was " + this.activeActivityCount);
            this.activeActivityCount = 1;
        }
        this.beaconManager.setBackgroundMode(false);
        BeaconManager.logDebug(TAG, "activity resumed: " + activity + "  active activities: " + this.activeActivityCount);
    }

    public void onActivityPaused(Activity activity) {
        --this.activeActivityCount;
        BeaconManager.logDebug(TAG, "activity paused: " + activity + "  active activities: " + this.activeActivityCount);
        if (this.activeActivityCount < 1) {
            BeaconManager.logDebug(TAG, "setting background mode");
            this.beaconManager.setBackgroundMode(true);
        }
    }

    public void onActivityStopped(Activity activity) {
    }

    public void onActivitySaveInstanceState(Activity activity, Bundle bundle) {
    }

    public void onActivityDestroyed(Activity activity) {
    }
}

