/*
 * Decompiled with CFR 0.152.
 */
package alluxio.worker.block;

import alluxio.StorageTierAssoc;
import alluxio.worker.block.BlockStoreMeta;
import java.util.HashMap;
import java.util.Map;

public class BlockWorkerMetrics {
    private final long mCapacityBytes;
    private final long mUsedBytes;
    private final long mCapacityFree;
    private final Map<String, Long> mCapacityBytesOnTiers;
    private final Map<String, Long> mUsedBytesOnTiers;
    private final Map<String, Long> mFreeBytesOnTiers;
    private final int mNumberOfBlocks;

    public BlockWorkerMetrics(long capacityBytes, long usedBytes, long capacityFree, Map<String, Long> capacityBytesOnTiers, Map<String, Long> usedBytesOnTiers, Map<String, Long> freeBytesOnTiers, int numberOfBlocks) {
        this.mCapacityBytes = capacityBytes;
        this.mUsedBytes = usedBytes;
        this.mCapacityFree = capacityFree;
        this.mCapacityBytesOnTiers = capacityBytesOnTiers;
        this.mUsedBytesOnTiers = usedBytesOnTiers;
        this.mFreeBytesOnTiers = freeBytesOnTiers;
        this.mNumberOfBlocks = numberOfBlocks;
    }

    public long getCapacityBytes() {
        return this.mCapacityBytes;
    }

    public long getUsedBytes() {
        return this.mUsedBytes;
    }

    public long getCapacityFree() {
        return this.mCapacityFree;
    }

    public Map<String, Long> getCapacityBytesOnTiers() {
        return this.mCapacityBytesOnTiers;
    }

    public Map<String, Long> getUsedBytesOnTiers() {
        return this.mUsedBytesOnTiers;
    }

    public Map<String, Long> getFreeBytesOnTiers() {
        return this.mFreeBytesOnTiers;
    }

    public int getNumberOfBlocks() {
        return this.mNumberOfBlocks;
    }

    public static BlockWorkerMetrics from(BlockStoreMeta meta, StorageTierAssoc s) {
        long capacityBytes = meta.getCapacityBytes();
        long usedBytes = meta.getUsedBytes();
        long capacityFree = capacityBytes - usedBytes;
        Map<String, Long> capacityBytesOnTiers = meta.getCapacityBytesOnTiers();
        Map<String, Long> usedBytesOnTiers = meta.getUsedBytesOnTiers();
        HashMap<String, Long> freeBytesOnTiers = new HashMap<String, Long>();
        for (int i = 0; i < s.size(); ++i) {
            String tier = s.getAlias(i);
            freeBytesOnTiers.put(tier, capacityBytesOnTiers.getOrDefault(tier, 0L) - usedBytesOnTiers.getOrDefault(tier, 0L));
        }
        int numberOfBlocks = meta.getNumberOfBlocks();
        return new BlockWorkerMetrics(capacityBytes, usedBytes, capacityFree, capacityBytesOnTiers, usedBytesOnTiers, freeBytesOnTiers, numberOfBlocks);
    }
}

