/*
 * Decompiled with CFR 0.152.
 */
package alluxio.wire;

import alluxio.conf.Configuration;
import alluxio.conf.PropertyKey;
import alluxio.util.CommonUtils;
import alluxio.wire.Address;
import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public final class MasterInfo {
    private static final String NONE = "N/A";
    private Address mAddress;
    private long mId;
    private String mStartTime = "N/A";
    private String mGainPrimacyTime = "N/A";
    private String mLosePrimacyTime = "N/A";
    private String mLastUpdatedTime = "N/A";
    private String mVersion = "N/A";
    private String mRevision = "N/A";
    private String mLastCheckpointTime = "N/A";
    private long mJournalEntriesSinceCheckpoint = 0L;

    public MasterInfo() {
    }

    public MasterInfo(long id, Address address) {
        this.mAddress = (Address)Preconditions.checkNotNull((Object)address, (Object)"address");
        this.mId = id;
    }

    public Address getAddress() {
        return this.mAddress;
    }

    public long getId() {
        return this.mId;
    }

    public String getLastUpdatedTime() {
        return this.mLastUpdatedTime;
    }

    public String getStartTime() {
        return this.mStartTime;
    }

    public String getGainPrimacyTime() {
        return this.mGainPrimacyTime;
    }

    public String getLosePrimacyTime() {
        return this.mLosePrimacyTime;
    }

    public String getVersion() {
        return this.mVersion;
    }

    public String getRevision() {
        return this.mRevision;
    }

    public String getLastCheckpointTime() {
        return this.mLastCheckpointTime;
    }

    public long getJournalEntriesSinceCheckpoint() {
        return this.mJournalEntriesSinceCheckpoint;
    }

    public MasterInfo setAddress(Address address) {
        this.mAddress = address;
        return this;
    }

    public MasterInfo setId(long id) {
        this.mId = id;
        return this;
    }

    public MasterInfo setLastUpdatedTime(String lastUpdatedTime) {
        this.mLastUpdatedTime = lastUpdatedTime;
        return this;
    }

    public MasterInfo setLastUpdatedTimeMs(long lastUpdatedTime) {
        return this.setLastUpdatedTime(MasterInfo.convertMsToDate(lastUpdatedTime));
    }

    public MasterInfo setStartTime(String startTime) {
        this.mStartTime = startTime;
        return this;
    }

    public MasterInfo setStartTimeMs(long startTime) {
        return this.setStartTime(MasterInfo.convertMsToDate(startTime));
    }

    public MasterInfo setGainPrimacyTime(String gainPrimacyTime) {
        this.mGainPrimacyTime = gainPrimacyTime;
        return this;
    }

    public MasterInfo setGainPrimacyTimeMs(long gainPrimacyTimeMs) {
        return this.setGainPrimacyTime(MasterInfo.convertMsToDate(gainPrimacyTimeMs));
    }

    public MasterInfo setLosePrimacyTime(String losePrimacyTime) {
        this.mLosePrimacyTime = losePrimacyTime;
        return this;
    }

    public MasterInfo setLosePrimacyTimeMs(long losePrimacyTimeMs) {
        return this.setLosePrimacyTime(MasterInfo.convertMsToDate(losePrimacyTimeMs));
    }

    public MasterInfo setVersion(String version) {
        this.mVersion = version;
        return this;
    }

    public MasterInfo setRevision(String revision) {
        this.mRevision = revision;
        return this;
    }

    public MasterInfo setLastCheckpointTime(String lastCheckpointTime) {
        this.mLastCheckpointTime = lastCheckpointTime;
        return this;
    }

    public MasterInfo setLastCheckpointTimeMs(long lastCheckpointTime) {
        return this.setLastCheckpointTime(MasterInfo.convertMsToDate(lastCheckpointTime));
    }

    public MasterInfo setJournalEntriesSinceCheckpoint(long journalEntriesSinceCheckpoint) {
        this.mJournalEntriesSinceCheckpoint = journalEntriesSinceCheckpoint;
        return this;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("id", this.mId).add("address", (Object)this.mAddress).add("lastUpdatedTime", (Object)this.mLastUpdatedTime).add("startTime", (Object)this.mStartTime).add("gainPrimacyTime", (Object)this.mGainPrimacyTime).add("losePrimacyTime", (Object)this.mLosePrimacyTime).add("lastCheckpointTime", (Object)this.mLastCheckpointTime).add("journalEntriesSinceCheckpoint", this.mJournalEntriesSinceCheckpoint).add("version", (Object)this.mVersion).add("revision", (Object)this.mRevision).toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MasterInfo)) {
            return false;
        }
        MasterInfo that = (MasterInfo)o;
        return this.mId == that.mId && Objects.equal((Object)this.mAddress, (Object)that.mAddress) && this.mLastUpdatedTime.equals(that.mLastUpdatedTime) && this.mStartTime.equals(that.mStartTime) && this.mGainPrimacyTime.equals(that.mGainPrimacyTime) && this.mLosePrimacyTime.equals(that.mLosePrimacyTime) && this.mLastCheckpointTime.equals(that.mLastCheckpointTime) && this.mJournalEntriesSinceCheckpoint == that.mJournalEntriesSinceCheckpoint && this.mVersion.equals(that.mVersion) && this.mRevision.equals(that.mRevision);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.mId, this.mAddress, this.mLastUpdatedTime, this.mStartTime, this.mGainPrimacyTime, this.mLosePrimacyTime, this.mLastCheckpointTime, this.mJournalEntriesSinceCheckpoint, this.mVersion, this.mRevision});
    }

    private static String convertMsToDate(long timeMs) {
        if (timeMs <= 0L) {
            return NONE;
        }
        return CommonUtils.convertMsToDate(timeMs, Configuration.getString(PropertyKey.USER_DATE_FORMAT_PATTERN));
    }
}

