/*
 * Decompiled with CFR 0.152.
 */
package alluxio.wire;

import alluxio.conf.Source;
import alluxio.grpc.ConfigProperties;
import alluxio.grpc.GetConfigurationPResponse;
import alluxio.wire.Property;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public final class Configuration {
    private final List<Property> mClusterConf;
    private final Map<String, List<Property>> mPathConf;
    private final String mClusterConfHash;
    private final String mPathConfHash;
    private final long mClusterConfLastUpdateTime;
    private final long mPathConfLastUpdateTime;

    public static Builder newBuilder() {
        return new Builder();
    }

    private Configuration(List<Property> clusterConf, Map<String, List<Property>> pathConf, String clusterConfHash, String pathConfHash, long clusterConfLastUpdateTime, long pathConfLastUpdateTime) {
        this.mClusterConf = clusterConf;
        this.mPathConf = pathConf;
        this.mClusterConfHash = clusterConfHash;
        this.mPathConfHash = pathConfHash;
        this.mClusterConfLastUpdateTime = clusterConfLastUpdateTime;
        this.mPathConfLastUpdateTime = pathConfLastUpdateTime;
    }

    private Configuration(GetConfigurationPResponse conf) {
        this.mClusterConf = conf.getClusterConfigsList().stream().map(Property::fromProto).collect(Collectors.toList());
        Map pathConf = conf.getPathConfigsMap();
        this.mPathConf = new HashMap<String, List<Property>>(pathConf.size());
        pathConf.forEach((path, prop) -> {
            ArrayList properties = new ArrayList(prop.getPropertiesCount());
            prop.getPropertiesList().forEach(p -> properties.add(Property.fromProto(p)));
            this.mPathConf.put((String)path, properties);
        });
        this.mClusterConfHash = conf.getClusterConfigHash();
        this.mPathConfHash = conf.getPathConfigHash();
        this.mClusterConfLastUpdateTime = conf.getClusterConfigLastUpdateTime();
        this.mPathConfLastUpdateTime = conf.getPathConfigLastUpdateTime();
    }

    public static Configuration fromProto(GetConfigurationPResponse conf) {
        return new Configuration(conf);
    }

    public GetConfigurationPResponse toProto() {
        GetConfigurationPResponse.Builder response = GetConfigurationPResponse.newBuilder();
        if (this.mClusterConf != null) {
            this.mClusterConf.forEach(property -> response.addClusterConfigs(property.toProto()));
        }
        if (this.mPathConf != null) {
            this.mPathConf.forEach((path, properties) -> {
                List propertyList = properties.stream().map(Property::toProto).collect(Collectors.toList());
                ConfigProperties configProperties = ConfigProperties.newBuilder().addAllProperties(propertyList).build();
                response.putPathConfigs(path, configProperties);
            });
        }
        if (this.mClusterConfHash != null) {
            response.setClusterConfigHash(this.mClusterConfHash);
        }
        if (this.mPathConfHash != null) {
            response.setPathConfigHash(this.mPathConfHash);
        }
        response.setClusterConfigLastUpdateTime(this.mClusterConfLastUpdateTime);
        response.setPathConfigLastUpdateTime(this.mPathConfLastUpdateTime);
        return response.build();
    }

    public List<Property> getClusterConf() {
        return this.mClusterConf;
    }

    public Map<String, List<Property>> getPathConf() {
        return this.mPathConf;
    }

    public String getClusterConfHash() {
        return this.mClusterConfHash;
    }

    public String getPathConfHash() {
        return this.mPathConfHash;
    }

    public long getClusterConfLastUpdateTime() {
        return this.mClusterConfLastUpdateTime;
    }

    public long getPathConfLastUpdateTime() {
        return this.mPathConfLastUpdateTime;
    }

    @NotThreadSafe
    public static final class Builder {
        private List<Property> mClusterConf = new ArrayList<Property>();
        private Map<String, List<Property>> mPathConf = new HashMap<String, List<Property>>();
        private String mClusterConfHash;
        private String mPathConfHash;
        private long mClusterConfLastUpdateTime;
        private long mPathConfLastUpdateTime;

        public void addClusterProperty(String name, @Nullable Object value, Source source) {
            this.mClusterConf.add(new Property(name, value, source));
        }

        public void addPathProperty(String path, String name, String value) {
            this.mPathConf.computeIfAbsent(path, k -> new ArrayList()).add(new Property(name, value, Source.PATH_DEFAULT));
        }

        public void setClusterConfHash(String hash) {
            Preconditions.checkNotNull((Object)hash, (Object)"hash");
            this.mClusterConfHash = hash;
        }

        public void setPathConfHash(String hash) {
            Preconditions.checkNotNull((Object)hash, (Object)"hash");
            this.mPathConfHash = hash;
        }

        public void setClusterConfLastUpdateTime(long lastUpdateTime) {
            this.mClusterConfLastUpdateTime = lastUpdateTime;
        }

        public void setPathConfLastUpdateTime(long lastUpdateTime) {
            this.mPathConfLastUpdateTime = lastUpdateTime;
        }

        public Configuration build() {
            return new Configuration(this.mClusterConf, this.mPathConf, this.mClusterConfHash, this.mPathConfHash, this.mClusterConfLastUpdateTime, this.mPathConfLastUpdateTime);
        }
    }
}

