/*
 * Decompiled with CFR 0.152.
 */
package alluxio.util.io;

import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.WritableByteChannel;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;

public class ChannelAdapters {
    private ChannelAdapters() {
    }

    public static WritableByteChannel intoByteBuffer(ByteBuffer output) {
        return new ByteBufferWritableChannel(output);
    }

    public static WritableByteChannel intoByteArray(byte[] output) {
        return ChannelAdapters.intoByteBuffer(ByteBuffer.wrap(output));
    }

    public static WritableByteChannel intoByteArray(byte[] output, int offset, int length) {
        return ChannelAdapters.intoByteBuffer(ByteBuffer.wrap(output, offset, length));
    }

    public static WritableByteChannel intoByteBuf(ByteBuf output) {
        throw new UnsupportedOperationException("todo");
    }

    @ThreadSafe
    static class ByteBufferWritableChannel
    implements WritableByteChannel {
        @GuardedBy(value="this")
        private final ByteBuffer mOutput;
        private boolean mClosed = false;

        ByteBufferWritableChannel(ByteBuffer byteBuffer) {
            this.mOutput = byteBuffer;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int write(ByteBuffer src) throws IOException {
            if (this.mClosed) {
                throw new ClosedChannelException();
            }
            ByteBufferWritableChannel byteBufferWritableChannel = this;
            synchronized (byteBufferWritableChannel) {
                int srcRemaining = src.remaining();
                int outputRemaining = this.mOutput.remaining();
                if (outputRemaining == 0 && srcRemaining > 0) {
                    throw new ClosedChannelException();
                }
                int bytesToCopy = Math.min(srcRemaining, outputRemaining);
                ByteBuffer slice = src.slice();
                slice.limit(bytesToCopy);
                this.mOutput.put(slice);
                src.position(src.position() + bytesToCopy);
                return bytesToCopy;
            }
        }

        @Override
        public boolean isOpen() {
            return !this.mClosed;
        }

        @Override
        public void close() throws IOException {
            if (!this.mClosed) {
                this.mClosed = true;
            }
        }
    }
}

