/*
 * Decompiled with CFR 0.152.
 */
package alluxio.uri;

import alluxio.AlluxioURI;
import alluxio.uri.Authority;
import alluxio.uri.URI;
import alluxio.util.URIUtils;
import java.net.URISyntaxException;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public class StandardURI
implements URI {
    private static final long serialVersionUID = 3705239942914676079L;
    protected final String mScheme;
    protected final String mSchemeSpecificPart;
    protected final Authority mAuthority;
    protected final String mPath;
    protected final String mQuery;
    protected int mHashCode;

    public StandardURI(String scheme, Authority authority, String path, String query) {
        try {
            java.net.URI uri = ".".equals(path) ? new java.net.URI(scheme, authority.toString().equals("") ? null : authority.toString(), AlluxioURI.normalizePath(path), query, null) : new java.net.URI(scheme, authority.toString().equals("") ? null : authority.toString(), AlluxioURI.normalizePath(path), query, null).normalize();
            this.mScheme = uri.getScheme();
            this.mSchemeSpecificPart = uri.getSchemeSpecificPart();
            this.mAuthority = authority;
            this.mPath = uri.getPath();
            this.mQuery = uri.getQuery();
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e);
        }
    }

    protected StandardURI(URI baseUri, String newPath) {
        this.mScheme = baseUri.getScheme();
        this.mSchemeSpecificPart = baseUri.getSchemeSpecificPart();
        this.mAuthority = baseUri.getAuthority();
        this.mPath = AlluxioURI.normalizePath(newPath);
        this.mQuery = baseUri.getQuery();
    }

    @Override
    public URI createNewPath(String newPath, boolean checkNormalization) {
        if (checkNormalization && URIUtils.needsNormalization(newPath)) {
            return new StandardURI(this.mScheme, this.mAuthority, newPath, this.mQuery);
        }
        return new StandardURI(this, newPath);
    }

    @Override
    public Authority getAuthority() {
        return this.mAuthority;
    }

    @Override
    public String getPath() {
        return this.mPath;
    }

    @Override
    public String getQuery() {
        return this.mQuery;
    }

    @Override
    public String getScheme() {
        return this.mScheme;
    }

    @Override
    public String getSchemeSpecificPart() {
        return this.mSchemeSpecificPart;
    }

    @Override
    public boolean isAbsolute() {
        return this.getScheme() != null;
    }

    @Override
    public int compareTo(URI other) {
        int compare = this.compareScheme(other);
        if (compare != 0) {
            return compare;
        }
        if (this.mPath == null) {
            if (other.getPath() == null) {
                compare = URIUtils.compare(this.mSchemeSpecificPart, other.getSchemeSpecificPart());
                if (compare != 0) {
                    return compare;
                }
                return 0;
            }
            return 1;
        }
        if (other.getPath() == null) {
            return -1;
        }
        compare = this.mAuthority.compareTo(other.getAuthority());
        if (compare != 0) {
            return compare;
        }
        compare = URIUtils.compare(this.mPath, other.getPath());
        if (compare != 0) {
            return compare;
        }
        compare = URIUtils.compare(this.mQuery, other.getQuery());
        if (compare != 0) {
            return compare;
        }
        return 0;
    }

    private int compareScheme(URI other) {
        String scheme = this.getScheme();
        String otherScheme = other.getScheme();
        if (scheme == null && otherScheme == null) {
            return 0;
        }
        if (scheme != null) {
            if (otherScheme != null) {
                return scheme.compareToIgnoreCase(otherScheme);
            }
            return 1;
        }
        return -1;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof StandardURI)) {
            return false;
        }
        StandardURI that = (StandardURI)o;
        if (this.compareScheme(that) != 0) {
            return false;
        }
        if (this.mPath == null && that.mPath != null || this.mPath != null && that.mPath == null) {
            return false;
        }
        if (this.mPath == null) {
            return URIUtils.equals(this.mSchemeSpecificPart, that.mSchemeSpecificPart);
        }
        return URIUtils.equals(this.mPath, that.mPath) && URIUtils.equals(this.mQuery, that.mQuery) && this.mAuthority.equals(that.mAuthority);
    }

    public int hashCode() {
        if (this.mHashCode != 0) {
            return this.mHashCode;
        }
        int hashCode = URIUtils.hashIgnoreCase(0, this.getScheme());
        if (this.mPath == null) {
            hashCode = URIUtils.hash(hashCode, this.mSchemeSpecificPart);
        } else {
            hashCode = URIUtils.hash(hashCode, this.mPath);
            hashCode = URIUtils.hash(hashCode, this.mQuery);
            hashCode = URIUtils.hash(hashCode, this.mAuthority.toString());
        }
        this.mHashCode = hashCode;
        return hashCode;
    }
}

