/*
 * Decompiled with CFR 0.152.
 */
package alluxio.thread;

import alluxio.util.ExceptionUtils;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AutopsyThread
extends Thread {
    private static final Logger LOG = LoggerFactory.getLogger(AutopsyThread.class);
    private final AtomicReference<Throwable> mThrowable = new AtomicReference<Object>(null);

    public AutopsyThread() {
        this.setUncaughtExceptionHandler((thread, t) -> this.onError(t));
    }

    public boolean crashed() {
        return this.mThrowable.get() != null;
    }

    public void setError(Throwable t) {
        this.mThrowable.set(t);
    }

    public void onError(Throwable t) {
        if (ExceptionUtils.containsInterruptedException(t)) {
            LOG.warn("Thread {} interrupted, assume the master is failing over or shutting down", (Object)Thread.currentThread().getId());
            return;
        }
        LOG.error("Uncaught exception from thread {}", (Object)Thread.currentThread().getId(), (Object)t);
        this.setError(t);
    }

    @Nullable
    public Throwable getError() {
        return this.mThrowable.get();
    }
}

