/*
 * Decompiled with CFR 0.152.
 */
package alluxio.metrics;

import alluxio.grpc.Metric;
import alluxio.grpc.MetricType;
import alluxio.metrics.MetricsSystem;
import alluxio.util.CommonUtils;
import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.AtomicDouble;
import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;

public final class Metric
implements Serializable {
    private static final long serialVersionUID = -2236393414222298333L;
    public static final String TAG_SEPARATOR = ":";
    private static final ConcurrentHashMap<UserMetricKey, String> CACHED_METRICS = new ConcurrentHashMap();
    private final MetricsSystem.InstanceType mInstanceType;
    private final String mSource;
    private final String mName;
    private final MetricType mMetricType;
    private final Map<String, String> mTags;
    private final Supplier<String> mFullMetricNameSupplier = CommonUtils.memoize(this::constructFullMetricName);
    private AtomicDouble mValue;

    public Metric(MetricsSystem.InstanceType instanceType, String source, MetricType metricType, String name, Double value) {
        Preconditions.checkNotNull((Object)name, (Object)"name");
        this.mInstanceType = instanceType;
        this.mSource = source;
        this.mMetricType = metricType;
        this.mName = name;
        this.mValue = new AtomicDouble(value.doubleValue());
        this.mTags = new LinkedHashMap<String, String>();
    }

    public void addValue(double delta) {
        this.mValue.addAndGet(delta);
    }

    public void setValue(double value) {
        this.mValue.set(value);
    }

    public double getValue() {
        return this.mValue.get();
    }

    public MetricsSystem.InstanceType getInstanceType() {
        return this.mInstanceType;
    }

    public void addTag(String name, String value) {
        this.mTags.put(name, value);
    }

    public String getSource() {
        return this.mSource;
    }

    public MetricType getMetricType() {
        return this.mMetricType;
    }

    public String getName() {
        return this.mName;
    }

    public Map<String, String> getTags() {
        return this.mTags;
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (!(other instanceof Metric)) {
            return false;
        }
        Metric metric = (Metric)other;
        return Objects.equal((Object)this.getFullMetricName(), (Object)metric.getFullMetricName()) && Objects.equal((Object)this.mValue.get(), (Object)metric.mValue.get());
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.getFullMetricName(), this.mValue.get()});
    }

    public String getFullMetricName() {
        return this.mFullMetricNameSupplier.get();
    }

    private String constructFullMetricName() {
        StringBuilder sb = new StringBuilder();
        sb.append((Object)this.mInstanceType).append('.');
        sb.append(this.mName);
        for (Map.Entry<String, String> entry : this.mTags.entrySet()) {
            sb.append('.').append(entry.getKey()).append(TAG_SEPARATOR).append(entry.getValue());
        }
        if (this.mSource != null) {
            sb.append('.');
            sb.append(this.mSource);
        }
        return sb.toString();
    }

    public alluxio.grpc.Metric toProto() {
        Metric.Builder metric = alluxio.grpc.Metric.newBuilder();
        metric.setInstance(this.mInstanceType.toString()).setMetricType(this.mMetricType).setName(this.mName).setValue(this.mValue.get()).putAllTags(this.mTags);
        if (!this.mSource.isEmpty()) {
            metric.setSource(this.mSource);
        }
        return metric.build();
    }

    public static String getMetricNameWithTags(String name, String ... tags) {
        Preconditions.checkArgument((tags.length % 2 == 0 ? 1 : 0) != 0, (Object)"The tag arguments should be tag name and tag value pairs");
        StringBuilder sb = new StringBuilder();
        sb.append(name);
        for (int i = 0; i < tags.length; i += 2) {
            sb.append('.').append(tags[i]).append(TAG_SEPARATOR).append(tags[i + 1]);
        }
        return sb.toString();
    }

    public static String getMetricNameWithUserTag(String metricName, String userName) {
        UserMetricKey k = new UserMetricKey(metricName, userName);
        String result = CACHED_METRICS.get(k);
        if (result != null) {
            return result;
        }
        return CACHED_METRICS.computeIfAbsent(k, key -> metricName + "." + "User" + TAG_SEPARATOR + userName);
    }

    public static String getTagUfsValueFromFullName(String fullName) {
        String[] pieces = fullName.split("\\.");
        if (pieces.length < 3) {
            return null;
        }
        for (int i = 2; i < pieces.length; ++i) {
            String current = pieces[i];
            if (!current.contains(TAG_SEPARATOR) || !current.contains("UFS")) continue;
            return current.substring(current.indexOf(TAG_SEPARATOR) + 1);
        }
        return null;
    }

    public static String getBaseName(String fullName) {
        String[] pieces = fullName.split("\\.");
        if (pieces.length < 2) {
            return fullName;
        }
        return pieces[0] + "." + pieces[1];
    }

    public static Metric from(String fullName, double value, MetricType metricType) {
        String[] pieces = fullName.split("\\.");
        Preconditions.checkArgument((pieces.length > 1 ? 1 : 0) != 0, (String)"Incorrect metrics name: %s.", (Object)fullName);
        int len = pieces.length;
        String source = null;
        int tagEndIndex = len;
        if (!pieces[0].equals(MetricsSystem.InstanceType.MASTER.toString()) && !pieces[0].equals("Cluster")) {
            source = pieces[len - 1];
            tagEndIndex = len - 1;
        }
        MetricsSystem.InstanceType instance = MetricsSystem.InstanceType.fromString(pieces[0]);
        Metric metric = new Metric(instance, source, metricType, pieces[1], value);
        for (int i = 2; i < tagEndIndex; ++i) {
            String tagStr = pieces[i];
            if (!tagStr.contains(TAG_SEPARATOR)) continue;
            int tagSeparatorIdx = tagStr.indexOf(TAG_SEPARATOR);
            metric.addTag(tagStr.substring(0, tagSeparatorIdx), tagStr.substring(tagSeparatorIdx + 1));
        }
        return metric;
    }

    public static Metric fromProto(alluxio.grpc.Metric metric) {
        Metric created = new Metric(MetricsSystem.InstanceType.fromString(metric.getInstance()), metric.getSource(), metric.getMetricType(), metric.getName(), metric.getValue());
        for (Map.Entry entry : metric.getTagsMap().entrySet()) {
            created.addTag((String)entry.getKey(), (String)entry.getValue());
        }
        return created;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("source", (Object)this.mSource).add("instanceType", (Object)this.mInstanceType).add("metricType", (Object)this.mMetricType).add("name", (Object)this.mName).add("tags", this.mTags).add("value", this.mValue.get()).toString();
    }

    private static class UserMetricKey {
        private String mMetric;
        private String mUser;

        private UserMetricKey(String metricName, String userName) {
            this.mMetric = metricName;
            this.mUser = userName;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof UserMetricKey)) {
                return false;
            }
            UserMetricKey that = (UserMetricKey)o;
            return Objects.equal((Object)this.mMetric, (Object)that.mMetric) && Objects.equal((Object)this.mUser, (Object)that.mUser);
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.mMetric, this.mUser});
        }
    }
}

