/*
 * Decompiled with CFR 0.152.
 */
package alluxio.metrics;

import com.codahale.metrics.Reservoir;
import com.codahale.metrics.Snapshot;
import java.io.OutputStream;
import java.util.concurrent.atomic.LongAccumulator;

public class MaxReservoir
implements Reservoir {
    private final Reservoir mDelegate;
    private final LongAccumulator mMaxUpdate = new LongAccumulator(Long::max, 0L);

    public MaxReservoir(Reservoir delegate) {
        this.mDelegate = delegate;
    }

    public int size() {
        return this.mDelegate.size();
    }

    public void update(long value) {
        this.mMaxUpdate.accumulate(value);
        this.mDelegate.update(value);
    }

    public Snapshot getSnapshot() {
        return new MaxSnapshot(this.mDelegate.getSnapshot(), this.mMaxUpdate.get());
    }

    private static class MaxSnapshot
    extends Snapshot {
        private final Snapshot mDelegate;
        private final long mMax;

        private MaxSnapshot(Snapshot delegate, long max) {
            this.mDelegate = delegate;
            this.mMax = max;
        }

        public double getValue(double quantile) {
            return this.mDelegate.getValue(quantile);
        }

        public long[] getValues() {
            return this.mDelegate.getValues();
        }

        public int size() {
            return this.mDelegate.size();
        }

        public long getMax() {
            return this.mMax;
        }

        public double getMean() {
            return this.mDelegate.getMean();
        }

        public long getMin() {
            return this.mDelegate.getMin();
        }

        public double getStdDev() {
            return this.mDelegate.getStdDev();
        }

        public void dump(OutputStream output) {
            this.mDelegate.dump(output);
        }
    }
}

