/*
 * Decompiled with CFR 0.152.
 */
package alluxio.master.metastore.rocks;

import alluxio.master.metastore.rocks.RocksSharedLockHandle;
import alluxio.resource.CloseableIterator;
import com.google.common.primitives.Longs;
import java.util.Iterator;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import org.rocksdb.RocksIterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RocksUtils {
    private static final Logger LOG = LoggerFactory.getLogger(RocksUtils.class);

    private RocksUtils() {
    }

    public static byte[] toByteArray(long long1, long long2) {
        int i;
        byte[] key = new byte[16];
        for (i = 7; i >= 0; --i) {
            key[i] = (byte)(long1 & 0xFFL);
            long1 >>= 8;
        }
        for (i = 15; i >= 8; --i) {
            key[i] = (byte)(long2 & 0xFFL);
            long2 >>= 8;
        }
        return key;
    }

    public static byte[] toByteArray(long n, String str) {
        byte[] strBytes = str.getBytes();
        byte[] key = new byte[8 + strBytes.length];
        for (int i = 7; i >= 0; --i) {
            key[i] = (byte)(n & 0xFFL);
            n >>= 8;
        }
        System.arraycopy(strBytes, 0, key, 8, strBytes.length);
        return key;
    }

    public static long readLong(byte[] bytes, int start) {
        return Longs.fromBytes((byte)bytes[start], (byte)bytes[start + 1], (byte)bytes[start + 2], (byte)bytes[start + 3], (byte)bytes[start + 4], (byte)bytes[start + 5], (byte)bytes[start + 6], (byte)bytes[start + 7]);
    }

    public static <T> CloseableIterator<T> createCloseableIterator(final RocksIterator rocksIterator, final RocksIteratorParser<T> parser, final Supplier<Void> abortCheck, RocksSharedLockHandle rocksDbSharedLock) {
        rocksIterator.seekToFirst();
        final AtomicBoolean valid = new AtomicBoolean(true);
        Iterator iter = new Iterator<T>(){

            @Override
            public boolean hasNext() {
                return valid.get() && rocksIterator.isValid();
            }

            @Override
            public T next() {
                boolean succeeded = false;
                abortCheck.get();
                try {
                    Object result = parser.next(rocksIterator);
                    rocksIterator.next();
                    succeeded = true;
                    Object t = result;
                    return t;
                }
                catch (Exception exc) {
                    LOG.warn("Iteration aborted because of error", (Throwable)exc);
                    throw new RuntimeException(exc);
                }
                finally {
                    if (!succeeded) {
                        valid.set(false);
                        rocksIterator.close();
                    }
                }
            }
        };
        return CloseableIterator.create(iter, whatever -> {
            try {
                rocksIterator.close();
            }
            finally {
                if (rocksDbSharedLock != null) {
                    rocksDbSharedLock.close();
                }
            }
        });
    }

    public static interface RocksIteratorParser<T> {
        public T next(RocksIterator var1) throws Exception;
    }
}

