/*
 * Decompiled with CFR 0.152.
 */
package alluxio.file;

import alluxio.file.ReadTargetBuffer;
import alluxio.util.io.ChannelAdapters;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;

public class ByteBufferTargetBuffer
implements ReadTargetBuffer {
    private final ByteBuffer mTarget;

    public ByteBufferTargetBuffer(ByteBuffer target) {
        this.mTarget = target;
    }

    @Override
    public byte[] byteArray() {
        if (this.mTarget.hasArray()) {
            return this.mTarget.array();
        }
        throw new UnsupportedOperationException("ByteBuffer is not backed by an array");
    }

    @Override
    public ByteBuffer byteBuffer() {
        return this.mTarget;
    }

    @Override
    public int offset() {
        return this.mTarget.position();
    }

    @Override
    public void offset(int newOffset) {
        this.mTarget.position(newOffset);
    }

    @Override
    public WritableByteChannel byteChannel() {
        return ChannelAdapters.intoByteBuffer(this.mTarget);
    }

    @Override
    public long remaining() {
        return this.mTarget.remaining();
    }

    @Override
    public void writeBytes(byte[] srcArray, int srcOffset, int length) {
        this.mTarget.put(srcArray, srcOffset, length);
    }

    @Override
    public void writeBytes(ByteBuf buf) {
        if (this.mTarget.remaining() <= buf.readableBytes()) {
            buf.readBytes(this.mTarget);
            return;
        }
        int oldLimit = this.mTarget.limit();
        this.mTarget.limit(this.mTarget.position() + buf.readableBytes());
        buf.readBytes(this.mTarget);
        this.mTarget.limit(oldLimit);
    }

    @Override
    public int readFromFile(RandomAccessFile file, int length) throws IOException {
        int bytesToRead = Math.min(length, this.mTarget.remaining());
        ByteBuffer slice = this.mTarget.slice();
        slice.limit(bytesToRead);
        int bytesRead = file.getChannel().read(slice);
        if (bytesRead > 0) {
            this.mTarget.position(this.mTarget.position() + bytesRead);
        }
        return bytesRead;
    }

    @Override
    public int readFromInputStream(InputStream is, int length) throws IOException {
        int bytesToRead = Math.min(length, this.mTarget.remaining());
        ReadableByteChannel source = Channels.newChannel(is);
        ByteBuffer slice = this.mTarget.slice();
        slice.limit(bytesToRead);
        int bytesRead = source.read(slice);
        if (bytesRead > 0) {
            this.mTarget.position(this.mTarget.position() + bytesRead);
        }
        return bytesRead;
    }
}

