/*
 * Decompiled with CFR 0.152.
 */
package alluxio.conf;

import alluxio.conf.AlluxioConfiguration;
import alluxio.conf.AlluxioProperties;
import alluxio.conf.ConfigurationValueOptions;
import alluxio.conf.InstancedConfiguration;
import alluxio.conf.PropertyKey;
import alluxio.conf.Source;
import com.google.common.collect.ImmutableMap;
import java.time.Duration;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public class OverlayConfiguration
implements AlluxioConfiguration {
    private final AlluxioConfiguration mOuterConf;
    private final AlluxioConfiguration mInnerConf;
    private final Set<PropertyKey> mKeySet;
    private final Set<PropertyKey> mUserKeySet;

    public OverlayConfiguration(AlluxioConfiguration outerConf, AlluxioConfiguration innerConf) {
        this.mOuterConf = outerConf;
        this.mInnerConf = innerConf;
        this.mUserKeySet = new HashSet<PropertyKey>();
        this.mUserKeySet.addAll(outerConf.userKeySet());
        this.mUserKeySet.addAll(innerConf.userKeySet());
        this.mKeySet = new HashSet<PropertyKey>();
        this.mKeySet.addAll(innerConf.keySet());
        this.mKeySet.addAll(outerConf.keySet());
    }

    private AlluxioConfiguration conf(PropertyKey key) {
        return this.mOuterConf.isSetByUser(key) ? this.mOuterConf : this.mInnerConf;
    }

    @Override
    public Object get(PropertyKey key) {
        return this.conf(key).get(key);
    }

    @Override
    public Object get(PropertyKey key, ConfigurationValueOptions options) {
        return this.conf(key).get(key, options);
    }

    @Override
    public boolean isSet(PropertyKey key) {
        return this.conf(key).isSet(key);
    }

    @Override
    public boolean isSetByUser(PropertyKey key) {
        return this.conf(key).isSetByUser(key);
    }

    @Override
    public Set<PropertyKey> keySet() {
        return this.mKeySet;
    }

    @Override
    public Set<PropertyKey> userKeySet() {
        return this.mUserKeySet;
    }

    @Override
    public String getString(PropertyKey key) {
        return this.conf(key).getString(key);
    }

    @Override
    public int getInt(PropertyKey key) {
        return this.conf(key).getInt(key);
    }

    @Override
    public long getLong(PropertyKey key) {
        return this.conf(key).getLong(key);
    }

    @Override
    public double getDouble(PropertyKey key) {
        return this.conf(key).getDouble(key);
    }

    @Override
    public boolean getBoolean(PropertyKey key) {
        return this.conf(key).getBoolean(key);
    }

    @Override
    public List<String> getList(PropertyKey key) {
        return this.conf(key).getList(key);
    }

    @Override
    public <T extends Enum<T>> T getEnum(PropertyKey key, Class<T> enumType) {
        return this.conf(key).getEnum(key, enumType);
    }

    @Override
    public long getBytes(PropertyKey key) {
        return this.conf(key).getBytes(key);
    }

    @Override
    public long getMs(PropertyKey key) {
        return this.conf(key).getMs(key);
    }

    @Override
    public Duration getDuration(PropertyKey key) {
        return this.conf(key).getDuration(key);
    }

    @Override
    public <T> Class<T> getClass(PropertyKey key) {
        return this.conf(key).getClass(key);
    }

    @Override
    public Map<String, Object> getNestedProperties(PropertyKey prefixKey) {
        return this.conf(prefixKey).getNestedProperties(prefixKey);
    }

    @Override
    public AlluxioProperties copyProperties() {
        AlluxioProperties properties = this.mInnerConf.copyProperties();
        for (PropertyKey key : this.mOuterConf.userKeySet()) {
            properties.put(key, this.mOuterConf.get(key), Source.RUNTIME);
        }
        return properties;
    }

    @Override
    public Source getSource(PropertyKey key) {
        return this.conf(key).getSource(key);
    }

    @Override
    public Map<String, Object> toMap(ConfigurationValueOptions opts) {
        ImmutableMap.Builder map = ImmutableMap.builder();
        this.keySet().forEach(key -> map.put((Object)key.getName(), this.conf((PropertyKey)key).getOrDefault((PropertyKey)key, null, opts)));
        return map.build();
    }

    @Override
    public void validate() {
        new InstancedConfiguration(this.copyProperties()).validate();
    }

    @Override
    public boolean clusterDefaultsLoaded() {
        return this.mInnerConf.clusterDefaultsLoaded();
    }
}

