/*
 * Decompiled with CFR 0.152.
 */
package alluxio.conf;

import alluxio.conf.Deprecated;
import alluxio.conf.PropertyKey;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Matcher;
import javax.annotation.Nullable;

public class DeprecatedKeyChecker {
    private static final Class<PropertyKey.Template> TEMPLATE_CLASS = PropertyKey.Template.class;
    private static final Class<PropertyKey> KEY_CLASS = PropertyKey.class;
    private Map<PropertyKey, Deprecated> mAnnotatedKeys;
    private Map<PropertyKey.Template, Deprecated> mAnnotatedTemplates;
    private AtomicBoolean mInitialized = new AtomicBoolean(false);

    private static <T> Map<T, Deprecated> populateAnnotatedKeyMap(Class<T> searchType) {
        HashMap<T, Deprecated> annotations = new HashMap<T, Deprecated>();
        for (Field field : searchType.getDeclaredFields()) {
            if (!field.getType().equals(searchType)) continue;
            Deprecated keyAnnotation = field.getAnnotation(Deprecated.class);
            try {
                T key = searchType.cast(field.get(null));
                if (keyAnnotation == null) continue;
                annotations.put(key, keyAnnotation);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }
        return annotations;
    }

    private Deprecated getKeyAnnotation(PropertyKey key) {
        if (!this.mInitialized.get()) {
            this.initialize();
        }
        if (this.mAnnotatedKeys.containsKey(key)) {
            return this.mAnnotatedKeys.get(key);
        }
        for (Map.Entry<PropertyKey.Template, Deprecated> e : this.mAnnotatedTemplates.entrySet()) {
            Matcher match = e.getKey().match(key.getName());
            if (!match.matches()) continue;
            return e.getValue();
        }
        return null;
    }

    private void initialize() {
        if (!this.mInitialized.getAndSet(true)) {
            this.mAnnotatedKeys = DeprecatedKeyChecker.populateAnnotatedKeyMap(KEY_CLASS);
            this.mAnnotatedTemplates = DeprecatedKeyChecker.populateAnnotatedKeyMap(TEMPLATE_CLASS);
        }
    }

    public boolean hasAnnotation(PropertyKey key) {
        return this.getKeyAnnotation(key) != null;
    }

    @Nullable
    public Deprecated getAnnotation(PropertyKey key) {
        return this.getKeyAnnotation(key);
    }
}

