/*
 * Decompiled with CFR 0.152.
 */
package alluxio.cli;

import alluxio.cli.ValidationResults;
import alluxio.cli.ValidationTask;
import alluxio.cli.ValidationTaskResult;
import alluxio.cli.ValidationUtils;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public interface ValidationTool {
    public Map<String, ValidationTask> getTasks();

    public List<ValidationTaskResult> runAllTests() throws InterruptedException;

    public static ValidationResults convertResults(List<ValidationTaskResult> results) {
        HashMap<ValidationUtils.State, List<ValidationTaskResult>> map = new HashMap<ValidationUtils.State, List<ValidationTaskResult>>();
        results.forEach(r -> map.computeIfAbsent(r.getState(), k -> new ArrayList()).add(r));
        ValidationResults finalResults = new ValidationResults();
        finalResults.setResult(map);
        return finalResults;
    }

    public static String toJson(ValidationResults map) {
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        return gson.toJson((Object)map);
    }
}

