/*
 * Decompiled with CFR 0.152.
 */
package alluxio.wire;

import alluxio.wire.TieredIdentity;
import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Arrays;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public final class WorkerNetAddress
implements Serializable {
    private static final long serialVersionUID = 0L;
    private String mHost = "";
    private int mRpcPort;
    private int mDataPort;
    private int mWebPort;
    private String mDomainSocketPath = "";
    private TieredIdentity mTieredIdentity;

    @ApiModelProperty(value="Host name of the worker")
    public String getHost() {
        return this.mHost;
    }

    @ApiModelProperty(value="Port of the worker's Rpc server for metadata operations")
    public int getRpcPort() {
        return this.mRpcPort;
    }

    @ApiModelProperty(value="Port of the worker's server for data operations")
    public int getDataPort() {
        return this.mDataPort;
    }

    @ApiModelProperty(value="Port which exposes the worker's web UI")
    public int getWebPort() {
        return this.mWebPort;
    }

    @ApiModelProperty(value="The domain socket path used by the worker, disabled if empty")
    public String getDomainSocketPath() {
        return this.mDomainSocketPath;
    }

    @ApiModelProperty(value="The worker's tier identity")
    public TieredIdentity getTieredIdentity() {
        if (this.mTieredIdentity != null) {
            return this.mTieredIdentity;
        }
        return new TieredIdentity(Arrays.asList(new TieredIdentity.LocalityTier("node", this.mHost)));
    }

    public WorkerNetAddress setHost(String host) {
        Preconditions.checkNotNull((Object)host, (Object)"host");
        this.mHost = host;
        return this;
    }

    public WorkerNetAddress setRpcPort(int rpcPort) {
        this.mRpcPort = rpcPort;
        return this;
    }

    public WorkerNetAddress setDataPort(int dataPort) {
        this.mDataPort = dataPort;
        return this;
    }

    public WorkerNetAddress setWebPort(int webPort) {
        this.mWebPort = webPort;
        return this;
    }

    public WorkerNetAddress setDomainSocketPath(String domainSocketPath) {
        this.mDomainSocketPath = domainSocketPath;
        return this;
    }

    public WorkerNetAddress setTieredIdentity(TieredIdentity tieredIdentity) {
        this.mTieredIdentity = tieredIdentity;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof WorkerNetAddress)) {
            return false;
        }
        WorkerNetAddress that = (WorkerNetAddress)o;
        return this.mHost.equals(that.mHost) && this.mRpcPort == that.mRpcPort && this.mDataPort == that.mDataPort && this.mWebPort == that.mWebPort && this.mDomainSocketPath.equals(that.mDomainSocketPath) && Objects.equal((Object)this.mTieredIdentity, (Object)that.mTieredIdentity);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.mHost, this.mDataPort, this.mRpcPort, this.mWebPort, this.mDomainSocketPath, this.mTieredIdentity});
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("host", (Object)this.mHost).add("rpcPort", this.mRpcPort).add("dataPort", this.mDataPort).add("webPort", this.mWebPort).add("domainSocketPath", (Object)this.mDomainSocketPath).add("tieredIdentity", (Object)this.mTieredIdentity).toString();
    }
}

