/*
 * Decompiled with CFR 0.152.
 */
package alluxio.wire;

import alluxio.wire.WorkerInfo;
import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import io.swagger.annotations.ApiModelProperty;
import java.util.List;
import java.util.Map;

public final class AlluxioJobMasterInfo {
    private Map<String, String> mConfiguration;
    private long mStartTimeMs;
    private long mUptimeMs;
    private String mVersion;
    private List<WorkerInfo> mWorkers;

    @ApiModelProperty(value="Configuration of the Job Master")
    public Map<String, String> getConfiguration() {
        return this.mConfiguration;
    }

    @ApiModelProperty(value="Job Master's start time in epoch time")
    public long getStartTimeMs() {
        return this.mStartTimeMs;
    }

    @ApiModelProperty(value="Number of milliseconds the Job Master has been running")
    public long getUptimeMs() {
        return this.mUptimeMs;
    }

    @ApiModelProperty(value="Version of the Job Master")
    public String getVersion() {
        return this.mVersion;
    }

    @ApiModelProperty(value="List of Job Workers that have registered with the Job Master")
    public List<WorkerInfo> getWorkers() {
        return this.mWorkers;
    }

    public AlluxioJobMasterInfo setConfiguration(Map<String, String> configuration) {
        this.mConfiguration = configuration;
        return this;
    }

    public AlluxioJobMasterInfo setStartTimeMs(long startTimeMs) {
        this.mStartTimeMs = startTimeMs;
        return this;
    }

    public AlluxioJobMasterInfo setUptimeMs(long uptimeMs) {
        this.mUptimeMs = uptimeMs;
        return this;
    }

    public AlluxioJobMasterInfo setVersion(String version) {
        this.mVersion = version;
        return this;
    }

    public AlluxioJobMasterInfo setWorkers(List<WorkerInfo> workers) {
        this.mWorkers = workers;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AlluxioJobMasterInfo)) {
            return false;
        }
        AlluxioJobMasterInfo that = (AlluxioJobMasterInfo)o;
        return Objects.equal(this.mConfiguration, that.mConfiguration) && this.mStartTimeMs == that.mStartTimeMs && this.mUptimeMs == that.mUptimeMs && Objects.equal((Object)this.mVersion, (Object)that.mVersion) && Objects.equal(this.mWorkers, that.mWorkers);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.mConfiguration, this.mStartTimeMs, this.mUptimeMs, this.mVersion, this.mWorkers});
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("configuration", this.mConfiguration).add("start time", this.mStartTimeMs).add("uptime", this.mUptimeMs).add("version", (Object)this.mVersion).add("workers", this.mWorkers).toString();
    }
}

