/*
 * Decompiled with CFR 0.152.
 */
package alluxio.util.io;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public final class ByteIOUtils {
    private ByteIOUtils() {
    }

    public static byte readByte(byte[] buf, int pos) {
        ByteIOUtils.checkBoundary(buf, pos, 1);
        return (byte)(buf[pos] & 0xFF);
    }

    public static byte readByte(ByteBuffer buf, int pos) {
        return (byte)(buf.get(pos) & 0xFF);
    }

    public static short readShort(byte[] buf, int pos) {
        ByteIOUtils.checkBoundary(buf, pos, 2);
        return (short)((short)(buf[pos] & 0xFF) << 8 | (short)(buf[pos + 1] & 0xFF));
    }

    public static int readInt(byte[] buf, int pos) {
        ByteIOUtils.checkBoundary(buf, pos, 4);
        return (buf[pos++] & 0xFF) << 24 | (buf[pos++] & 0xFF) << 16 | (buf[pos++] & 0xFF) << 8 | buf[pos] & 0xFF;
    }

    public static int readInt(ByteBuffer buf, int pos) {
        return (buf.get(pos) & 0xFF) << 24 | (buf.get(pos + 1) & 0xFF) << 16 | (buf.get(pos + 2) & 0xFF) << 8 | buf.get(pos + 3) & 0xFF;
    }

    public static long readLong(byte[] buf, int pos) {
        ByteIOUtils.checkBoundary(buf, pos, 8);
        return (long)(buf[pos++] & 0xFF) << 56 | (long)(buf[pos++] & 0xFF) << 48 | (long)(buf[pos++] & 0xFF) << 40 | (long)(buf[pos++] & 0xFF) << 32 | (long)(buf[pos++] & 0xFF) << 24 | (long)(buf[pos++] & 0xFF) << 16 | (long)(buf[pos++] & 0xFF) << 8 | (long)(buf[pos] & 0xFF);
    }

    public static void writeByte(byte[] buf, int pos, byte v) {
        ByteIOUtils.checkBoundary(buf, pos, 1);
        buf[pos] = v;
    }

    public static void writeByte(ByteBuffer buf, int pos, byte v) {
        buf.put(pos, v);
    }

    public static void writeByte(OutputStream out, byte v) throws IOException {
        out.write(v);
    }

    public static void writeShort(byte[] buf, int pos, short v) {
        ByteIOUtils.checkBoundary(buf, pos, 2);
        buf[pos++] = (byte)(0xFF & v >> 8);
        buf[pos] = (byte)(0xFF & v);
    }

    public static void writeShort(OutputStream out, short v) throws IOException {
        out.write((byte)(0xFF & v >> 8));
        out.write((byte)(0xFF & v));
    }

    public static void writeInt(byte[] buf, int pos, int v) {
        ByteIOUtils.checkBoundary(buf, pos, 4);
        buf[pos++] = (byte)(0xFF & v >> 24);
        buf[pos++] = (byte)(0xFF & v >> 16);
        buf[pos++] = (byte)(0xFF & v >> 8);
        buf[pos] = (byte)(0xFF & v);
    }

    public static void writeInt(ByteBuffer buf, int pos, int v) {
        buf.put(pos++, (byte)(0xFF & v >> 24));
        buf.put(pos++, (byte)(0xFF & v >> 16));
        buf.put(pos++, (byte)(0xFF & v >> 8));
        buf.put(pos, (byte)(0xFF & v));
    }

    public static void writeInt(OutputStream out, int v) throws IOException {
        out.write((byte)(0xFF & v >> 24));
        out.write((byte)(0xFF & v >> 16));
        out.write((byte)(0xFF & v >> 8));
        out.write((byte)(0xFF & v));
    }

    public static void writeLong(byte[] buf, int pos, long v) {
        ByteIOUtils.checkBoundary(buf, pos, 8);
        buf[pos++] = (byte)(0xFFL & v >> 56);
        buf[pos++] = (byte)(0xFFL & v >> 48);
        buf[pos++] = (byte)(0xFFL & v >> 40);
        buf[pos++] = (byte)(0xFFL & v >> 32);
        buf[pos++] = (byte)(0xFFL & v >> 24);
        buf[pos++] = (byte)(0xFFL & v >> 16);
        buf[pos++] = (byte)(0xFFL & v >> 8);
        buf[pos] = (byte)(0xFFL & v);
    }

    public static void writeLong(OutputStream out, long v) throws IOException {
        out.write((byte)(0xFFL & v >> 56));
        out.write((byte)(0xFFL & v >> 48));
        out.write((byte)(0xFFL & v >> 40));
        out.write((byte)(0xFFL & v >> 32));
        out.write((byte)(0xFFL & v >> 24));
        out.write((byte)(0xFFL & v >> 16));
        out.write((byte)(0xFFL & v >> 8));
        out.write((byte)(0xFFL & v));
    }

    private static void checkBoundary(byte[] buf, int pos, int len) {
        if (pos + len > buf.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
    }
}

