/*
 * Decompiled with CFR 0.152.
 */
package alluxio.underfs.options;

import alluxio.conf.AlluxioConfiguration;
import alluxio.conf.PropertyKey;
import alluxio.security.authorization.Mode;
import alluxio.util.ModeUtils;
import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public final class MkdirsOptions {
    private boolean mCreateParent = true;
    private String mOwner = null;
    private String mGroup = null;
    private Mode mMode;

    public static MkdirsOptions defaults(AlluxioConfiguration conf) {
        return new MkdirsOptions(conf.get(PropertyKey.SECURITY_AUTHORIZATION_PERMISSION_UMASK));
    }

    private MkdirsOptions(String authUmask) {
        this.mMode = ModeUtils.applyDirectoryUMask(Mode.defaults(), authUmask);
    }

    public boolean getCreateParent() {
        return this.mCreateParent;
    }

    public String getOwner() {
        return this.mOwner;
    }

    public String getGroup() {
        return this.mGroup;
    }

    public Mode getMode() {
        return this.mMode;
    }

    public MkdirsOptions setCreateParent(boolean createParent) {
        this.mCreateParent = createParent;
        return this;
    }

    public MkdirsOptions setOwner(String owner) {
        this.mOwner = owner;
        return this;
    }

    public MkdirsOptions setGroup(String group) {
        this.mGroup = group;
        return this;
    }

    public MkdirsOptions setMode(Mode mode) {
        this.mMode = mode;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MkdirsOptions)) {
            return false;
        }
        MkdirsOptions that = (MkdirsOptions)o;
        return Objects.equal((Object)this.mCreateParent, (Object)that.mCreateParent) && Objects.equal((Object)this.mOwner, (Object)that.mOwner) && Objects.equal((Object)this.mGroup, (Object)that.mGroup) && Objects.equal((Object)this.mMode, (Object)that.mMode);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.mCreateParent, this.mOwner, this.mGroup, this.mMode});
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("createParent", this.mCreateParent).add("owner", (Object)this.mOwner).add("group", (Object)this.mGroup).add("mode", (Object)this.mMode).toString();
    }
}

