/*
 * Decompiled with CFR 0.152.
 */
package alluxio.underfs;

import alluxio.AlluxioURI;
import alluxio.SyncInfo;
import alluxio.collections.Pair;
import alluxio.security.authorization.AccessControlList;
import alluxio.security.authorization.AclEntry;
import alluxio.security.authorization.DefaultAccessControlList;
import alluxio.underfs.Fingerprint;
import alluxio.underfs.UfsMode;
import alluxio.underfs.UfsStatus;
import alluxio.underfs.UnderFileSystem;
import alluxio.underfs.UnderFileSystemConfiguration;
import alluxio.underfs.options.CreateOptions;
import alluxio.underfs.options.DeleteOptions;
import alluxio.underfs.options.ListOptions;
import alluxio.underfs.options.MkdirsOptions;
import alluxio.underfs.options.OpenOptions;
import alluxio.util.io.PathUtils;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public abstract class BaseUnderFileSystem
implements UnderFileSystem {
    private static final Logger LOG = LoggerFactory.getLogger(BaseUnderFileSystem.class);
    protected final AlluxioURI mUri;
    protected final UnderFileSystemConfiguration mUfsConf;

    protected BaseUnderFileSystem(AlluxioURI uri, UnderFileSystemConfiguration ufsConf) {
        this.mUri = (AlluxioURI)Preconditions.checkNotNull((Object)uri, (Object)"uri");
        this.mUfsConf = (UnderFileSystemConfiguration)Preconditions.checkNotNull((Object)ufsConf, (Object)"ufsConf");
    }

    @Override
    public OutputStream create(String path) throws IOException {
        return this.create(path, CreateOptions.defaults(this.mUfsConf).setCreateParent(true));
    }

    @Override
    public boolean deleteDirectory(String path) throws IOException {
        return this.deleteDirectory(path, DeleteOptions.defaults());
    }

    @Override
    public boolean exists(String path) throws IOException {
        return this.isFile(path) || this.isDirectory(path);
    }

    @Override
    public Pair<AccessControlList, DefaultAccessControlList> getAclPair(String path) throws IOException {
        return new Pair(null, null);
    }

    @Override
    public void setAclEntries(String path, List<AclEntry> aclEntries) throws IOException {
    }

    @Override
    public String getFingerprint(String path) {
        try {
            UfsStatus status = this.getStatus(path);
            Pair<AccessControlList, DefaultAccessControlList> aclPair = this.getAclPair(path);
            if (aclPair == null || aclPair.getFirst() == null || !((AccessControlList)aclPair.getFirst()).hasExtended()) {
                return Fingerprint.create(this.getUnderFSType(), status).serialize();
            }
            return Fingerprint.create(this.getUnderFSType(), status, (AccessControlList)aclPair.getFirst()).serialize();
        }
        catch (Exception e) {
            LOG.debug("Failed fingerprint. path: {} error: {}", (Object)path, (Object)e.toString());
            return "";
        }
    }

    @Override
    public UfsMode getOperationMode(Map<String, UfsMode> physicalUfsState) {
        UfsMode ufsMode = physicalUfsState.get(this.mUri.getRootPath());
        if (ufsMode != null) {
            return ufsMode;
        }
        return UfsMode.READ_WRITE;
    }

    @Override
    public List<String> getPhysicalStores() {
        return new ArrayList<String>(Arrays.asList(this.mUri.getRootPath()));
    }

    @Override
    public boolean isObjectStorage() {
        return false;
    }

    @Override
    public boolean isSeekable() {
        return false;
    }

    @Override
    @Nullable
    public UfsStatus[] listStatus(String path, ListOptions options) throws IOException {
        if (!options.isRecursive()) {
            return this.listStatus(path);
        }
        path = BaseUnderFileSystem.validatePath(path);
        ArrayList<UfsStatus> returnPaths = new ArrayList<UfsStatus>();
        ArrayDeque<Pair> pathsToProcess = new ArrayDeque<Pair>();
        UfsStatus[] statuses = this.listStatus(path);
        if (statuses == null) {
            return null;
        }
        for (UfsStatus status : statuses) {
            pathsToProcess.add(new Pair((Object)PathUtils.concatPath((Object)path, (Object)status.getName()), (Object)status));
        }
        while (!pathsToProcess.isEmpty()) {
            UfsStatus[] children;
            Pair pathToProcessPair = (Pair)pathsToProcess.remove();
            String pathToProcess = (String)pathToProcessPair.getFirst();
            UfsStatus pathStatus = (UfsStatus)pathToProcessPair.getSecond();
            returnPaths.add(pathStatus.setName(pathToProcess.substring(path.length() + 1)));
            if (!pathStatus.isDirectory() || (children = this.listStatus(pathToProcess)) == null) continue;
            for (UfsStatus child : children) {
                pathsToProcess.add(new Pair((Object)PathUtils.concatPath((Object)pathToProcess, (Object)child.getName()), (Object)child));
            }
        }
        return returnPaths.toArray(new UfsStatus[returnPaths.size()]);
    }

    @Override
    public InputStream open(String path) throws IOException {
        return this.open(path, OpenOptions.defaults());
    }

    @Override
    public boolean mkdirs(String path) throws IOException {
        return this.mkdirs(path, MkdirsOptions.defaults(this.mUfsConf));
    }

    @Override
    public AlluxioURI resolveUri(AlluxioURI ufsBaseUri, String alluxioPath) {
        return new AlluxioURI(ufsBaseUri, PathUtils.concatPath((Object)ufsBaseUri.getPath(), (Object)alluxioPath), false);
    }

    @Override
    public boolean supportsActiveSync() {
        return false;
    }

    @Override
    public SyncInfo getActiveSyncInfo() {
        return SyncInfo.emptyInfo();
    }

    @Override
    public boolean startActiveSyncPolling(long txId) throws IOException {
        return false;
    }

    @Override
    public boolean stopActiveSyncPolling() {
        return false;
    }

    @Override
    public void startSync(AlluxioURI uri) {
    }

    @Override
    public void stopSync(AlluxioURI uri) {
    }

    protected static String validatePath(String path) {
        return new AlluxioURI(path).toString();
    }
}

