/*
 * Decompiled with CFR 0.152.
 */
package alluxio.security.login;

import alluxio.util.OSUtils;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public final class LoginModuleConfigurationUtils {
    public static final String OS_LOGIN_MODULE_NAME = LoginModuleConfigurationUtils.getOSLoginModuleName();
    public static final String OS_PRINCIPAL_CLASS_NAME = LoginModuleConfigurationUtils.getOSPrincipalClassName();

    private LoginModuleConfigurationUtils() {
    }

    private static String getOSLoginModuleName() {
        if (OSUtils.IBM_JAVA) {
            if (OSUtils.isWindows()) {
                return OSUtils.is64Bit() ? "com.ibm.security.auth.module.Win64LoginModule" : "com.ibm.security.auth.module.NTLoginModule";
            }
            if (OSUtils.isAIX()) {
                return OSUtils.is64Bit() ? "com.ibm.security.auth.module.AIX64LoginModule" : "com.ibm.security.auth.module.AIXLoginModule";
            }
            return "com.ibm.security.auth.module.LinuxLoginModule";
        }
        return OSUtils.isWindows() ? "com.sun.security.auth.module.NTLoginModule" : "com.sun.security.auth.module.UnixLoginModule";
    }

    private static String getOSPrincipalClassName() {
        String principalClassName = OSUtils.IBM_JAVA ? (OSUtils.is64Bit() ? "com.ibm.security.auth.UsernamePrincipal" : (OSUtils.isWindows() ? "com.ibm.security.auth.NTUserPrincipal" : (OSUtils.isAIX() ? "com.ibm.security.auth.AIXPrincipal" : "com.ibm.security.auth.LinuxPrincipal"))) : (OSUtils.isWindows() ? "com.sun.security.auth.NTUserPrincipal" : "com.sun.security.auth.UnixPrincipal");
        return principalClassName;
    }
}

