/*
 * Decompiled with CFR 0.152.
 */
package alluxio.security.authentication.plain;

import alluxio.conf.AlluxioConfiguration;
import alluxio.security.authentication.AuthenticatedClientUser;
import alluxio.security.authentication.AuthenticationProvider;
import alluxio.security.authentication.ImpersonationAuthenticator;
import com.google.common.base.Preconditions;
import java.io.IOException;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.sasl.AuthorizeCallback;

public final class PlainSaslServerCallbackHandler
implements CallbackHandler {
    private final AuthenticationProvider mAuthenticationProvider;
    private final ImpersonationAuthenticator mImpersonationAuthenticator;

    public PlainSaslServerCallbackHandler(AuthenticationProvider authenticationProvider, AlluxioConfiguration conf) {
        this.mAuthenticationProvider = (AuthenticationProvider)Preconditions.checkNotNull((Object)authenticationProvider, (Object)"authenticationProvider");
        this.mImpersonationAuthenticator = new ImpersonationAuthenticator(conf);
    }

    @Override
    public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
        String username = null;
        String password = null;
        AuthorizeCallback ac = null;
        for (Callback callback : callbacks) {
            if (callback instanceof NameCallback) {
                NameCallback nc = (NameCallback)callback;
                username = nc.getName();
                continue;
            }
            if (callback instanceof PasswordCallback) {
                PasswordCallback pc = (PasswordCallback)callback;
                password = new String(pc.getPassword());
                continue;
            }
            if (callback instanceof AuthorizeCallback) {
                ac = (AuthorizeCallback)callback;
                continue;
            }
            throw new UnsupportedCallbackException(callback, "Unsupport callback");
        }
        this.mAuthenticationProvider.authenticate(username, password);
        if (ac != null) {
            ac.setAuthorized(true);
            try {
                this.mImpersonationAuthenticator.authenticate(username, ac.getAuthorizedID());
            }
            catch (Exception e) {
                ac.setAuthorized(false);
                throw e;
            }
            AuthenticatedClientUser.set(ac.getAuthorizedID());
        }
    }
}

