/*
 * Decompiled with CFR 0.152.
 */
package alluxio.security.authentication;

import alluxio.exception.status.AlluxioStatusException;
import alluxio.grpc.ChannelAuthenticationScheme;
import alluxio.grpc.SaslMessage;
import alluxio.grpc.SaslMessageType;
import alluxio.security.authentication.AuthenticatedUserInfo;
import alluxio.security.authentication.AuthenticationServer;
import alluxio.security.authentication.SaslServerHandler;
import io.grpc.stub.StreamObserver;
import java.util.UUID;
import javax.security.sasl.SaslException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthenticatedChannelServerDriver
implements StreamObserver<SaslMessage> {
    private static final Logger LOG = LoggerFactory.getLogger(AuthenticatedChannelServerDriver.class);
    private static final UUID EMPTY_UUID = new UUID(0L, 0L);
    private StreamObserver<SaslMessage> mRequestObserver = null;
    private AuthenticationServer mAuthenticationServer;
    private UUID mChannelId = EMPTY_UUID;
    private String mChannelRef;
    private SaslServerHandler mSaslServerHandler = null;
    private volatile boolean mChannelAuthenticated = false;

    public AuthenticatedChannelServerDriver(AuthenticationServer authenticationServer) {
        this.mAuthenticationServer = authenticationServer;
    }

    public void setClientObserver(StreamObserver<SaslMessage> requestObserver) {
        this.mRequestObserver = requestObserver;
    }

    private void initAuthenticatedChannel(ChannelAuthenticationScheme authScheme, UUID channelId, String channelRef) throws SaslException {
        LOG.debug("Initializing authentication for channel: {}. AuthType: {}", (Object)this.mChannelRef, (Object)authScheme);
        this.mSaslServerHandler = this.mAuthenticationServer.createSaslHandler(authScheme);
        this.mAuthenticationServer.unregisterChannel(this.mChannelId);
        this.mChannelId = channelId;
        this.mChannelRef = channelRef;
    }

    private void channelAuthenticated(AuthenticatedUserInfo authUserInfo) {
        this.mAuthenticationServer.registerChannel(this.mChannelId, authUserInfo, this);
        this.mChannelAuthenticated = true;
    }

    private void closeAuthenticatedChannel(boolean signalOwner) {
        if (this.mChannelAuthenticated) {
            LOG.debug("Closing authenticated channel for {}", (Object)this.mChannelRef);
            this.mAuthenticationServer.unregisterChannel(this.mChannelId);
            this.mChannelAuthenticated = false;
        }
        if (this.mSaslServerHandler != null) {
            this.mSaslServerHandler.close();
        }
        if (signalOwner) {
            try {
                this.mRequestObserver.onCompleted();
            }
            catch (Exception exc) {
                LOG.debug("Failed to close gRPC stream of channel: {}. Error: {}", (Object)this.mChannelRef, (Object)exc);
            }
        }
    }

    public void onNext(SaslMessage saslMessage) {
        try {
            if (this.mChannelId.equals(EMPTY_UUID)) {
                this.initAuthenticatedChannel(saslMessage.getAuthenticationScheme(), UUID.fromString(saslMessage.getClientId()), saslMessage.getChannelRef());
            }
            LOG.debug("Responding to a message of channel: {}. Message: {}", (Object)this.mChannelRef, (Object)saslMessage);
            SaslMessage response = this.mSaslServerHandler.handleMessage(saslMessage);
            if (response.getMessageType() == SaslMessageType.SUCCESS) {
                this.channelAuthenticated(this.mSaslServerHandler.getAuthenticatedUserInfo());
            }
            this.mRequestObserver.onNext((Object)response);
        }
        catch (Throwable t) {
            LOG.debug("Exception while handling message of channel: {}. Message: {}. Error: {}", new Object[]{this.mChannelRef, saslMessage, t});
            this.mRequestObserver.onError((Throwable)AlluxioStatusException.fromThrowable((Throwable)t).toGrpcStatusException());
            this.closeAuthenticatedChannel(false);
        }
    }

    public void onError(Throwable throwable) {
        this.closeAuthenticatedChannel(false);
    }

    public void onCompleted() {
        this.closeAuthenticatedChannel(true);
    }

    public void close() {
        LOG.debug("Closing authentication for channel: {}", (Object)this.mChannelRef);
        this.closeAuthenticatedChannel(true);
    }
}

