/*
 * Decompiled with CFR 0.152.
 */
package alluxio.resource;

import com.google.common.annotations.VisibleForTesting;
import java.io.Closeable;
import java.util.concurrent.locks.Lock;

public class LockResource
implements Closeable {
    private final Lock mLock;

    public LockResource(Lock lock) {
        this(lock, true);
    }

    public LockResource(Lock lock, boolean acquireLock) {
        this.mLock = lock;
        if (acquireLock) {
            this.mLock.lock();
        }
    }

    @VisibleForTesting
    public boolean hasSameLock(LockResource other) {
        return this.mLock == other.mLock;
    }

    @Override
    public void close() {
        this.mLock.unlock();
    }
}

