/*
 * Decompiled with CFR 0.152.
 */
package alluxio.grpc;

import alluxio.collections.Pair;
import alluxio.conf.AlluxioConfiguration;
import alluxio.conf.PropertyKey;
import alluxio.grpc.GrpcServerAddress;
import alluxio.util.network.NetworkAddressUtils;
import com.google.common.base.MoreObjects;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.netty.channel.Channel;
import io.netty.channel.EventLoopGroup;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Field;
import java.util.Optional;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang.builder.HashCodeBuilder;

public class GrpcChannelKey {
    private static final Random RANDOM = new Random();
    @IdentityField
    @SuppressFBWarnings(value={"URF_UNREAD_FIELD"})
    Long mPoolKey = 0L;
    @IdentityField
    private GrpcServerAddress mServerAddress;
    @IdentityField
    private Optional<Pair<Long, TimeUnit>> mKeepAliveTime = Optional.empty();
    @IdentityField
    private Optional<Pair<Long, TimeUnit>> mKeepAliveTimeout = Optional.empty();
    @IdentityField
    private Optional<Integer> mMaxInboundMessageSize = Optional.empty();
    @IdentityField
    private Optional<Integer> mFlowControlWindow = Optional.empty();
    @IdentityField
    private Optional<Class<? extends Channel>> mChannelType = Optional.empty();
    @IdentityField
    private Optional<EventLoopGroup> mEventLoopGroup = Optional.empty();
    private Optional<String> mClientType = Optional.empty();
    private final UUID mChannelId = UUID.randomUUID();
    private final String mLocalHostName;

    private GrpcChannelKey(AlluxioConfiguration conf) {
        String localHostName;
        try {
            localHostName = NetworkAddressUtils.getLocalHostName((int)conf.getMs(PropertyKey.NETWORK_HOST_RESOLUTION_TIMEOUT_MS));
        }
        catch (Exception e) {
            localHostName = "<UNKNOWN>";
        }
        this.mLocalHostName = localHostName;
    }

    public static GrpcChannelKey create(AlluxioConfiguration conf) {
        return new GrpcChannelKey(conf);
    }

    public UUID getChannelId() {
        return this.mChannelId;
    }

    public GrpcServerAddress getServerAddress() {
        return this.mServerAddress;
    }

    public GrpcChannelKey setServerAddress(GrpcServerAddress address) {
        this.mServerAddress = address;
        return this;
    }

    public Optional<Integer> getMaxInboundMessageSize() {
        return this.mMaxInboundMessageSize;
    }

    public GrpcChannelKey setMaxInboundMessageSize(int maxInboundMessageSize) {
        this.mMaxInboundMessageSize = Optional.of(maxInboundMessageSize);
        return this;
    }

    public Optional<Integer> getFlowControlWindow() {
        return this.mFlowControlWindow;
    }

    public GrpcChannelKey setFlowControlWindow(int flowControlWindow) {
        this.mFlowControlWindow = Optional.of(flowControlWindow);
        return this;
    }

    public Optional<Class<? extends Channel>> getChannelType() {
        return this.mChannelType;
    }

    public GrpcChannelKey setChannelType(Class<? extends Channel> channelType) {
        this.mChannelType = Optional.of(channelType);
        return this;
    }

    public Optional<EventLoopGroup> getEventLoopGroup() {
        return this.mEventLoopGroup;
    }

    public GrpcChannelKey setEventLoopGroup(EventLoopGroup eventLoopGroup) {
        this.mEventLoopGroup = Optional.of(eventLoopGroup);
        return this;
    }

    public Optional<String> getChannelName() {
        return this.mClientType;
    }

    public GrpcChannelKey setClientType(String clientType) {
        this.mClientType = Optional.of(clientType);
        return this;
    }

    public Optional<Pair<Long, TimeUnit>> getKeepAliveTime() {
        return this.mKeepAliveTime;
    }

    public GrpcChannelKey setKeepAliveTime(long keepAliveTime, TimeUnit timeUnit) {
        this.mKeepAliveTime = Optional.of(new Pair((Object)keepAliveTime, (Object)timeUnit));
        return this;
    }

    public Optional<Pair<Long, TimeUnit>> getKeepAliveTimeout() {
        return this.mKeepAliveTimeout;
    }

    public GrpcChannelKey setKeepAliveTimeout(long keepAliveTimeout, TimeUnit timeUnit) {
        this.mKeepAliveTimeout = Optional.of(new Pair((Object)keepAliveTimeout, (Object)timeUnit));
        return this;
    }

    public GrpcChannelKey setPoolingStrategy(PoolingStrategy strategy) {
        switch (strategy) {
            case DEFAULT: {
                this.mPoolKey = 0L;
                break;
            }
            case DISABLED: {
                this.mPoolKey = RANDOM.nextLong();
                break;
            }
            default: {
                throw new IllegalArgumentException(String.format("Invalid pooling strategy %s", strategy.name()));
            }
        }
        return this;
    }

    public int hashCode() {
        HashCodeBuilder hashCodebuilder = new HashCodeBuilder();
        for (Field field : this.getClass().getDeclaredFields()) {
            if (!field.isAnnotationPresent(IdentityField.class)) continue;
            try {
                hashCodebuilder.append(field.get(this));
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(String.format("Failed to calculate hashcode for channel-key: %s", this), e);
            }
        }
        return hashCodebuilder.toHashCode();
    }

    public boolean equals(Object other) {
        if (other instanceof GrpcChannelKey) {
            GrpcChannelKey otherKey = (GrpcChannelKey)other;
            boolean areEqual = true;
            for (Field field : this.getClass().getDeclaredFields()) {
                if (!field.isAnnotationPresent(IdentityField.class)) continue;
                try {
                    areEqual &= field.get(this).equals(field.get(otherKey));
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException(String.format("Failed to calculate equality between channel-keys source: %s | destination: %s", this, otherKey), e);
                }
            }
            return areEqual;
        }
        return false;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("ClientType", (Object)this.getStringFromOptional(this.mClientType)).add("ServerAddress", (Object)this.mServerAddress).add("ChannelId", (Object)this.mChannelId).add("KeepAliveTime", (Object)this.getStringFromOptional(this.mKeepAliveTime)).add("KeepAliveTimeout", (Object)this.getStringFromOptional(this.mKeepAliveTimeout)).add("FlowControlWindow", (Object)this.getStringFromOptional(this.mFlowControlWindow)).add("MaxInboundMessageSize", (Object)this.getStringFromOptional(this.mMaxInboundMessageSize)).add("ChannelType", (Object)this.getStringFromOptional(this.mChannelType)).omitNullValues().toString();
    }

    public String toStringShort() {
        return MoreObjects.toStringHelper((Object)this).add("ClientType", (Object)this.getStringFromOptional(this.mClientType)).add("ClientHostname", (Object)this.mLocalHostName).add("ServerAddress", (Object)this.mServerAddress).add("ChannelId", (Object)this.mChannelId).omitNullValues().toString();
    }

    private String getStringFromOptional(Optional<?> field) {
        if (field.isPresent()) {
            return field.get().toString();
        }
        return null;
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    protected static @interface IdentityField {
    }

    public static enum PoolingStrategy {
        DEFAULT,
        DISABLED;

    }
}

