/*
 * Decompiled with CFR 0.152.
 */
package alluxio.grpc;

import alluxio.grpc.GrpcChannelKey;
import alluxio.grpc.GrpcManagedChannelPool;
import alluxio.security.authentication.AuthenticatedChannelClientDriver;
import com.google.common.base.MoreObjects;
import io.grpc.CallOptions;
import io.grpc.Channel;
import io.grpc.ClientCall;
import io.grpc.ClientInterceptor;
import io.grpc.ClientInterceptors;
import io.grpc.ForwardingClientCall;
import io.grpc.ForwardingClientCallListener;
import io.grpc.Metadata;
import io.grpc.MethodDescriptor;
import io.grpc.Status;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public final class GrpcChannel
extends Channel {
    private final GrpcChannelKey mChannelKey;
    private final Channel mOriginalChannel;
    private final long mShutdownTimeoutMs;
    private Channel mTrackedChannel;
    private ChannelResponseTracker mResponseTracker;
    private AuthenticatedChannelClientDriver mAuthDriver;
    private boolean mChannelReleased = false;

    public GrpcChannel(GrpcChannelKey channelKey, Channel channel, long shutdownTimeoutMs, @Nullable AuthenticatedChannelClientDriver authDriver) {
        this.mChannelKey = channelKey;
        this.mShutdownTimeoutMs = shutdownTimeoutMs;
        this.mOriginalChannel = channel;
        this.mAuthDriver = authDriver;
        this.mResponseTracker = new ChannelResponseTracker();
        this.mTrackedChannel = ClientInterceptors.intercept((Channel)this.mOriginalChannel, (ClientInterceptor[])new ClientInterceptor[]{this.mResponseTracker});
    }

    public <RequestT, ResponseT> ClientCall<RequestT, ResponseT> newCall(MethodDescriptor<RequestT, ResponseT> methodDescriptor, CallOptions callOptions) {
        return this.mTrackedChannel.newCall(methodDescriptor, callOptions);
    }

    public String authority() {
        return this.mTrackedChannel.authority();
    }

    public void intercept(ClientInterceptor interceptor) {
        this.mTrackedChannel = ClientInterceptors.intercept((Channel)this.mTrackedChannel, (ClientInterceptor[])new ClientInterceptor[]{interceptor});
    }

    public synchronized void shutdown() {
        if (this.mAuthDriver != null) {
            this.mAuthDriver.close();
            this.mAuthDriver = null;
        }
        if (!this.mChannelReleased) {
            GrpcManagedChannelPool.INSTANCE().releaseManagedChannel(this.mChannelKey, this.mShutdownTimeoutMs);
            this.mChannelReleased = true;
        }
    }

    public boolean isShutdown() {
        return this.mChannelReleased;
    }

    public boolean isHealthy() {
        boolean healthy = this.mResponseTracker.isChannelHealthy();
        if (this.mAuthDriver != null) {
            healthy &= this.mAuthDriver.isAuthenticated();
        }
        return healthy;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("ChannelKey", (Object)this.mChannelKey).add("ChannelHealthy", this.isHealthy()).add("ChannelReleased", this.mChannelReleased).toString();
    }

    public String toStringShort() {
        return this.mChannelKey.toStringShort();
    }

    private class ChannelResponseTracker
    implements ClientInterceptor {
        private boolean mChannelHealthy = true;

        private ChannelResponseTracker() {
        }

        public boolean isChannelHealthy() {
            return this.mChannelHealthy;
        }

        public <ReqT, RespT> ClientCall<ReqT, RespT> interceptCall(MethodDescriptor<ReqT, RespT> method, CallOptions callOptions, Channel next) {
            return new ForwardingClientCall.SimpleForwardingClientCall<ReqT, RespT>(next.newCall(method, callOptions)){

                public void start(ClientCall.Listener<RespT> responseListener, Metadata headers) {
                    super.start((ClientCall.Listener)new ForwardingClientCallListener.SimpleForwardingClientCallListener<RespT>(responseListener){

                        public void onClose(Status status, Metadata trailers) {
                            if (status == Status.UNAUTHENTICATED || status == Status.UNAVAILABLE) {
                                ChannelResponseTracker.this.mChannelHealthy = false;
                            }
                            super.onClose(status, trailers);
                        }
                    }, headers);
                }
            };
        }
    }
}

