/*
 * Decompiled with CFR 0.152.
 */
package org.ajoberstar.grgit.gradle;

import java.io.File;
import java.util.Optional;
import javax.inject.Inject;
import org.ajoberstar.grgit.Grgit;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.ProviderFactory;
import org.gradle.api.services.BuildService;
import org.gradle.api.services.BuildServiceParameters;

public abstract class GrgitService
implements BuildService<Params>,
AutoCloseable {
    private static final Logger logger = Logging.getLogger(GrgitService.class);

    @Inject
    public GrgitService(ProviderFactory providers) {
        this.getGrgitProperty().set(providers.provider(this::makeGrgit));
        this.getGrgitProperty().disallowChanges();
        this.getGrgitProperty().finalizeValueOnRead();
    }

    protected abstract Property<Grgit> getGrgitProperty();

    public Grgit getGrgit() {
        return (Grgit)this.getGrgitProperty().get();
    }

    public Optional<Grgit> findGrgit() {
        try {
            return Optional.of(this.getGrgit());
        }
        catch (Exception e) {
            logger.info("Failed to make grgit service.", (Throwable)e);
            return Optional.empty();
        }
    }

    @Override
    public void close() throws Exception {
        this.findGrgit().ifPresent(grgit -> {
            logger.info("Closing Git repo: {}", (Object)grgit.getRepository().getRootDir());
            grgit.close();
        });
    }

    private Grgit makeGrgit() {
        if (((Params)this.getParameters()).getCurrentDirectory().isPresent()) {
            return Grgit.open(op -> op.setCurrentDir((Object)((Directory)((Params)this.getParameters()).getCurrentDirectory().get()).getAsFile()));
        }
        File dir = ((Directory)((Params)this.getParameters()).getDirectory().get()).getAsFile();
        File gitDir = new File(dir, ".git");
        if (gitDir.exists()) {
            return Grgit.open(op -> op.setDir((Object)dir));
        }
        if (((Boolean)((Params)this.getParameters()).getInitIfNotExists().getOrElse((Object)false)).booleanValue()) {
            return Grgit.init(op -> op.setDir((Object)dir));
        }
        throw new IllegalStateException("No Git repo exists at " + String.valueOf(dir) + " and initIfNotExists is false. Cannot proceed.");
    }

    public static interface Params
    extends BuildServiceParameters {
        public DirectoryProperty getCurrentDirectory();

        public DirectoryProperty getDirectory();

        public Property<Boolean> getInitIfNotExists();
    }
}

