/*
 * Decompiled with CFR 0.152.
 */
package org.agrona.shadow.net.bytebuddy.utility;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.agrona.shadow.net.bytebuddy.ClassFileVersion;
import org.agrona.shadow.net.bytebuddy.build.AccessControllerPlugin;
import org.agrona.shadow.net.bytebuddy.build.HashCodeAndEqualsPlugin;
import org.agrona.shadow.net.bytebuddy.jar.asm.Attribute;
import org.agrona.shadow.net.bytebuddy.jar.asm.ClassReader;
import org.agrona.shadow.net.bytebuddy.jar.asm.ClassVisitor;
import org.agrona.shadow.net.bytebuddy.utility.OpenedClassReader;
import org.agrona.shadow.net.bytebuddy.utility.dispatcher.JavaDispatcher;
import org.agrona.shadow.net.bytebuddy.utility.nullability.MaybeNull;
import org.agrona.shadow.net.bytebuddy.utility.privilege.GetSystemPropertyAction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public interface AsmClassReader {
    public static final Attribute[] NO_ATTRIBUTES = new Attribute[0];

    @MaybeNull
    public <T> T unwrap(Class<T> var1);

    public int getModifiers();

    public String getInternalName();

    @MaybeNull
    public String getSuperClassInternalName();

    public List<String> getInterfaceInternalNames();

    public void accept(ClassVisitor var1, int var2);

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    @HashCodeAndEqualsPlugin.Enhance
    public static class ForClassFileApi
    implements AsmClassReader {
        protected static final JdkClassReader DISPATCHER;
        private final Object classReader;
        private static final boolean ACCESS_CONTROLLER;

        public ForClassFileApi(Object classReader) {
            if (!DISPATCHER.isInstance(classReader)) {
                throw new IllegalArgumentException();
            }
            this.classReader = classReader;
        }

        @AccessControllerPlugin.Enhance
        private static <T> T doPrivileged(PrivilegedAction<T> privilegedAction) {
            PrivilegedAction<T> action;
            if (ACCESS_CONTROLLER) {
                return AccessController.doPrivileged(privilegedAction);
            }
            return action.run();
        }

        @Override
        @MaybeNull
        public <T> T unwrap(Class<T> type) {
            return type.isInstance(this.classReader) ? (T)type.cast(this.classReader) : null;
        }

        @Override
        public int getModifiers() {
            return DISPATCHER.getAccess(this.classReader);
        }

        @Override
        public String getInternalName() {
            return DISPATCHER.getClassName(this.classReader);
        }

        @Override
        @MaybeNull
        public String getSuperClassInternalName() {
            return DISPATCHER.getSuperName(this.classReader);
        }

        @Override
        public List<String> getInterfaceInternalNames() {
            String[] value = DISPATCHER.getInterfaces(this.classReader);
            return value == null ? Collections.emptyList() : Arrays.asList(value);
        }

        @MaybeNull
        public String getSuperClassName() {
            return DISPATCHER.getSuperName(this.classReader);
        }

        @MaybeNull
        public String[] getInterfaceTypeName() {
            return DISPATCHER.getInterfaces(this.classReader);
        }

        @Override
        public void accept(ClassVisitor classVisitor, int flags) {
            DISPATCHER.accept(this.classReader, classVisitor, flags);
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        static {
            try {
                Class.forName("java.security.AccessController", false, null);
                ACCESS_CONTROLLER = Boolean.parseBoolean(System.getProperty("org.agrona.shadow.net.bytebuddy.securitymanager", "true"));
            }
            catch (ClassNotFoundException classNotFoundException) {
                ACCESS_CONTROLLER = false;
            }
            catch (SecurityException securityException) {
                ACCESS_CONTROLLER = true;
            }
            DISPATCHER = ForClassFileApi.doPrivileged(JavaDispatcher.of(JdkClassReader.class, ForClassFileApi.class.getClassLoader()));
        }

        public boolean equals(@MaybeNull Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            return this.classReader.equals(((ForClassFileApi)object).classReader);
        }

        public int hashCode() {
            return this.getClass().hashCode() * 31 + this.classReader.hashCode();
        }

        /*
         * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
         */
        @JavaDispatcher.Proxied(value="org.agrona.shadow.net.bytebuddy.jar.asmjdkbridge.JdkClassReader")
        protected static interface JdkClassReader {
            @JavaDispatcher.Instance
            @JavaDispatcher.Proxied(value="isInstance")
            public boolean isInstance(Object var1);

            @JavaDispatcher.IsConstructor
            @JavaDispatcher.Proxied(value="make")
            public Object make(byte[] var1, Attribute[] var2);

            @JavaDispatcher.Proxied(value="getAccess")
            public int getAccess(Object var1);

            @JavaDispatcher.Proxied(value="getClassName")
            public String getClassName(Object var1);

            @MaybeNull
            @JavaDispatcher.Proxied(value="getSuperName")
            public String getSuperName(Object var1);

            @MaybeNull
            @JavaDispatcher.Proxied(value="getInterfaces")
            public String[] getInterfaces(Object var1);

            @JavaDispatcher.Proxied(value="accept")
            public void accept(Object var1, ClassVisitor var2, int var3);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    public static class ForAsm
    implements AsmClassReader {
        private final ClassReader classReader;

        public ForAsm(ClassReader classReader) {
            this.classReader = classReader;
        }

        @Override
        @MaybeNull
        public <T> T unwrap(Class<T> type) {
            return type.isInstance(this.classReader) ? (T)type.cast(this.classReader) : null;
        }

        @Override
        public int getModifiers() {
            return this.classReader.getAccess();
        }

        @Override
        public String getInternalName() {
            return this.classReader.getClassName();
        }

        @Override
        public String getSuperClassInternalName() {
            return this.classReader.getSuperName();
        }

        @Override
        public List<String> getInterfaceInternalNames() {
            String[] value = this.classReader.getInterfaces();
            return value == null ? Collections.emptyList() : Arrays.asList(value);
        }

        @Override
        public void accept(ClassVisitor classVisitor, int flags) {
            this.classReader.accept(classVisitor, NO_ATTRIBUTES, flags);
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    public static interface Factory {
        public AsmClassReader make(byte[] var1);

        public AsmClassReader make(byte[] var1, boolean var2);

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
         */
        public static abstract class Default
        extends Enum<Default>
        implements Factory {
            public static final /* enum */ Default IMPLICIT;
            public static final /* enum */ Default ASM_FIRST;
            public static final /* enum */ Default CLASS_FILE_API_FIRST;
            public static final /* enum */ Default ASM_ONLY;
            public static final /* enum */ Default CLASS_FILE_API_ONLY;
            private static final Factory FACTORY;
            private static final /* synthetic */ Default[] $VALUES;
            private static final boolean ACCESS_CONTROLLER;

            public static Default[] values() {
                return (Default[])$VALUES.clone();
            }

            public static Default valueOf(String name) {
                return Enum.valueOf(Default.class, name);
            }

            @MaybeNull
            @AccessControllerPlugin.Enhance
            private static <T> T doPrivileged(PrivilegedAction<T> privilegedAction) {
                PrivilegedAction<T> action;
                if (ACCESS_CONTROLLER) {
                    return AccessController.doPrivileged(privilegedAction);
                }
                return action.run();
            }

            @Override
            public AsmClassReader make(byte[] binaryRepresentation) {
                return this.make(binaryRepresentation, OpenedClassReader.EXPERIMENTAL);
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            static {
                String processor;
                try {
                    Class.forName("java.security.AccessController", false, null);
                    ACCESS_CONTROLLER = Boolean.parseBoolean(System.getProperty("org.agrona.shadow.net.bytebuddy.securitymanager", "true"));
                }
                catch (ClassNotFoundException classNotFoundException) {
                    ACCESS_CONTROLLER = false;
                }
                catch (SecurityException securityException) {
                    ACCESS_CONTROLLER = true;
                }
                IMPLICIT = new Default(){

                    public AsmClassReader make(byte[] binaryRepresentation, boolean experimental) {
                        return (FACTORY == IMPLICIT ? ASM_FIRST : FACTORY).make(binaryRepresentation, experimental);
                    }
                };
                ASM_FIRST = new Default(){

                    public AsmClassReader make(byte[] binaryRepresentation, boolean experimental) {
                        return AsmClassReader.class.getClassLoader() != null && ClassFileVersion.ofThisVm().isGreaterThan(ClassFileVersion.latest()) ? CLASS_FILE_API_ONLY.make(binaryRepresentation, experimental) : ASM_ONLY.make(binaryRepresentation, experimental);
                    }
                };
                CLASS_FILE_API_FIRST = new Default(){

                    public AsmClassReader make(byte[] binaryRepresentation, boolean experimental) {
                        return ClassFileVersion.ofThisVm().isAtLeast(ClassFileVersion.JAVA_V24) ? CLASS_FILE_API_ONLY.make(binaryRepresentation, experimental) : ASM_ONLY.make(binaryRepresentation, experimental);
                    }
                };
                ASM_ONLY = new Default(){

                    public AsmClassReader make(byte[] binaryRepresentation, boolean experimental) {
                        return new ForAsm(OpenedClassReader.of(binaryRepresentation, experimental));
                    }
                };
                CLASS_FILE_API_ONLY = new Default(){

                    public AsmClassReader make(byte[] binaryRepresentation, boolean experimental) {
                        return new ForClassFileApi(ForClassFileApi.DISPATCHER.make(binaryRepresentation, NO_ATTRIBUTES));
                    }
                };
                $VALUES = new Default[]{IMPLICIT, ASM_FIRST, CLASS_FILE_API_FIRST, ASM_ONLY, CLASS_FILE_API_ONLY};
                try {
                    processor = Default.doPrivileged(new GetSystemPropertyAction("org.agrona.shadow.net.bytebuddy.processor"));
                }
                catch (Throwable ignored) {
                    processor = null;
                }
                FACTORY = processor == null ? ASM_FIRST : Default.valueOf(processor);
            }
        }
    }
}

