/*
 * Decompiled with CFR 0.152.
 */
package org.agrona;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.net.URI;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import org.agrona.AsciiEncoding;
import org.agrona.PropertyAction;
import org.agrona.Strings;

public final class SystemUtil {
    public static final long PID_NOT_FOUND = 0L;
    public static final String NULL_PROPERTY_VALUE = "@null";
    private static final long ONE_GIGABYTE = 0x40000000L;
    private static final long ONE_MEGABYTE = 0x100000L;
    private static final long ONE_KILOBYTE = 1024L;
    private static final long MAX_G_VALUE = 0x1FFFFFFFFL;
    private static final long MAX_M_VALUE = 0x7FFFFFFFFFFL;
    private static final long MAX_K_VALUE = 0x1FFFFFFFFFFFFFL;
    private static final long ONE_MICROSECOND_NS = 1000L;
    private static final long ONE_MILLISECOND_NS = 1000000L;
    private static final long ONE_SECOND_NS = 1000000000L;
    private static final String OS_NAME = System.getProperty("os.name").toLowerCase();
    private static final String OS_ARCH = System.getProperty("os.arch", "unknown");
    private static final long PID = ProcessHandle.current().pid();

    private SystemUtil() {
    }

    public static String osName() {
        return OS_NAME;
    }

    public static String osArch() {
        return OS_ARCH;
    }

    public static long getPid() {
        return PID;
    }

    public static boolean isWindows() {
        return OS_NAME.startsWith("win");
    }

    public static boolean isLinux() {
        return OS_NAME.contains("linux");
    }

    public static boolean isMac() {
        return OS_NAME.startsWith("mac");
    }

    public static boolean isX64Arch() {
        return SystemUtil.isX64Arch(OS_ARCH);
    }

    public static boolean isDebuggerAttached() {
        RuntimeMXBean runtimeMXBean = ManagementFactory.getRuntimeMXBean();
        for (String arg : runtimeMXBean.getInputArguments()) {
            if (!arg.contains("-agentlib:jdwp")) continue;
            return true;
        }
        return false;
    }

    public static String tmpDirName() {
        Object tmpDirName = System.getProperty("java.io.tmpdir");
        if (!((String)tmpDirName).endsWith(File.separator)) {
            tmpDirName = (String)tmpDirName + File.separator;
        }
        return tmpDirName;
    }

    public static String threadDump() {
        StringBuilder sb = new StringBuilder();
        SystemUtil.threadDump(sb);
        return sb.toString();
    }

    public static void threadDump(StringBuilder sb) {
        ThreadMXBean mxBean = ManagementFactory.getThreadMXBean();
        for (ThreadInfo threadInfo : mxBean.getThreadInfo(mxBean.getAllThreadIds(), Integer.MAX_VALUE)) {
            if (null == threadInfo) continue;
            sb.append('\"').append(threadInfo.getThreadName()).append("\": ").append((Object)threadInfo.getThreadState());
            for (StackTraceElement stackTraceElement : threadInfo.getStackTrace()) {
                sb.append("\n    at ").append(stackTraceElement.toString());
            }
            sb.append("\n\n");
        }
    }

    public static void loadPropertiesFile(String filenameOrUrl) {
        SystemUtil.loadPropertiesFile(PropertyAction.REPLACE, filenameOrUrl);
    }

    public static void loadPropertiesFile(PropertyAction propertyAction, String filenameOrUrl) {
        InputStream in3;
        File file;
        URL resource = ClassLoader.getSystemClassLoader().getResource(filenameOrUrl);
        if (null != resource) {
            try (InputStream in22 = resource.openStream();){
                SystemUtil.loadProperties(propertyAction, in22);
            }
            catch (Exception in22) {
                // empty catch block
            }
        }
        if ((file = new File(filenameOrUrl)).exists()) {
            try {
                in3 = Files.newInputStream(file.toPath(), new OpenOption[0]);
                try {
                    SystemUtil.loadProperties(propertyAction, in3);
                }
                finally {
                    if (in3 != null) {
                        in3.close();
                    }
                }
            }
            catch (Exception in3) {
                // empty catch block
            }
        }
        try {
            in3 = new URI(filenameOrUrl).toURL().openStream();
            try {
                SystemUtil.loadProperties(propertyAction, in3);
            }
            finally {
                if (in3 != null) {
                    in3.close();
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void loadPropertiesFiles(String ... filenamesOrUrls) {
        SystemUtil.loadPropertiesFiles(PropertyAction.REPLACE, filenamesOrUrls);
    }

    public static void loadPropertiesFiles(PropertyAction propertyAction, String ... filenamesOrUrls) {
        for (String filenameOrUrl : filenamesOrUrls) {
            SystemUtil.loadPropertiesFile(propertyAction, filenameOrUrl);
        }
    }

    public static String getProperty(String propertyName) {
        String propertyValue = System.getProperty(propertyName);
        return NULL_PROPERTY_VALUE.equals(propertyValue) ? null : propertyValue;
    }

    public static String getProperty(String propertyName, String defaultValue) {
        String propertyValue = System.getProperty(propertyName);
        if (NULL_PROPERTY_VALUE.equals(propertyValue)) {
            return null;
        }
        return null == propertyValue ? defaultValue : propertyValue;
    }

    public static int getSizeAsInt(String propertyName, int defaultValue) {
        String propertyValue = System.getProperty(propertyName);
        if (propertyValue != null) {
            long value = SystemUtil.parseSize(propertyName, propertyValue);
            if (value < 0L || value > Integer.MAX_VALUE) {
                throw new NumberFormatException(propertyName + " must positive and less than Integer.MAX_VALUE: " + value);
            }
            return (int)value;
        }
        return defaultValue;
    }

    public static long getSizeAsLong(String propertyName, long defaultValue) {
        String propertyValue = System.getProperty(propertyName);
        if (propertyValue != null) {
            return SystemUtil.parseSize(propertyName, propertyValue);
        }
        return defaultValue;
    }

    public static long parseSize(String propertyName, String propertyValue) {
        SystemUtil.validateNonNegative(propertyName, propertyValue);
        int suffixIndex = propertyValue.length() - 1;
        char lastCharacter = propertyValue.charAt(suffixIndex);
        if (Character.isDigit(lastCharacter)) {
            return AsciiEncoding.parseLongAscii(propertyValue, 0, propertyValue.length());
        }
        long value = AsciiEncoding.parseLongAscii(propertyValue, 0, suffixIndex);
        return switch (lastCharacter) {
            case 'K', 'k' -> {
                if (value > 0x1FFFFFFFFFFFFFL) {
                    throw new NumberFormatException(propertyName + " would overflow a long: " + propertyValue);
                }
                yield value * 1024L;
            }
            case 'M', 'm' -> {
                if (value > 0x7FFFFFFFFFFL) {
                    throw new NumberFormatException(propertyName + " would overflow a long: " + propertyValue);
                }
                yield value * 0x100000L;
            }
            case 'G', 'g' -> {
                if (value > 0x1FFFFFFFFL) {
                    throw new NumberFormatException(propertyName + " would overflow a long: " + propertyValue);
                }
                yield value * 0x40000000L;
            }
            default -> throw new NumberFormatException(propertyName + ": " + propertyValue + " should end with: k, m, or g.");
        };
    }

    public static String formatSize(long size) {
        long value;
        if (size < 0L) {
            throw new IllegalArgumentException("size must be positive: " + size);
        }
        if (size >= 0x40000000L && size == (value = size / 0x40000000L) * 0x40000000L) {
            return value + "g";
        }
        if (size >= 0x100000L && size == (value = size / 0x100000L) * 0x100000L) {
            return value + "m";
        }
        if (size >= 1024L && size == (value = size / 1024L) * 1024L) {
            return value + "k";
        }
        return Long.toString(size);
    }

    public static long getDurationInNanos(String propertyName, long defaultValue) {
        String propertyValue = System.getProperty(propertyName);
        if (propertyValue != null) {
            return SystemUtil.parseDuration(propertyName, propertyValue);
        }
        return defaultValue;
    }

    public static long parseDuration(String propertyName, String propertyValue) {
        SystemUtil.validateNonNegative(propertyName, propertyValue);
        int length = propertyValue.length();
        char c = propertyValue.charAt(length - 1);
        if (Character.isDigit(c)) {
            return AsciiEncoding.parseLongAscii(propertyValue, 0, length);
        }
        int suffixIndex = length - 1;
        char suffixStartChar = c;
        if ((c == 's' || c == 'S') && length > 1) {
            c = propertyValue.charAt(length - 2);
            if (!Character.isDigit(c)) {
                if (--suffixIndex <= 0) {
                    SystemUtil.throwInvalidDurationFormat(propertyName, propertyValue);
                }
                suffixStartChar = c;
            }
        } else {
            SystemUtil.throwInvalidDurationFormat(propertyName, propertyValue);
        }
        long value = AsciiEncoding.parseLongAscii(propertyValue, 0, suffixIndex);
        return switch (suffixStartChar) {
            case 'N', 'n' -> value;
            case 'U', 'u' -> TimeUnit.MICROSECONDS.toNanos(value);
            case 'M', 'm' -> TimeUnit.MILLISECONDS.toNanos(value);
            case 'S', 's' -> TimeUnit.SECONDS.toNanos(value);
            default -> {
                SystemUtil.throwInvalidDurationFormat(propertyName, propertyValue);
                yield -1L;
            }
        };
    }

    public static String formatDuration(long durationNs) {
        long value;
        if (durationNs < 0L) {
            throw new IllegalArgumentException("duration must be positive: " + durationNs);
        }
        if (durationNs >= 1000000000L && durationNs == (value = durationNs / 1000000000L) * 1000000000L) {
            return value + "s";
        }
        if (durationNs >= 1000000L && durationNs == (value = durationNs / 1000000L) * 1000000L) {
            return value + "ms";
        }
        if (durationNs >= 1000L && durationNs == (value = durationNs / 1000L) * 1000L) {
            return value + "us";
        }
        return durationNs + "ns";
    }

    private static void validateNonNegative(String propertyName, String propertyValue) {
        if (Strings.isEmpty(propertyValue)) {
            throw new NumberFormatException(propertyName + " must be non-empty: " + propertyValue);
        }
        if ('-' == propertyValue.charAt(0)) {
            throw new NumberFormatException(propertyName + " must be positive: " + propertyValue);
        }
    }

    private static void throwInvalidDurationFormat(String propertyName, String propertyValue) {
        throw new NumberFormatException(propertyName + ": " + propertyValue + " should end with: s, ms, us, or ns.");
    }

    static boolean isX64Arch(String arch) {
        return arch.equals("amd64") || arch.equals("x86_64") || arch.equals("x64");
    }

    private static void loadProperties(PropertyAction propertyAction, InputStream in) throws IOException {
        Properties systemProperties = System.getProperties();
        Properties properties = new Properties();
        properties.load(in);
        properties.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(k, v) -> {
            switch (propertyAction) {
                case PRESERVE: {
                    if (systemProperties.containsKey(k)) break;
                    systemProperties.setProperty((String)k, (String)v);
                    break;
                }
                default: {
                    systemProperties.setProperty((String)k, (String)v);
                }
            }
        }));
    }
}

