/*
 * Decompiled with CFR 0.152.
 */
package org.agrona.concurrent;

import java.util.Collection;
import java.util.function.Consumer;
import org.agrona.UnsafeApi;
import org.agrona.concurrent.AbstractConcurrentArrayQueue;

public class ManyToOneConcurrentArrayQueue<E>
extends AbstractConcurrentArrayQueue<E> {
    public ManyToOneConcurrentArrayQueue(int requestedCapacity) {
        super(requestedCapacity);
    }

    @Override
    public boolean offer(E e) {
        long currentTail;
        if (null == e) {
            throw new NullPointerException("element cannot be null");
        }
        int capacity = this.capacity;
        long currentHead = this.sharedHeadCache;
        long bufferLimit = currentHead + (long)capacity;
        do {
            if ((currentTail = this.tail) < bufferLimit) continue;
            currentHead = this.head;
            bufferLimit = currentHead + (long)capacity;
            if (currentTail >= bufferLimit) {
                return false;
            }
            UnsafeApi.putLongRelease(this, SHARED_HEAD_CACHE_OFFSET, currentHead);
        } while (!UnsafeApi.compareAndSetLong(this, TAIL_OFFSET, currentTail, currentTail + 1L));
        UnsafeApi.putReferenceRelease(this.buffer, ManyToOneConcurrentArrayQueue.sequenceToBufferOffset(currentTail, capacity - 1), e);
        return true;
    }

    @Override
    public E poll() {
        Object[] buffer = this.buffer;
        long currentHead = this.head;
        long elementOffset = ManyToOneConcurrentArrayQueue.sequenceToBufferOffset(currentHead, this.capacity - 1);
        Object e = UnsafeApi.getReferenceVolatile(buffer, elementOffset);
        if (null != e) {
            UnsafeApi.putReference(buffer, elementOffset, null);
            UnsafeApi.putLongRelease(this, HEAD_OFFSET, currentHead + 1L);
        }
        return (E)e;
    }

    @Override
    public int drain(Consumer<E> elementConsumer) {
        return this.drain(elementConsumer, (int)(this.tail - this.head));
    }

    @Override
    public int drain(Consumer<E> elementConsumer, int limit) {
        long elementOffset;
        Object item;
        long currentHead;
        Object[] buffer = this.buffer;
        long mask = this.capacity - 1;
        long nextSequence = currentHead = this.head;
        long limitSequence = nextSequence + (long)limit;
        while (nextSequence < limitSequence && null != (item = UnsafeApi.getReferenceVolatile(buffer, elementOffset = ManyToOneConcurrentArrayQueue.sequenceToBufferOffset(nextSequence, mask)))) {
            UnsafeApi.putReferenceRelease(buffer, elementOffset, null);
            UnsafeApi.putLongRelease(this, HEAD_OFFSET, ++nextSequence);
            elementConsumer.accept(item);
        }
        return (int)(nextSequence - currentHead);
    }

    @Override
    public int drainTo(Collection<? super E> target, int limit) {
        long elementOffset;
        Object e;
        int count;
        Object[] buffer = this.buffer;
        long mask = this.capacity - 1;
        long nextSequence = this.head;
        for (count = 0; count < limit && null != (e = UnsafeApi.getReferenceVolatile(buffer, elementOffset = ManyToOneConcurrentArrayQueue.sequenceToBufferOffset(nextSequence, mask))); ++count) {
            UnsafeApi.putReferenceRelease(buffer, elementOffset, null);
            UnsafeApi.putLongRelease(this, HEAD_OFFSET, ++nextSequence);
            target.add(e);
        }
        return count;
    }
}

