/*
 * Decompiled with CFR 0.152.
 */
package org.agrona.shadow.net.bytebuddy.matcher;

import org.agrona.shadow.net.bytebuddy.build.HashCodeAndEqualsPlugin;
import org.agrona.shadow.net.bytebuddy.matcher.ElementMatcher;
import org.agrona.shadow.net.bytebuddy.utility.nullability.MaybeNull;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
@HashCodeAndEqualsPlugin.Enhance
public class FailSafeMatcher<T>
extends ElementMatcher.Junction.AbstractBase<T> {
    private final ElementMatcher<? super T> matcher;
    private final boolean fallback;

    public FailSafeMatcher(ElementMatcher<? super T> matcher, boolean fallback) {
        this.matcher = matcher;
        this.fallback = fallback;
    }

    @Override
    public boolean matches(@MaybeNull T target) {
        try {
            return this.matcher.matches(target);
        }
        catch (Exception ignored) {
            return this.fallback;
        }
    }

    public String toString() {
        return "failSafe(try(" + this.matcher + ") or " + this.fallback + ")";
    }

    public boolean equals(@MaybeNull Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        if (this.fallback != ((FailSafeMatcher)object).fallback) {
            return false;
        }
        return this.matcher.equals(((FailSafeMatcher)object).matcher);
    }

    public int hashCode() {
        return (this.getClass().hashCode() * 31 + this.matcher.hashCode()) * 31 + this.fallback;
    }
}

