/*
 * Decompiled with CFR 0.152.
 */
package org.agrona.shadow.net.bytebuddy.asm;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import org.agrona.shadow.net.bytebuddy.ClassFileVersion;
import org.agrona.shadow.net.bytebuddy.asm.AsmVisitorWrapper;
import org.agrona.shadow.net.bytebuddy.description.field.FieldDescription;
import org.agrona.shadow.net.bytebuddy.description.field.FieldList;
import org.agrona.shadow.net.bytebuddy.description.method.MethodList;
import org.agrona.shadow.net.bytebuddy.description.type.TypeDescription;
import org.agrona.shadow.net.bytebuddy.implementation.Implementation;
import org.agrona.shadow.net.bytebuddy.jar.asm.ClassVisitor;
import org.agrona.shadow.net.bytebuddy.jar.asm.MethodVisitor;
import org.agrona.shadow.net.bytebuddy.jar.asm.Type;
import org.agrona.shadow.net.bytebuddy.pool.TypePool;
import org.agrona.shadow.net.bytebuddy.utility.OpenedClassReader;
import org.agrona.shadow.net.bytebuddy.utility.nullability.MaybeNull;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public enum TypeConstantAdjustment implements AsmVisitorWrapper
{
    INSTANCE;


    @Override
    public int mergeWriter(int flags) {
        return flags;
    }

    @Override
    public int mergeReader(int flags) {
        return flags;
    }

    @Override
    public ClassVisitor wrap(TypeDescription instrumentedType, ClassVisitor classVisitor, Implementation.Context implementationContext, TypePool typePool, FieldList<FieldDescription.InDefinedShape> fields, MethodList<?> methods, int writerFlags, int readerFlags) {
        return new TypeConstantDissolvingClassVisitor(classVisitor);
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    protected static class TypeConstantDissolvingClassVisitor
    extends ClassVisitor {
        private boolean supportsTypeConstants;

        protected TypeConstantDissolvingClassVisitor(ClassVisitor classVisitor) {
            super(OpenedClassReader.ASM_API, classVisitor);
        }

        @Override
        public void visit(int version, int modifiers, String name, @MaybeNull String signature, @MaybeNull String superClassName, @MaybeNull String[] interfaceName) {
            this.supportsTypeConstants = ClassFileVersion.ofMinorMajor(version).isAtLeast(ClassFileVersion.JAVA_V5);
            super.visit(version, modifiers, name, signature, superClassName, interfaceName);
        }

        @Override
        @MaybeNull
        public MethodVisitor visitMethod(int modifiers, String name, String descriptor, @MaybeNull String signature, @MaybeNull String[] exception) {
            MethodVisitor methodVisitor = super.visitMethod(modifiers, name, descriptor, signature, exception);
            return this.supportsTypeConstants || methodVisitor == null ? methodVisitor : new TypeConstantDissolvingMethodVisitor(methodVisitor);
        }

        /*
         * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
         */
        protected static class TypeConstantDissolvingMethodVisitor
        extends MethodVisitor {
            private static final String JAVA_LANG_CLASS = "java/lang/Class";
            private static final String FOR_NAME = "forName";
            private static final String DESCRIPTOR = "(Ljava/lang/String;)Ljava/lang/Class;";

            protected TypeConstantDissolvingMethodVisitor(MethodVisitor methodVisitor) {
                super(OpenedClassReader.ASM_API, methodVisitor);
            }

            @Override
            @SuppressFBWarnings(value={"SF_SWITCH_NO_DEFAULT"}, justification="Fall through to default case is intentional.")
            public void visitLdcInsn(Object value) {
                if (value instanceof Type) {
                    Type type = (Type)value;
                    switch (type.getSort()) {
                        case 9: 
                        case 10: {
                            super.visitLdcInsn(type.getInternalName().replace('/', '.'));
                            super.visitMethodInsn(184, JAVA_LANG_CLASS, FOR_NAME, DESCRIPTOR, false);
                            return;
                        }
                    }
                }
                super.visitLdcInsn(value);
            }
        }
    }
}

