/*
 * Decompiled with CFR 0.152.
 */
package org.agrona.concurrent.status;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.agrona.UnsafeApi;
import org.agrona.concurrent.AtomicBuffer;
import org.agrona.concurrent.status.CountersManager;

public class AtomicCounter
implements AutoCloseable {
    private boolean isClosed = false;
    private final int id;
    private final long addressOffset;
    private final byte[] byteArray;
    private CountersManager countersManager;
    private final ByteBuffer byteBuffer;

    public AtomicCounter(AtomicBuffer buffer, int counterId) {
        this(buffer, counterId, null);
    }

    public AtomicCounter(AtomicBuffer buffer, int counterId, CountersManager countersManager) {
        this.id = counterId;
        this.countersManager = countersManager;
        this.byteBuffer = buffer.byteBuffer();
        this.byteArray = buffer.byteArray();
        int counterOffset = CountersManager.counterOffset(counterId);
        buffer.boundsCheck(counterOffset, 8);
        this.addressOffset = buffer.addressOffset() + (long)counterOffset;
    }

    public int id() {
        return this.id;
    }

    public void disconnectCountersManager() {
        this.countersManager = null;
    }

    @Override
    public void close() {
        if (!this.isClosed) {
            this.isClosed = true;
            if (null != this.countersManager) {
                this.countersManager.free(this.id);
            }
        }
    }

    public boolean isClosed() {
        return this.isClosed;
    }

    public String label() {
        return null != this.countersManager ? this.countersManager.getCounterLabel(this.id) : null;
    }

    public void updateLabel(String newLabel) {
        if (null == this.countersManager) {
            throw new IllegalStateException("Not constructed with CountersManager");
        }
        this.countersManager.setCounterLabel(this.id, newLabel);
    }

    public AtomicCounter appendToLabel(String suffix) {
        if (null == this.countersManager) {
            throw new IllegalStateException("Not constructed with CountersManager");
        }
        this.countersManager.appendToLabel(this.id, suffix);
        return this;
    }

    public void updateKey(Consumer<MutableDirectBuffer> keyFunc) {
        if (null == this.countersManager) {
            throw new IllegalStateException("Not constructed with CountersManager");
        }
        this.countersManager.setCounterKey(this.id, keyFunc);
    }

    public void updateKey(DirectBuffer keyBuffer, int offset, int length) {
        if (null == this.countersManager) {
            throw new IllegalStateException("Not constructed with CountersManager");
        }
        this.countersManager.setCounterKey(this.id, keyBuffer, offset, length);
    }

    public long increment() {
        return UnsafeApi.getAndAddLong(this.byteArray, this.addressOffset, 1L);
    }

    public long incrementOrdered() {
        return this.incrementRelease();
    }

    public long incrementRelease() {
        byte[] array = this.byteArray;
        long offset = this.addressOffset;
        long currentValue = UnsafeApi.getLong(array, offset);
        UnsafeApi.putLongRelease(array, offset, currentValue + 1L);
        return currentValue;
    }

    public long incrementOpaque() {
        byte[] array = this.byteArray;
        long offset = this.addressOffset;
        long currentValue = UnsafeApi.getLong(array, offset);
        UnsafeApi.putLongOpaque(array, offset, currentValue + 1L);
        return currentValue;
    }

    public long incrementPlain() {
        byte[] array = this.byteArray;
        long offset = this.addressOffset;
        long currentValue = UnsafeApi.getLong(array, offset);
        UnsafeApi.putLong(array, offset, currentValue + 1L);
        return currentValue;
    }

    public long decrement() {
        return UnsafeApi.getAndAddLong(this.byteArray, this.addressOffset, -1L);
    }

    public long decrementOrdered() {
        return this.decrementRelease();
    }

    public long decrementRelease() {
        byte[] array = this.byteArray;
        long offset = this.addressOffset;
        long currentValue = UnsafeApi.getLong(array, offset);
        UnsafeApi.putLongRelease(array, offset, currentValue - 1L);
        return currentValue;
    }

    public long decrementOpaque() {
        byte[] array = this.byteArray;
        long offset = this.addressOffset;
        long currentValue = UnsafeApi.getLong(array, offset);
        UnsafeApi.putLongOpaque(array, offset, currentValue - 1L);
        return currentValue;
    }

    public long decrementPlain() {
        byte[] array = this.byteArray;
        long offset = this.addressOffset;
        long currentValue = UnsafeApi.getLong(array, offset);
        UnsafeApi.putLong(array, offset, currentValue - 1L);
        return currentValue;
    }

    public void set(long value) {
        UnsafeApi.putLongVolatile(this.byteArray, this.addressOffset, value);
    }

    public void setOrdered(long value) {
        this.setRelease(value);
    }

    public void setRelease(long value) {
        UnsafeApi.putLongRelease(this.byteArray, this.addressOffset, value);
    }

    public void setOpaque(long value) {
        UnsafeApi.putLongOpaque(this.byteArray, this.addressOffset, value);
    }

    public void setWeak(long value) {
        this.setPlain(value);
    }

    public void setPlain(long value) {
        UnsafeApi.putLong(this.byteArray, this.addressOffset, value);
    }

    public long getAndAdd(long increment) {
        return UnsafeApi.getAndAddLong(this.byteArray, this.addressOffset, increment);
    }

    public long getAndAddOrdered(long increment) {
        return this.getAndAddRelease(increment);
    }

    public long getAndAddRelease(long increment) {
        byte[] array = this.byteArray;
        long offset = this.addressOffset;
        long currentValue = UnsafeApi.getLong(array, offset);
        UnsafeApi.putLongRelease(array, offset, currentValue + increment);
        return currentValue;
    }

    public long getAndAddOpaque(long increment) {
        byte[] array = this.byteArray;
        long offset = this.addressOffset;
        long currentValue = UnsafeApi.getLong(array, offset);
        UnsafeApi.putLongOpaque(array, offset, currentValue + increment);
        return currentValue;
    }

    public long getAndAddPlain(long increment) {
        byte[] array = this.byteArray;
        long offset = this.addressOffset;
        long currentValue = UnsafeApi.getLong(array, offset);
        UnsafeApi.putLong(array, offset, currentValue + increment);
        return currentValue;
    }

    public long getAndSet(long value) {
        return UnsafeApi.getAndSetLong(this.byteArray, this.addressOffset, value);
    }

    public boolean compareAndSet(long expectedValue, long updateValue) {
        return UnsafeApi.compareAndSetLong(this.byteArray, this.addressOffset, expectedValue, updateValue);
    }

    public long get() {
        return UnsafeApi.getLongVolatile(this.byteArray, this.addressOffset);
    }

    public long getAcquire() {
        return UnsafeApi.getLongAcquire(this.byteArray, this.addressOffset);
    }

    public long getOpaque() {
        return UnsafeApi.getLongOpaque(this.byteArray, this.addressOffset);
    }

    public long getWeak() {
        return this.getPlain();
    }

    public long getPlain() {
        return UnsafeApi.getLong(this.byteArray, this.addressOffset);
    }

    public boolean proposeMax(long proposedValue) {
        boolean updated = false;
        byte[] array = this.byteArray;
        long offset = this.addressOffset;
        if (UnsafeApi.getLong(array, offset) < proposedValue) {
            UnsafeApi.putLong(array, offset, proposedValue);
            updated = true;
        }
        return updated;
    }

    public boolean proposeMaxOrdered(long proposedValue) {
        return this.proposeMaxRelease(proposedValue);
    }

    public boolean proposeMaxRelease(long proposedValue) {
        boolean updated = false;
        byte[] array = this.byteArray;
        long offset = this.addressOffset;
        if (UnsafeApi.getLong(array, offset) < proposedValue) {
            UnsafeApi.putLongRelease(array, offset, proposedValue);
            updated = true;
        }
        return updated;
    }

    public boolean proposeMaxOpaque(long proposedValue) {
        boolean updated = false;
        byte[] array = this.byteArray;
        long offset = this.addressOffset;
        if (UnsafeApi.getLong(array, offset) < proposedValue) {
            UnsafeApi.putLongOpaque(array, offset, proposedValue);
            updated = true;
        }
        return updated;
    }

    public String toString() {
        return "AtomicCounter{isClosed=" + this.isClosed() + ", id=" + this.id + ", value=" + (this.isClosed() ? -1L : this.get()) + ", countersManager=" + String.valueOf(this.countersManager) + "}";
    }
}

