/*
 * Decompiled with CFR 0.152.
 */
package org.agrona.shadow.net.bytebuddy.utility;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.List;
import org.agrona.shadow.net.bytebuddy.ClassFileVersion;
import org.agrona.shadow.net.bytebuddy.build.AccessControllerPlugin;
import org.agrona.shadow.net.bytebuddy.build.HashCodeAndEqualsPlugin;
import org.agrona.shadow.net.bytebuddy.description.type.TypeDescription;
import org.agrona.shadow.net.bytebuddy.jar.asm.ClassReader;
import org.agrona.shadow.net.bytebuddy.jar.asm.ClassVisitor;
import org.agrona.shadow.net.bytebuddy.jar.asm.ClassWriter;
import org.agrona.shadow.net.bytebuddy.pool.TypePool;
import org.agrona.shadow.net.bytebuddy.utility.AsmClassReader;
import org.agrona.shadow.net.bytebuddy.utility.dispatcher.JavaDispatcher;
import org.agrona.shadow.net.bytebuddy.utility.nullability.AlwaysNull;
import org.agrona.shadow.net.bytebuddy.utility.nullability.MaybeNull;
import org.agrona.shadow.net.bytebuddy.utility.privilege.GetSystemPropertyAction;

public interface AsmClassWriter {
    public ClassVisitor getVisitor();

    public byte[] getBinaryRepresentation();

    public static class SuperClassResolvingJdkClassWriter {
        protected static final Method GET_SUPER_CLASS;
        private final TypePool typePool;

        public SuperClassResolvingJdkClassWriter(TypePool typePool) {
            this.typePool = typePool;
        }

        @MaybeNull
        @SuppressFBWarnings(value={"NP_NULL_ON_SOME_PATH_FROM_RETURN_VALUE"}, justification="Object class can never be passed.")
        public String getSuperClass(String internalName) {
            TypeDescription typeDescription = this.typePool.describe(internalName.replace('/', '.')).resolve();
            return typeDescription.isInterface() ? null : typeDescription.getSuperClass().asErasure().getInternalName();
        }

        static {
            Method getSuperClass;
            try {
                getSuperClass = SuperClassResolvingJdkClassWriter.class.getMethod("getSuperClass", String.class);
            }
            catch (NoSuchMethodException e) {
                throw new IllegalStateException("Failed to resolve own method", e);
            }
            GET_SUPER_CLASS = getSuperClass;
        }
    }

    public static class FrameComputingClassWriter
    extends ClassWriter {
        private final TypePool typePool;

        public FrameComputingClassWriter(int flags, TypePool typePool) {
            super(flags);
            this.typePool = typePool;
        }

        public FrameComputingClassWriter(ClassReader classReader, int flags, TypePool typePool) {
            super(classReader, flags);
            this.typePool = typePool;
        }

        protected String getCommonSuperClass(String leftTypeName, String rightTypeName) {
            TypeDescription.Generic superClass;
            TypeDescription rightType;
            TypeDescription leftType = this.typePool.describe(leftTypeName.replace('/', '.')).resolve();
            if (leftType.isAssignableFrom(rightType = this.typePool.describe(rightTypeName.replace('/', '.')).resolve())) {
                return leftType.getInternalName();
            }
            if (leftType.isAssignableTo(rightType)) {
                return rightType.getInternalName();
            }
            if (leftType.isInterface() || rightType.isInterface()) {
                return TypeDescription.ForLoadedType.of(Object.class).getInternalName();
            }
            do {
                if ((superClass = leftType.getSuperClass()) != null) continue;
                return TypeDescription.ForLoadedType.of(Object.class).getInternalName();
            } while (!(leftType = superClass.asErasure()).isAssignableFrom(rightType));
            return leftType.getInternalName();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ForClassFileApi
    implements AsmClassWriter {
        private static final JdkClassWriter DISPATCHER;
        private final ClassVisitor classWriter;
        private static final boolean ACCESS_CONTROLLER;

        public ForClassFileApi(ClassVisitor classWriter) {
            if (!DISPATCHER.isInstance(classWriter)) {
                throw new IllegalArgumentException("Not a JDK class writer: " + classWriter);
            }
            this.classWriter = classWriter;
        }

        @AccessControllerPlugin.Enhance
        private static <T> T doPrivileged(PrivilegedAction<T> privilegedAction) {
            PrivilegedAction<T> action;
            if (ACCESS_CONTROLLER) {
                return AccessController.doPrivileged(privilegedAction);
            }
            return action.run();
        }

        @Override
        public ClassVisitor getVisitor() {
            return this.classWriter;
        }

        @Override
        public byte[] getBinaryRepresentation() {
            return DISPATCHER.toByteArray(this.classWriter);
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        static {
            try {
                Class.forName("java.security.AccessController", false, null);
                ACCESS_CONTROLLER = Boolean.parseBoolean(System.getProperty("org.agrona.shadow.net.bytebuddy.securitymanager", "true"));
            }
            catch (ClassNotFoundException classNotFoundException) {
                ACCESS_CONTROLLER = false;
            }
            catch (SecurityException securityException) {
                ACCESS_CONTROLLER = true;
            }
            DISPATCHER = ForClassFileApi.doPrivileged(JavaDispatcher.of(JdkClassWriter.class, ForClassFileApi.class.getClassLoader()));
        }

        @JavaDispatcher.Proxied(value="org.agrona.shadow.net.bytebuddy.jar.asmjdkbridge.JdkClassWriter")
        protected static interface JdkClassWriter {
            @JavaDispatcher.Instance
            @JavaDispatcher.Proxied(value="isInstance")
            public boolean isInstance(ClassVisitor var1);

            @JavaDispatcher.IsConstructor
            @JavaDispatcher.Proxied(value="make")
            public ClassVisitor make(int var1, Method var2, Object var3);

            @JavaDispatcher.IsConstructor
            @JavaDispatcher.Proxied(value="make")
            public ClassVisitor make(@JavaDispatcher.Proxied(value="org.agrona.shadow.net.bytebuddy.jar.asmjdkbridge.JdkClassReader") Object var1, int var2, Method var3, Object var4);

            @JavaDispatcher.Proxied(value="toByteArray")
            public byte[] toByteArray(ClassVisitor var1);
        }
    }

    public static class ForAsm
    implements AsmClassWriter {
        private final ClassWriter classWriter;

        public ForAsm(ClassWriter classWriter) {
            this.classWriter = classWriter;
        }

        public ClassVisitor getVisitor() {
            return this.classWriter;
        }

        public byte[] getBinaryRepresentation() {
            return this.classWriter.toByteArray();
        }
    }

    public static interface Factory {
        public AsmClassWriter make(int var1);

        public AsmClassWriter make(int var1, AsmClassReader var2);

        public AsmClassWriter make(int var1, TypePool var2);

        public AsmClassWriter make(int var1, AsmClassReader var2, TypePool var3);

        @HashCodeAndEqualsPlugin.Enhance
        public static class Suppressing
        implements Factory {
            private final Factory delegate;

            public Suppressing(Factory delegate) {
                this.delegate = delegate;
            }

            public AsmClassWriter make(int flags) {
                return this.delegate.make(flags);
            }

            public AsmClassWriter make(int flags, AsmClassReader classReader) {
                return this.delegate.make(flags);
            }

            public AsmClassWriter make(int flags, TypePool typePool) {
                return this.delegate.make(flags, typePool);
            }

            public AsmClassWriter make(int flags, AsmClassReader classReader, TypePool typePool) {
                return this.delegate.make(flags, typePool);
            }

            public boolean equals(@MaybeNull Object object) {
                if (this == object) {
                    return true;
                }
                if (object == null) {
                    return false;
                }
                if (this.getClass() != object.getClass()) {
                    return false;
                }
                return this.delegate.equals(((Suppressing)object).delegate);
            }

            public int hashCode() {
                return this.getClass().hashCode() * 31 + this.delegate.hashCode();
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static abstract class Default
        extends Enum<Default>
        implements Factory {
            public static final /* enum */ Default IMPLICIT;
            public static final /* enum */ Default ASM_FIRST;
            public static final /* enum */ Default CLASS_FILE_API_FIRST;
            public static final /* enum */ Default ASM_ONLY;
            public static final /* enum */ Default CLASS_FILE_API_ONLY;
            @MaybeNull
            private static final Class<?> JDK_CLASS_READER;
            private static final Factory FACTORY;
            private static final /* synthetic */ Default[] $VALUES;
            private static final boolean ACCESS_CONTROLLER;

            public static Default[] values() {
                return (Default[])$VALUES.clone();
            }

            public static Default valueOf(String name) {
                return Enum.valueOf(Default.class, name);
            }

            @MaybeNull
            @AccessControllerPlugin.Enhance
            private static <T> T doPrivileged(PrivilegedAction<T> privilegedAction) {
                PrivilegedAction<T> action;
                if (ACCESS_CONTROLLER) {
                    return AccessController.doPrivileged(privilegedAction);
                }
                return action.run();
            }

            @Override
            public AsmClassWriter make(int flags) {
                return this.make(flags, TypePool.Empty.INSTANCE);
            }

            @Override
            public AsmClassWriter make(int flags, AsmClassReader classReader) {
                return this.make(flags, classReader, TypePool.Empty.INSTANCE);
            }

            @Override
            public AsmClassWriter make(int flags, TypePool typePool) {
                return this.make(flags, EmptyAsmClassReader.INSTANCE, typePool);
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            static {
                Class<?> type;
                String processor;
                try {
                    Class.forName("java.security.AccessController", false, null);
                    ACCESS_CONTROLLER = Boolean.parseBoolean(System.getProperty("org.agrona.shadow.net.bytebuddy.securitymanager", "true"));
                }
                catch (ClassNotFoundException classNotFoundException) {
                    ACCESS_CONTROLLER = false;
                }
                catch (SecurityException securityException) {
                    ACCESS_CONTROLLER = true;
                }
                IMPLICIT = new Default(){

                    public AsmClassWriter make(int flags, AsmClassReader classReader, TypePool typePool) {
                        return (FACTORY == IMPLICIT ? ASM_FIRST : FACTORY).make(flags, classReader, typePool);
                    }
                };
                ASM_FIRST = new Default(){

                    public AsmClassWriter make(int flags, AsmClassReader classReader, TypePool typePool) {
                        return ClassFileVersion.ofThisVm().isGreaterThan(ClassFileVersion.latest()) ? CLASS_FILE_API_ONLY.make(flags, classReader, typePool) : ASM_ONLY.make(flags, classReader, typePool);
                    }
                };
                CLASS_FILE_API_FIRST = new Default(){

                    public AsmClassWriter make(int flags, AsmClassReader classReader, TypePool typePool) {
                        return ClassFileVersion.ofThisVm().isAtLeast(ClassFileVersion.JAVA_V24) ? CLASS_FILE_API_ONLY.make(flags, classReader, typePool) : ASM_ONLY.make(flags, classReader, typePool);
                    }
                };
                ASM_ONLY = new Default(){

                    public AsmClassWriter make(int flags, AsmClassReader classReader, TypePool typePool) {
                        ClassReader unwrapped = classReader.unwrap(ClassReader.class);
                        return new ForAsm(unwrapped == null ? new FrameComputingClassWriter(flags, typePool) : new FrameComputingClassWriter(unwrapped, flags, typePool));
                    }
                };
                CLASS_FILE_API_ONLY = new Default(){

                    @SuppressFBWarnings(value={"NP_NULL_ON_SOME_PATH_FROM_RETURN_VALUE"}, justification="False positive in FindBugs.")
                    public AsmClassWriter make(int flags, AsmClassReader classReader, TypePool typePool) {
                        Object jdkClassReader;
                        Object v0 = jdkClassReader = JDK_CLASS_READER == null ? null : classReader.unwrap(JDK_CLASS_READER);
                        if (jdkClassReader == null) {
                            return new ForClassFileApi(ForClassFileApi.DISPATCHER.make(flags, SuperClassResolvingJdkClassWriter.GET_SUPER_CLASS, new SuperClassResolvingJdkClassWriter(typePool)));
                        }
                        return new ForClassFileApi(ForClassFileApi.DISPATCHER.make(jdkClassReader, flags, SuperClassResolvingJdkClassWriter.GET_SUPER_CLASS, new SuperClassResolvingJdkClassWriter(typePool)));
                    }
                };
                $VALUES = new Default[]{IMPLICIT, ASM_FIRST, CLASS_FILE_API_FIRST, ASM_ONLY, CLASS_FILE_API_ONLY};
                try {
                    processor = Default.doPrivileged(new GetSystemPropertyAction("org.agrona.shadow.net.bytebuddy.processor"));
                }
                catch (Throwable ignored) {
                    processor = null;
                }
                FACTORY = processor == null ? ASM_FIRST : Default.valueOf(processor);
                try {
                    type = ClassFileVersion.ofThisVm().isAtLeast(ClassFileVersion.JAVA_V24) ? Class.forName("org.agrona.shadow.net.bytebuddy.jar.asmjdkbridge.JdkClassReader") : null;
                }
                catch (ClassNotFoundException ignored) {
                    type = null;
                }
                JDK_CLASS_READER = type;
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public static class NonRetainingAsmClassReader
            implements AsmClassReader {
                private final AsmClassReader delegate;

                public NonRetainingAsmClassReader(AsmClassReader delegate) {
                    this.delegate = delegate;
                }

                @Override
                @MaybeNull
                public <T> T unwrap(Class<T> type) {
                    return this.delegate.unwrap(type);
                }

                @AlwaysNull
                public AsmClassWriter toWriter(int flags, TypePool typePool) {
                    return null;
                }

                @Override
                public int getModifiers() {
                    return this.delegate.getModifiers();
                }

                @Override
                public String getInternalName() {
                    return this.delegate.getInternalName();
                }

                @Override
                @MaybeNull
                public String getSuperClassInternalName() {
                    return this.delegate.getSuperClassInternalName();
                }

                @Override
                public List<String> getInterfaceInternalNames() {
                    return this.delegate.getInterfaceInternalNames();
                }

                @Override
                public void accept(ClassVisitor classVisitor, int flags) {
                    this.delegate.accept(classVisitor, flags);
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            protected static enum EmptyAsmClassReader implements AsmClassReader
            {
                INSTANCE;


                @AlwaysNull
                public AsmClassWriter toWriter(int flags, TypePool typePool) {
                    return null;
                }

                @Override
                @AlwaysNull
                public <T> T unwrap(Class<T> type) {
                    return null;
                }

                @Override
                public int getModifiers() {
                    throw new UnsupportedOperationException();
                }

                @Override
                public String getInternalName() {
                    throw new UnsupportedOperationException();
                }

                @Override
                public String getSuperClassInternalName() {
                    throw new UnsupportedOperationException();
                }

                @Override
                public List<String> getInterfaceInternalNames() {
                    throw new UnsupportedOperationException();
                }

                @Override
                public void accept(ClassVisitor classVisitor, int flags) {
                    throw new UnsupportedOperationException();
                }
            }
        }
    }
}

