/*
 * Decompiled with CFR 0.152.
 */
package org.agrona.concurrent.status;

import java.nio.ByteBuffer;
import org.agrona.UnsafeApi;
import org.agrona.concurrent.AtomicBuffer;
import org.agrona.concurrent.status.CountersManager;
import org.agrona.concurrent.status.StatusIndicator;

public class UnsafeBufferStatusIndicator
extends StatusIndicator {
    private final int counterId;
    private final long addressOffset;
    private final byte[] byteArray;
    private final ByteBuffer byteBuffer;

    public UnsafeBufferStatusIndicator(AtomicBuffer buffer, int counterId) {
        this.counterId = counterId;
        this.byteArray = buffer.byteArray();
        this.byteBuffer = buffer.byteBuffer();
        int counterOffset = CountersManager.counterOffset(counterId);
        buffer.boundsCheck(counterOffset, 8);
        this.addressOffset = buffer.addressOffset() + (long)counterOffset;
    }

    @Override
    public int id() {
        return this.counterId;
    }

    @Override
    public void setVolatile(long value) {
        UnsafeApi.putLongVolatile(this.byteArray, this.addressOffset, value);
    }

    @Override
    public void setOrdered(long value) {
        this.setRelease(value);
    }

    @Override
    public void setRelease(long value) {
        UnsafeApi.putLongRelease(this.byteArray, this.addressOffset, value);
    }

    @Override
    public void setOpaque(long value) {
        UnsafeApi.putLongOpaque(this.byteArray, this.addressOffset, value);
    }

    @Override
    public long getVolatile() {
        return UnsafeApi.getLongVolatile(this.byteArray, this.addressOffset);
    }

    @Override
    public long getAcquire() {
        return UnsafeApi.getLongAcquire(this.byteArray, this.addressOffset);
    }

    @Override
    public long getOpaque() {
        return UnsafeApi.getLongOpaque(this.byteArray, this.addressOffset);
    }

    public String toString() {
        return "UnsafeBufferStatusIndicator{counterId=" + this.counterId + "value=" + this.getVolatile() + "}";
    }
}

