/*
 * Decompiled with CFR 0.152.
 */
package org.agrona.agent;

import org.agrona.DirectBuffer;
import org.agrona.agent.BufferAlignmentException;
import org.agrona.shadow.net.bytebuddy.asm.Advice;

public final class BufferAlignmentInterceptor {
    private BufferAlignmentInterceptor() {
    }

    public static final class CharVerifier {
        private CharVerifier() {
        }

        @Advice.OnMethodEnter
        public static void verifyAlignment(int index, @Advice.This DirectBuffer buffer) {
            if (0L != (buffer.addressOffset() + (long)index & 1L)) {
                throw new BufferAlignmentException("Unaligned char access", index, buffer.addressOffset());
            }
        }
    }

    public static final class ShortVerifier {
        private ShortVerifier() {
        }

        @Advice.OnMethodEnter
        public static void verifyAlignment(int index, @Advice.This DirectBuffer buffer) {
            if (0L != (buffer.addressOffset() + (long)index & 1L)) {
                throw new BufferAlignmentException("Unaligned short access", index, buffer.addressOffset());
            }
        }
    }

    public static final class FloatVerifier {
        private FloatVerifier() {
        }

        @Advice.OnMethodEnter
        public static void verifyAlignment(int index, @Advice.This DirectBuffer buffer) {
            if (0L != (buffer.addressOffset() + (long)index & 3L)) {
                throw new BufferAlignmentException("Unaligned float access", index, buffer.addressOffset());
            }
        }
    }

    public static final class IntVerifier {
        private IntVerifier() {
        }

        @Advice.OnMethodEnter
        public static void verifyAlignment(int index, @Advice.This DirectBuffer buffer) {
            if (0L != (buffer.addressOffset() + (long)index & 3L)) {
                throw new BufferAlignmentException("Unaligned int access", index, buffer.addressOffset());
            }
        }
    }

    public static final class DoubleVerifier {
        private DoubleVerifier() {
        }

        @Advice.OnMethodEnter
        public static void verifyAlignment(int index, @Advice.This DirectBuffer buffer) {
            if (0L != (buffer.addressOffset() + (long)index & 7L)) {
                throw new BufferAlignmentException("Unaligned double access", index, buffer.addressOffset());
            }
        }
    }

    public static final class LongVerifier {
        private LongVerifier() {
        }

        @Advice.OnMethodEnter
        public static void verifyAlignment(int index, @Advice.This DirectBuffer buffer) {
            if (0L != (buffer.addressOffset() + (long)index & 7L)) {
                throw new BufferAlignmentException("Unaligned long access", index, buffer.addressOffset());
            }
        }
    }
}

